/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.access;

import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.SendMessageAble;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminActionWorker;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.access.AccessConfigUI;
import fr.ird.observe.ui.admin.access.AccessModel;
import fr.ird.observe.ui.admin.access.AccessUI;
import fr.ird.observe.ui.admin.access.AnalyzeAccessUI;
import fr.ird.observe.ui.admin.config.ConfigUI;
import fr.ird.observe.ui.storage.StorageUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class AccessUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(AccessUIHandler.class);

    public AccessUIHandler(AdminTabUI ui) {
        super(ui);
    }

    public void initTabUI(AdminUI ui, AnalyzeAccessUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        tabUI.getStartButton().setText(I18n._((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n._((String)tabUI.getStep().getOperationLabel(), (Object[])new Object[0])}));
        if (log.isInfoEnabled()) {
            log.info((Object)("Init extra configuration for " + tabUI.getName()));
        }
        ConfigUI configUI = (ConfigUI)ui.getStepUI(AdminStep.CONFIG);
        JAXXInitialContext tx = new JAXXInitialContext().add((Object)configUI).add((Object)this);
        AccessConfigUI extraConfig = new AccessConfigUI((JAXXContext)tx);
        configUI.getExtraConfig().add(extraConfig);
    }

    public void initTabUI(AdminUI ui, AccessUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        tabUI.getStartButton().setText(I18n._((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n._((String)tabUI.getStep().getOperationLabel(), (Object[])new Object[0])}));
        Decorator programmeDecorator = this.getDecoratorService().getDecorator(Programme.class);
        BeanComboBox<Programme> programmeCombo = tabUI.getSelectProgramme();
        programmeCombo.init((JXPathDecorator)programmeDecorator, new ArrayList());
        Decorator oceanDecorator = this.getDecoratorService().getDecorator(Ocean.class);
        BeanComboBox<Ocean> oceanCombo = tabUI.getSelectOcean();
        oceanCombo.init((JXPathDecorator)oceanDecorator, new ArrayList());
    }

    public void startAnalyzeAction() {
        AnalyzeAccessUI tabUI = (AnalyzeAccessUI)this.ui;
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = tabUI.getStartButton().getToolTipText();
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return AccessUIHandler.this.doAnalyzeAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    public void startImportAction() {
        AccessUI tabUI = (AccessUI)this.ui;
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = tabUI.getStartButton().getToolTipText();
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return AccessUIHandler.this.doImportAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    public WizardState doAnalyzeAction() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        try {
            this.analyzeAccessDB(this.getStepModel());
        }
        catch (Exception e) {
            this.getUi().getStepModel().setError(e);
            return WizardState.FAILED;
        }
        this.sendMessage(I18n._((String)"observe.message.analyze.access.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }

    public WizardState doImportAction() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        try {
            AccessModel model = this.getStepModel();
            this.prepareStorage(model);
            DataSource source = model.getTmpSource();
            this.getAccessImporterService().importAccessDB(model.getImportModel(), (SendMessageAble)this, (JFrame)ObserveContext.get().getObserveMainUI(), ((AccessUI)this.getUi()).getProgressPopup(), true);
            StorageUIHandler storageHandler = this.ui.getContextValue(StorageUIHandler.class);
            storageHandler.backupLocalDatabase(source, model.getOutputFile(), null);
        }
        catch (Exception e) {
            this.getUi().getStepModel().setError(e);
            return WizardState.FAILED;
        }
        this.sendMessage(I18n._((String)"observe.message.access.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }

    public void analyzeAccessDB(AccessModel model) throws Exception {
        PropertyChangeListener createListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                Long newValue = (Long)evt.getNewValue();
                String message = "[" + property + "] find " + newValue + " objects to import.";
                if (log.isInfoEnabled()) {
                    log.info((Object)message);
                }
            }
        };
        this.getAccessImporterService().analyzeAccessDB(model.getImportModel(), (SendMessageAble)this, createListener);
    }

    protected void prepareStorage(AccessModel stepModel) throws Exception {
        DataSource tmpSource = this.model.getSafeTmpSource(false);
        DataSource centralSource = this.getCentralSource();
        this.openSource(tmpSource);
        this.openSource(centralSource);
        this.getAccessImporterService().prepareOutputSource(stepModel.getImportModel(), tmpSource, centralSource);
    }

    protected DataSource getCentralSource() {
        DataSource centralSource = this.getStepModel().getCentralSource();
        if (centralSource == null) {
            centralSource = this.model.getSafeCentralSource(false);
            this.getStepModel().setCentralSource(centralSource);
        }
        return centralSource;
    }

    protected AccessModel getStepModel() {
        return this.model.getAccessModel();
    }

    public void chooseImportFile() {
        AccessModel model = this.getModel().getAccessModel();
        File f = UIHelper.chooseFile(this.ui, I18n._((String)"observe.title.choose.importAccess", (Object[])new Object[0]), I18n._((String)"observe.action.choose.importAccess", (Object[])new Object[0]), model.getImportFile(), "^.+\\.mdb$", I18n._((String)"observe.action.choose.importAccess.description", (Object[])new Object[0]));
        model.setImportFile(f);
    }

    public void chooseOutputFileDirectory(AccessConfigUI ui) {
        File f = UIHelper.chooseDirectory(this.getUi(), I18n._((String)"observe.title.choose.db.dump.directory", (Object[])new Object[0]), I18n._((String)"observe.action.choose.db.dump.directory", (Object[])new Object[0]), new File(ui.getOutputFileDirectoryText().getText()));
        this.changeOutputFileDirectory(ui, f);
    }

    public void changeOutputFileDirectory(AccessConfigUI ui, File f) {
        ui.getAccessModel().setOutputFile(new File(f, ui.getOutputFilenameText().getText()));
    }

    public void changeOutputFilename(AccessConfigUI ui, String filename) {
        ui.getAccessModel().setOutputFile(new File(ui.getOutputFileDirectoryText().getText(), filename));
    }

    public void updateProgrammesAndOceans(AccessUI ui) {
        DataSource source = this.getCentralSource();
        try {
            this.openSource(source);
            List programmes = this.getDataService().getList(source, Programme.class);
            Programme selectedProgramme = this.getStepModel().getSelectedProgramme();
            BeanComboBox<Programme> programmeCombo = ui.getSelectProgramme();
            programmeCombo.setData(programmes);
            programmeCombo.setSelectedItem((Object)selectedProgramme);
            List oceans = this.getDataService().getList(source, Ocean.class);
            Ocean selectedOcean = this.getStepModel().getSelectedOcean();
            BeanComboBox<Ocean> oceanCombo = ui.getSelectOcean();
            oceanCombo.setData(oceans);
            oceanCombo.setSelectedItem((Object)selectedOcean);
        }
        catch (DataSourceException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Could not obtain list of programmes from " + source.getLabel()), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
    }
}

