/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Route;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.list.ContentListUIHandler;
import fr.ird.observe.ui.content.list.impl.RoutesUI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

public class RoutesUIHandler
extends ContentListUIHandler<Maree, Route> {
    private static Log log = LogFactory.getLog(RoutesUIHandler.class);

    public RoutesUIHandler(RoutesUI ui) {
        super(ui, DataContextType.Maree, DataContextType.Route);
    }

    @Override
    protected TopiaEntityBinder<Maree> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Maree.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Maree.class, new String[]{"open", "route"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"route"});
            r = binderService.registerTopiaBinder(Maree.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openMareeId = dataContext.getOpenMareeId();
        if (openMareeId == null) {
            this.addInfoMessage(I18n.n_((String)"observe.message.no.active.maree.found"));
            return ContentMode.READ;
        }
        boolean openRoute = dataContext.isOpenRoute();
        if (dataContext.isSelectedOpen(Maree.class)) {
            if (openRoute) {
                this.addInfoMessage(I18n.n_((String)"observe.message.active.route.found"));
                return ContentMode.UPDATE;
            }
            this.addInfoMessage(I18n.n_((String)"observe.message.no.active.route.found"));
            return ContentMode.CREATE;
        }
        if (openRoute) {
            this.addInfoMessage(I18n.n_((String)"observe.message.active.route.found.for.other.maree"));
        } else {
            this.addInfoMessage(I18n.n_((String)"observe.message.no.active.route.found.for.other.maree"));
        }
        return ContentMode.READ;
    }

    @Override
    protected List<Route> getChilds(Maree bean) throws DataSourceException {
        List list = bean.getRoute();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use " + (list == null ? 0 : list.size()) + " routes."));
        }
        return list;
    }
}

