/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.validate;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminActionWorker;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.AdminUIModel;
import fr.ird.observe.ui.admin.config.ConfigUI;
import fr.ird.observe.ui.admin.config.SelectDataUI;
import fr.ird.observe.ui.admin.validate.ValidateConfigUI;
import fr.ird.observe.ui.admin.validate.ValidateEntityListCellRenderer;
import fr.ird.observe.ui.admin.validate.ValidateModel;
import fr.ird.observe.ui.admin.validate.ValidateUI;
import fr.ird.observe.validation.ValidationContext;
import fr.ird.observe.validation.ValidationMessageDetector;
import fr.ird.observe.validation.ValidationModelMode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.ext.WizardState;
import jaxx.runtime.validator.BeanValidator;
import jaxx.runtime.validator.BeanValidatorEvent;
import jaxx.runtime.validator.BeanValidatorMessage;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import jaxx.runtime.validator.ValidatorsMap;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityRef;
import org.nuiton.util.FileUtil;

public class ValidateUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(ValidateUIHandler.class);
    protected DataSource source;
    protected Decorator<Maree> dMaree;
    protected Decorator<Programme> dProgramme;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String LINE = "--------------------------------------------------------------------------------";

    public ValidateUIHandler(AdminTabUI ui) {
        super(ui);
    }

    public void initTabUI(AdminUI ui, ValidateUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        SwingValidatorUtil.installUI((JTable)tabUI.getMessageTable(), (SwingValidatorMessageTableRenderer)new UIHelper.ObserveValidatorMessageTableRenderer());
        ValidateEntityListCellRenderer listRenderer = new ValidateEntityListCellRenderer(tabUI.getStepModel());
        tabUI.getTypeList().setCellRenderer(listRenderer);
        tabUI.getRefList().setCellRenderer(listRenderer);
        tabUI.getStartButton().setText(I18n._((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n._((String)tabUI.getStep().getOperationLabel())}));
        if (log.isInfoEnabled()) {
            log.info((Object)("Init extra configuration for " + tabUI.getName()));
        }
        ConfigUI configUI = (ConfigUI)ui.getStepUI(AdminStep.CONFIG);
        JAXXInitialContext tx = new JAXXInitialContext().add((Object)configUI).add((Object)this);
        ValidateConfigUI extraConfig = new ValidateConfigUI((JAXXContext)tx);
        configUI.getExtraConfig().add(extraConfig);
        final SelectDataUI selectTabUI = (SelectDataUI)ui.getStepUI(AdminStep.SELECT_DATA);
        this.getModel().getValidateModel().addPropertyChangeListener("modelMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ValidationModelMode value = (ValidationModelMode)evt.getNewValue();
                if (value == null) {
                    return;
                }
                DataSelectionModel selectDataModel = selectTabUI.getSelectDataModel();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("validation model changed to " + value));
                }
                switch (value) {
                    case REFERENTIEL: {
                        selectDataModel.setUseData(false);
                        selectDataModel.setUseReferentiel(true);
                        break;
                    }
                    case DATA: {
                        selectDataModel.setUseData(true);
                        selectDataModel.setUseReferentiel(false);
                        break;
                    }
                    case ALL: {
                        selectDataModel.setUseData(true);
                        selectDataModel.setUseReferentiel(true);
                    }
                }
            }
        });
        selectTabUI.getModel().addPropertyChangeListener("selectionModelChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AdminUIModel model = (AdminUIModel)((Object)evt.getSource());
                if (!model.containsStep((WizardStep)selectTabUI.getStep())) {
                    return;
                }
                DataSelectionModel value = (DataSelectionModel)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("selection model changed to " + value));
                }
                ValidateUIHandler.this.updateSelectionModel(selectTabUI);
            }
        });
    }

    public void updateState(ValidateUI tabUI, WizardState newState) {
        super.updateState(tabUI, newState);
        if (newState == WizardState.NEED_FIX) {
            this.updateTypes();
            tabUI.resumeLabel.setText(I18n._((String)"observe.synchro.validate.save.reportFile", (Object[])new Object[]{tabUI.getStepModel().getReportFile()}));
            String actionText = tabUI.getStepModel().isGenerateReport() ? I18n._((String)"observe.synchro.save.report") : I18n._((String)"observe.synchro.continue.with.no.save.report");
            tabUI.saveReport.setText(actionText);
            return;
        }
        if (newState == WizardState.RUNNING) {
            tabUI.typeList.clearSelection();
            tabUI.refList.clearSelection();
            tabUI.messageTable.clearSelection();
            tabUI.typeModel.clear();
            tabUI.refModel.clear();
            tabUI.messagesModel.clear();
            tabUI.messagesModel.clearValidators();
            for (BeanValidator v : tabUI.getStepModel().getValidators().values()) {
                tabUI.messagesModel.registerValidator((SwingValidator)v);
            }
        }
        if (newState == WizardState.SUCCESSED) {
            // empty if block
        }
    }

    public void updateTypes() {
        ValidateUI tabUI = (ValidateUI)this.ui;
        DefaultListModel typeModel = tabUI.typeModel;
        tabUI.typeSelectionModel.clearSelection();
        typeModel.clear();
        Class[] classes = tabUI.getStepModel().getMessageTypes();
        for (Class e : classes = this.getDecoratorService().sortTypes(classes)) {
            typeModel.addElement(e);
        }
        tabUI.typeList.setSelectedIndex(0);
    }

    public void updateSelectedType() {
        ValidateUI tabUI = (ValidateUI)this.ui;
        this.getModel().setBusy(true);
        tabUI.refSelectionModel.clearSelection();
        tabUI.refModel.clear();
        Object o = tabUI.typeList.getSelectedValue();
        if (log.isInfoEnabled()) {
            log.info((Object)("new selected type = " + o));
        }
        if (o == null) {
            return;
        }
        Class type = (Class)o;
        List<TopiaEntityRef> refs = tabUI.getStepModel().getMessagesEntities(type);
        for (TopiaEntityRef ref : refs) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("add ref = " + ref));
            }
            tabUI.refModel.addElement(ref);
        }
        tabUI.refList.setSelectedIndex(0);
        this.getModel().setBusy(false);
    }

    public void updateSelectedRef() {
        ValidateUI tabUI = (ValidateUI)this.ui;
        tabUI.messageTable.clearSelection();
        tabUI.messagesModel.clear();
        Object o = tabUI.refList.getSelectedValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selected ref = " + o));
        }
        if (o == null) {
            return;
        }
        TopiaEntityRef ref = (TopiaEntityRef)o;
        if (log.isDebugEnabled()) {
            log.debug((Object)ref.getAccessorExpression());
        }
        for (BeanValidatorMessage<?> m : tabUI.getStepModel().getMessages(ref)) {
            BeanValidatorEvent evt = new BeanValidatorEvent(m.getValidator(), m.getField(), m.getScope(), new String[]{m.getMessage()}, EMPTY_STRING_ARRAY);
            tabUI.messagesModel.onFieldChanged(evt);
        }
    }

    public void startAction() {
        ValidateUI tabUI = (ValidateUI)this.ui;
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = tabUI.getStartButton().getToolTipText();
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return ValidateUIHandler.this.doAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    public WizardState doAction() throws Exception {
        WizardState init;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        if ((init = this.initDB()) != null) {
            return init;
        }
        this.launchValidation();
        SortedMap<TopiaEntityRef, List<BeanValidatorMessage<?>>> refs = this.model.getValidateModel().getMessages();
        if (refs == null || refs.isEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.validation.nothing.to.do"));
            this.sendMessage(I18n._((String)"observe.message.validation.operation.done", (Object[])new Object[]{new Date()}));
            return WizardState.SUCCESSED;
        }
        this.sendMessage(I18n._((String)"observe.message.validation.operation.needFix", (Object[])new Object[]{new Date()}));
        return WizardState.NEED_FIX;
    }

    protected WizardState initDB() throws Exception {
        this.source = this.getSource();
        DecoratorService decoratorService = this.getDecoratorService();
        this.dMaree = decoratorService.getDecorator(Maree.class);
        this.dProgramme = decoratorService.getDecorator(Programme.class);
        this.openSource(this.source);
        ValidateModel validationModel = this.model.getValidateModel();
        ValidatorsMap validators = validationModel.getValidators();
        this.sendMessage(I18n._((String)"observe.message.validation.use.storage", (Object[])new Object[]{this.source.getLabel()}));
        this.sendMessage(I18n._((String)"observe.message.validation.prepare.validators"));
        if (!validators.isEmpty()) {
            for (BeanValidator v : validators.values()) {
                String label = I18n._((String)decoratorService.getEntityLabel(v.getBeanClass()));
                this.sendMessage(I18n._((String)"observe.message.validation.detected", (Object[])new Object[]{label}));
            }
        } else {
            this.sendMessage(I18n._((String)"observe.message.no.validation.detected"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchValidation() throws Exception {
        ValidateModel stepModel = this.model.getValidateModel();
        stepModel.setMessages(null);
        ValidatorsMap validators = stepModel.getValidators();
        ValidationMessageDetector detector = new ValidationMessageDetector(validators);
        DataSelectionModel dataModel = this.model.getSelectionDataModel();
        ValidationContext context = ObserveServiceHelper.getValidationContext();
        context.setDataSource(this.model.getLocalSource());
        context.setDataContext(this.model.getDataService().getDataContext());
        TopiaContext ctxt = this.beginTransaction(this.source, "launchValidation");
        try {
            if (dataModel.isUseReferentiel()) {
                this.validateReferentiel(detector, ctxt, dataModel);
            }
            if (dataModel.isUseData()) {
                this.validateData(detector, ctxt, dataModel);
            }
        }
        finally {
            context.setDataSource(null);
            SortedMap refs = detector.getRefs();
            stepModel.setMessages(refs);
            detector.clear();
            this.closeTransaction(this.source, ctxt, "launchValidation");
        }
    }

    private void validateData(ValidationMessageDetector detector, TopiaContext ctxt, DataSelectionModel dataModel) throws TopiaException {
        Set data = dataModel.getSelectedData();
        for (String id : data) {
            Maree e = (Maree)ctxt.findByTopiaId(id);
            Programme p = e.getProgramme();
            this.sendMessage(I18n._((String)"observe.message.validation.start.maree", (Object[])new Object[]{this.dMaree.toString((Object)e), this.dProgramme.toString((Object)p)}));
            detector.detectMessages(new TopiaEntity[]{e});
        }
    }

    protected void validateReferentiel(ValidationMessageDetector detector, TopiaContext ctxt, DataSelectionModel dataModel) throws DataSourceException, TopiaException {
        DecoratorService decoratorService = this.getDecoratorService();
        DataService dataService = this.getDataService();
        Set classes = dataModel.getSelectedReferentiel();
        Iterator i$ = classes.iterator();
        while (i$.hasNext()) {
            Class klass;
            Class refClass = klass = (Class)i$.next();
            List ids = dataService.getEntityIds(this.source, refClass);
            String entityLabel = I18n._((String)decoratorService.getEntityLabel(klass));
            this.sendMessage(I18n._((String)"observe.message.validation.start.referentiel", (Object[])new Object[]{entityLabel, ids.size()}));
            for (String id : ids) {
                TopiaEntity e = ctxt.findByTopiaId(id);
                detector.detectMessages(new TopiaEntity[]{e});
            }
            ids.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReport() {
        WizardState finalState = null;
        ValidateModel validationModel = this.model.getValidateModel();
        try {
            if (validationModel.isGenerateReport()) {
                this.sendMessage(I18n._((String)"observe.message.validation.save.report", (Object[])new Object[]{validationModel.getReportFile()}));
                this.generateReportFile(validationModel);
            } else {
                this.sendMessage(I18n._((String)"observe.message.validation.not.save.report"));
            }
            finalState = WizardState.SUCCESSED;
        }
        catch (Exception e) {
            try {
                validationModel.setError(e);
                finalState = WizardState.FAILED;
            }
            catch (Throwable throwable) {
                this.model.setStepState(AdminStep.VALIDATE, finalState);
                throw throwable;
            }
            this.model.setStepState(AdminStep.VALIDATE, finalState);
        }
        this.model.setStepState(AdminStep.VALIDATE, finalState);
    }

    public void generateReportFile(ValidateModel validationModel) throws IOException {
        File reportFile = validationModel.getReportFile();
        if (log.isInfoEnabled()) {
            log.info((Object)("save report in " + reportFile));
        }
        DecoratorService service = this.getDecoratorService();
        StringBuilder builder = new StringBuilder();
        builder.append(LINE).append('\n');
        builder.append(I18n._((String)"observe.validation.report.title", (Object[])new Object[]{new Date()})).append('\n');
        builder.append(I18n._((String)"observe.validation.report.scopes", (Object[])new Object[]{validationModel.getScopes()})).append('\n');
        builder.append(I18n._((String)"observe.validation.report.contextName", (Object[])new Object[]{validationModel.getContextName()})).append('\n');
        SortedMap<TopiaEntityRef, List<BeanValidatorMessage<?>>> messages = validationModel.getMessages();
        builder.append(I18n._((String)"observe.validation.report.entities.with.messages", (Object[])new Object[]{messages.size()})).append('\n');
        builder.append(LINE).append('\n').append('\n');
        for (Map.Entry<TopiaEntityRef, List<BeanValidatorMessage<?>>> entry : messages.entrySet()) {
            TopiaEntityRef ref = entry.getKey();
            String refStr = service.decorate((Object)ref.getRef());
            List<BeanValidatorMessage<?>> refMessages = entry.getValue();
            EnumSet scopes = BeanValidatorUtil.getScopes(refMessages);
            builder.append(I18n._((String)"observe.validation.report.entity", (Object[])new Object[]{ref.getRef().getTopiaId(), refStr, refMessages.size(), scopes})).append('\n');
            for (BeanValidatorScope scope : scopes) {
                List<BeanValidatorMessage<?>> messagesByScope = this.filterMessages(scope, refMessages);
                for (BeanValidatorMessage<?> message : messagesByScope) {
                    builder.append(message).append('\n');
                }
                builder.append('\n');
            }
            builder.append(LINE).append('\n').append('\n');
        }
        String content = builder.toString();
        if (log.isInfoEnabled()) {
            log.info((Object)content);
        }
        FileUtil.writeString((File)reportFile, (String)content);
    }

    private List<BeanValidatorMessage<?>> filterMessages(BeanValidatorScope scope, List<BeanValidatorMessage<?>> refMessages) {
        ArrayList result = new ArrayList();
        for (BeanValidatorMessage<?> message : refMessages) {
            if (!message.getScope().equals((Object)scope)) continue;
            result.add(message);
        }
        return result;
    }

    public void updateValidationScopes(JCheckBox checkBox) {
        BeanValidatorScope scope = this.getValidatorScope(checkBox);
        ValidateModel validateModel = this.getModel().getValidateModel();
        if (checkBox.isSelected()) {
            validateModel.addScope(scope);
        } else {
            validateModel.removeScope(scope);
        }
    }

    public ComboBoxModel updateComboModel(Object ... datas) {
        if (datas == null) {
            return new DefaultComboBoxModel();
        }
        return new DefaultComboBoxModel<Object>(datas);
    }

    public String updateValidatorResumeLabel(boolean valid) {
        ValidateModel validateModel = this.getModel().getValidateModel();
        if (validateModel == null || validateModel.getValidators() == null) {
            return null;
        }
        return I18n._((String)"observe.common.selected.validators", (Object[])new Object[]{validateModel.getValidators().size()});
    }

    public AdminStep getOperation(JCheckBox checkBox) {
        return AdminStep.valueOf(checkBox.getName());
    }

    public BeanValidatorScope getValidatorScope(JCheckBox checkBox) {
        return (BeanValidatorScope)checkBox.getClientProperty("value");
    }

    public boolean isScopeSelected(Set<BeanValidatorScope> scopes, JCheckBox checkBox) {
        BeanValidatorScope scope = this.getValidatorScope(checkBox);
        return scopes.contains(scope);
    }

    public boolean isOperationSelected(Set<AdminStep> operations, JCheckBox checkBox) {
        AdminStep scope = this.getOperation(checkBox);
        return operations.contains((Object)this.getOperation(checkBox));
    }

    public void chooseValidationReportFile(ValidateConfigUI configUI) {
        File f = UIHelper.chooseDirectory(configUI, I18n._((String)"observe.title.choose.report.directory"), I18n._((String)"observe.action.choose.report.directory"), new File(configUI.validationReportDirectoryText.getText()));
        this.changeValidationReportDirectory(configUI, f);
    }

    public void changeValidationReportDirectory(ValidateConfigUI configUI, File f) {
        this.getModel().getValidateModel().setReportFile(new File(f, configUI.validationReportFilenameText.getText()));
    }

    public void changeValidationReportFilename(ValidateConfigUI configUI, String filename) {
        this.getModel().getValidateModel().setReportFile(new File(configUI.validationReportDirectoryText.getText(), filename));
    }

    public String updateReferentielPolicy(boolean valid) {
        if (!valid) {
            return I18n._((String)"observe.common.storage.not.valid");
        }
        return this.model.getCentralSourceModel().getPgConfig().getPolicyLabel();
    }
}

