/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.save;

import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminActionWorker;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.save.SaveLocalModel;
import fr.ird.observe.ui.admin.save.SaveLocalUI;
import fr.ird.observe.ui.admin.synchronize.SynchronizeModel;
import fr.ird.observe.ui.admin.synchronize.SynchronizeUIHandler;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.jdbc.Work;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.DiffState;

public class SaveLocalUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(SaveLocalUIHandler.class);
    private static final String UPDATE_VERSION_PATTERN = "UPDATE %1$s SET topiaversion = %2$d WHERE topiaid='%3$s';\n";
    protected DataSource source;

    public SaveLocalUIHandler(SaveLocalUI ui) {
        super(ui);
    }

    @Override
    public SaveLocalUI getUi() {
        return (SaveLocalUI)super.getUi();
    }

    public void initTabUI(AdminUI ui, SaveLocalUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        String message = I18n._((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n._((String)tabUI.getStep().getOperationLabel())});
        tabUI.getStartAction().setText(message);
    }

    public void updateText() {
        String text = "";
        if (this.getUi().getStepModel().containsStepForsave(AdminStep.SYNCHRONIZE)) {
            text = I18n._((String)"observe.synchro.message.need.save.for.synchro.operation");
            text = text + "\n\n";
        }
        if (this.getUi().getStepModel().containsStepForsave(AdminStep.VALIDATE)) {
            text = I18n._((String)"observe.synchro.message.need.save.for.validation.operation");
            text = text + "\n\n";
        }
        this.getUi().needSaveText.setText(text);
    }

    public String updateText(boolean localSourceNeedSave) {
        return localSourceNeedSave ? I18n._((String)"observe.message.synchro.local.modification") : I18n._((String)"observe.message.synchro.no.local.modification");
    }

    public void skipOperation() {
        this.sendMessage(I18n._((String)"observe.synchro.message.saveLocal.skip"));
        this.getModel().setStepState(AdminStep.SAVE_LOCAL, WizardState.SUCCESSED);
        if (this.model.getNextStep() != null) {
            this.model.gotoNextStep();
        }
    }

    public void chooseBackupFile() {
        File f = UIHelper.chooseDirectory(this.getUi(), I18n._((String)"observe.title.choose.db.dump.directory"), I18n._((String)"observe.action.choose.db.dump.directory"), new File(this.getUi().directoryText.getText()));
        this.changeDirectory(f);
    }

    public void changeDirectory(File f) {
        this.getUi().getStepModel().setBackupFile(new File(f, this.getUi().filenameText.getText()));
    }

    public void changeFilename(String filename) {
        this.getUi().getStepModel().setBackupFile(new File(this.getUi().directoryText.getText(), filename));
    }

    public void doStartAction() {
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = this.getUi().getStartAction().getToolTipText();
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return SaveLocalUIHandler.this.doAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    public WizardState doAction() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.source = this.model.getSafeLocalSource(false);
        SaveLocalModel stepModel = this.model.getSaveLocalModel();
        if (!stepModel.isLocalSourceNeedSave()) {
            this.sendMessage("Aucune modification sur la base locale, op\u00e9ration non requise.");
            return WizardState.SUCCESSED;
        }
        this.openSource(this.source);
        if (stepModel.isDoBackup()) {
            this.sendMessage("Sauvegarde de la base locale vers " + stepModel.getBackupFile());
            File backupFile = stepModel.getBackupFile();
            this.source.storeDB(backupFile);
        }
        if (stepModel.containsStepForsave(AdminStep.SYNCHRONIZE)) {
            this.sendMessage("Sauvegarde du r\u00e9f\u00e9rentiel.");
            this.saveReferentiel();
        }
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReferentiel() throws Exception {
        SynchronizeModel stepModel = this.getModel().getSynchronizeReferentielModel();
        DataSource source = stepModel.getSource();
        DataSource targetSource = stepModel.getTmpSource();
        if (targetSource == null) {
            targetSource = stepModel.getCentralSource();
        }
        DiffState.DiffStateMap diff = stepModel.getDiff();
        String txName = "saveReferentiel";
        TopiaContext sourceCtxt = this.beginTransaction(source, txName);
        try {
            TopiaContext tmpCtxt = this.beginTransaction(targetSource, txName);
            try {
                Map<TopiaEntity, Long> versionsToUpdate;
                String message;
                TopiaEntity entity;
                List ids = (List)diff.get((Object)DiffState.NEW);
                if (ids != null) {
                    for (String id : ids) {
                        entity = tmpCtxt.findByTopiaId(id);
                        String message2 = I18n._((String)"observe.synchro.add.object", (Object[])new Object[]{id});
                        this.sendMessage(message2);
                        tmpCtxt.replicateEntity(sourceCtxt, entity);
                    }
                }
                if ((ids = (List)diff.get((Object)DiffState.MODIFIED)) != null && !ids.isEmpty()) {
                    for (String id : ids) {
                        entity = tmpCtxt.findByTopiaId(id);
                        this.copyEntity(stepModel, sourceCtxt, entity);
                    }
                }
                for (SynchronizeUIHandler.ObsoleteRefReplaceAction action : stepModel.getReplaceActions()) {
                    message = I18n._((String)"observe.synchro.replaceObsolete.object", (Object[])new Object[]{action.getObsoleteId()});
                    this.sendMessage(message);
                    action.doAction(sourceCtxt);
                }
                this.commitTransaction(source, sourceCtxt, txName);
                ids = (List)diff.get((Object)DiffState.REMOVED);
                if (ids != null) {
                    for (String id : ids) {
                        message = I18n._((String)"observe.synchro.remove.object", (Object[])new Object[]{id});
                        this.sendMessage(message);
                        TopiaEntity entity2 = sourceCtxt.findByTopiaId(id);
                        this.getDAO(sourceCtxt, entity2).delete(entity2);
                    }
                }
                if ((versionsToUpdate = stepModel.getVersionsToUpdate()) != null && !versionsToUpdate.isEmpty()) {
                    final StringBuilder buffer = new StringBuilder();
                    for (Map.Entry<TopiaEntity, Long> entry : versionsToUpdate.entrySet()) {
                        TopiaEntity entity3 = entry.getKey();
                        String id = entity3.getTopiaId();
                        Long version = entry.getValue();
                        Class contract = ObserveDAOHelper.getContractClass(entity3.getClass());
                        buffer.append(String.format(UPDATE_VERSION_PATTERN, contract.getSimpleName(), version, id));
                    }
                    ((TopiaContextImplementor)sourceCtxt).getHibernate().doWork(new Work(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void execute(Connection connection) throws SQLException {
                            String sql = buffer.toString();
                            PreparedStatement sta = connection.prepareStatement(sql);
                            try {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Will execute sql code :\n" + sql));
                                }
                                sta.executeUpdate();
                            }
                            finally {
                                sta.close();
                            }
                        }
                    });
                }
                this.commitTransaction(source, sourceCtxt, txName);
            }
            finally {
                try {
                    this.rollbackTransaction(targetSource, tmpCtxt, txName);
                }
                finally {
                    this.closeTransaction(targetSource, tmpCtxt, txName);
                }
            }
        }
        catch (Exception e) {
            this.rollbackTransaction(source, sourceCtxt, txName);
            throw e;
        }
        finally {
            this.closeTransaction(source, sourceCtxt, txName);
        }
    }

    protected <E extends TopiaEntity> void copyEntity(SynchronizeModel synchronizeModel, TopiaContext tx, E source) throws TopiaException {
        long sourceVersion = source.getTopiaVersion();
        String message = I18n._((String)"observe.synchro.update.object", (Object[])new Object[]{source.getTopiaId(), sourceVersion});
        this.sendMessage(message);
        TopiaDAO dao = ObserveDAOHelper.getDAO((TopiaContext)tx, source);
        TopiaEntity target = dao.findByTopiaId(source.getTopiaId());
        long targetVersion = target.getTopiaVersion();
        this.getBinderService().simpleCopy(source, target, false);
        if (targetVersion < sourceVersion) {
            if (log.isDebugEnabled()) {
                message = "register [" + source.getTopiaId() + "] to update version " + sourceVersion + " to " + targetVersion;
                log.debug((Object)message);
            }
            synchronizeModel.getVersionsToUpdate().put(target, sourceVersion);
        }
        target.setTopiaVersion(source.getTopiaVersion() - 1L);
        dao.update(target);
    }
}

