/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.IObserveConfig;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveResourceManager;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceConfig;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.impl.H2DataSource;
import fr.ird.observe.db.impl.PGDataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.report.model.Report;
import fr.ird.observe.ui.admin.AdminActionModel;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.access.AccessModel;
import fr.ird.observe.ui.admin.consolidate.ConsolidateModel;
import fr.ird.observe.ui.admin.export.ExportModel;
import fr.ird.observe.ui.admin.gps.ImportGPSModel;
import fr.ird.observe.ui.admin.report.ReportModel;
import fr.ird.observe.ui.admin.save.SaveLocalModel;
import fr.ird.observe.ui.admin.synchronize.SynchronizeModel;
import fr.ird.observe.ui.admin.validate.ValidateModel;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.validation.ValidationModelMode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.ext.WizardExtModel;
import jaxx.runtime.swing.wizard.ext.WizardExtStep;
import jaxx.runtime.swing.wizard.ext.WizardState;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.ValidatorsMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;

public class AdminUIModel
extends WizardExtModel<AdminStep> {
    private static final Log log = LogFactory.getLog(AdminUIModel.class);
    public static final String SHOW_RESUME_PROPERTY_NAME = "showResume";
    public static final String NEED_LOCAL_SOURCE_PROPERTY_NAME = "needLocalSource";
    public static final String SELECTION_MODEL_CHANGED_PROPERTY_NAME = "selectionModelChanged";
    public static final String SELECTED_MAREE_PROPERTY_NAME = "selectedMaree";
    protected DataSource previousSource;
    protected DataSource localSource;
    protected DataSource centralSource;
    protected DataSource tmpSource;
    protected StorageUIModel localSourceModel;
    protected StorageUIModel centralSourceModel;
    protected StorageUIHandler storageHandler;
    protected DataService dataService;
    protected ObserveConfig config;
    protected DataSelectionModel selectionDataModel;
    protected EnumSet<DbMode> availableIncomingModes;
    PropertyChangeListener listenStepChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int newIndex;
            int oldIndex;
            if (AdminUIModel.this.isWasStarted()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Stop propagation, was started... " + evt.getPropertyName()));
                }
                return;
            }
            AdminStep oldStep = (AdminStep)((Object)evt.getOldValue());
            AdminStep newStep = (AdminStep)((Object)evt.getNewValue());
            if (newStep == AdminStep.REPORT && oldStep != null && oldStep.ordinal() < newStep.ordinal() && (oldIndex = AdminUIModel.this.getStepIndex((WizardStep)oldStep)) < (newIndex = AdminUIModel.this.getStepIndex((WizardStep)newStep))) {
                AdminUIModel.this.getReportModel().setSelectedReport(null);
            }
            if (newStep == AdminStep.CONFIG) {
                return;
            }
            if (oldStep != null && oldStep != AdminStep.CONFIG) {
                return;
            }
            boolean needSelect = AdminUIModel.this.needSelect();
            if (!needSelect) {
                return;
            }
            DataSelectionModel selectModel = AdminUIModel.this.getSelectionDataModel();
            if (AdminUIModel.this.containsOperation(AdminStep.EXPORT_DATA)) {
                AdminUIModel.this.computeExistingMarees(AdminUIModel.this.getSafeCentralSource(true));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will refill selectionModel [" + (Object)((Object)newStep) + "] : " + selectModel));
            }
            DataSource dataSource = AdminUIModel.this.getSafeLocalSource(true);
            AdminUIModel.this.populateSelectionModel(AdminUIModel.this.dataService, dataSource);
        }
    };
    PropertyChangeListener listenSelectModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataSelectionModel source = (DataSelectionModel)evt.getSource();
            if (log.isDebugEnabled()) {
                log.debug((Object)("selection data model [" + source + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("nb selected export datas = " + source.getSelectedData().size()));
            }
            AdminUIModel.this.firePropertyChange("validStep", AdminUIModel.this.validStep);
        }
    };
    PropertyChangeListener listenValidationModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ValidateModel source = (ValidateModel)((Object)evt.getSource());
            if (log.isDebugEnabled()) {
                log.debug((Object)("validation model [" + (Object)((Object)source) + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("nb validators = " + source.getValidators().size()));
            }
            AdminUIModel.this.firePropertyChange("validStep", AdminUIModel.this.validStep);
        }
    };
    PropertyChangeListener listenReportModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ReportModel source = (ReportModel)((Object)evt.getSource());
            if (log.isDebugEnabled()) {
                log.debug((Object)("report model [" + (Object)((Object)source) + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
            AdminUIModel.this.firePropertyChange("validStep", AdminUIModel.this.validStep);
        }
    };
    PropertyChangeListener listenerSelectedDataForReport = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AdminUIModel.this.getReportModel().setSelectedReport(null);
            AdminUIModel.this.firePropertyChange(AdminUIModel.SELECTED_MAREE_PROPERTY_NAME, AdminUIModel.this.getSelectedMaree());
        }
    };
    PropertyChangeListener listenConsolidateModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ConsolidateModel source = (ConsolidateModel)((Object)evt.getSource());
            if (log.isDebugEnabled()) {
                log.debug((Object)("consolidate model [" + (Object)((Object)source) + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
            AdminUIModel.this.firePropertyChange("validStep", AdminUIModel.this.validStep);
        }
    };
    PropertyChangeListener listenGPSModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("gps import model has changed [" + evt.getPropertyName() + "] = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
        }
    };
    PropertyChangeListener listenAccessModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("access import model has changed [" + evt.getPropertyName() + "] = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
        }
    };
    PropertyChangeListener listenSaveLocalChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("backupFile".equals(propertyName)) {
                AdminUIModel.this.validate();
                return;
            }
            if ("localSourceNeedSave".equals(propertyName)) {
                boolean localSourceNeedSave = (Boolean)evt.getNewValue();
                if (localSourceNeedSave) {
                    AdminUIModel.this.setStepState(AdminStep.SAVE_LOCAL, WizardState.PENDING);
                }
                AdminUIModel.this.validate();
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skip property " + propertyName));
            }
        }
    };

    public AdminUIModel() {
        super(AdminStep.class, (WizardExtStep[])new AdminStep[0]);
        this.localSourceModel = new StorageUIModel(){

            @Override
            public String getLabel() {
                String txt = I18n.n_((String)"observe.storage.label.synchro.incoming");
                String params = this.getDbMode() == DbMode.USE_REMOTE ? I18n._((String)"observe.storage.remote.db") + " " + this.getRemoteUrl() : I18n._((String)"observe.storage.locale.db") + " " + this.getH2Config().getDataDirectory().getAbsolutePath();
                txt = I18n._((String)txt, (Object[])new Object[]{params});
                return txt;
            }

            @Override
            public void validate() {
                super.validate();
                AdminUIModel.this.firePropertyChange("valid", this.isValid());
            }
        };
        this.centralSourceModel = new StorageUIModel(){

            @Override
            public String getLabel() {
                String txt = I18n.n_((String)"observe.storage.label.synchro.referentiel");
                String params = this.getDbMode() == DbMode.CREATE_LOCAL ? this.getH2Config().getDataDirectory().getAbsolutePath() : this.getRemoteUrl();
                txt = I18n._((String)txt, (Object[])new Object[]{params});
                return txt;
            }

            @Override
            public void validate() {
                super.validate();
                AdminUIModel.this.firePropertyChange("valid", this.isValid());
            }
        };
        this.selectionDataModel = new DataSelectionModel();
        this.availableIncomingModes = EnumSet.noneOf(DbMode.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("model [" + (Object)((Object)this) + "] is instanciate."));
        }
    }

    public DataSelectionModel getSelectionDataModel() {
        return this.selectionDataModel;
    }

    public boolean needSelect() {
        if (WizardState.CANCELED == this.getModelState()) {
            return false;
        }
        Set operations = this.getOperations();
        for (AdminStep operation : operations) {
            if (!operation.isNeedSelect()) continue;
            return true;
        }
        return false;
    }

    public String getSelectedMaree() {
        Set data = this.getSelectionDataModel().getSelectedData();
        if (data.isEmpty()) {
            return null;
        }
        String id = (String)data.iterator().next();
        if (id.startsWith(Maree.class.getName())) {
            return id;
        }
        return null;
    }

    public AdminActionModel getStepModel(AdminStep operation) {
        return (AdminActionModel)super.getStepModel((WizardExtStep)operation);
    }

    public StorageUIHandler getStorageHandler() {
        return this.storageHandler;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public ObserveConfig getConfig() {
        return this.config;
    }

    public boolean isNeedIncomingDataSource() {
        for (AdminStep op : this.getOperations()) {
            if (!op.hasIncomingModes()) continue;
            return true;
        }
        return false;
    }

    public boolean isNeedReferentielDataSource() {
        for (AdminStep op : this.getOperations()) {
            if (!op.isNeedReferentiel()) continue;
            return true;
        }
        return false;
    }

    public EnumSet<DbMode> getIncomingDataSourceMode() {
        EnumSet<DbMode> result = EnumSet.noneOf(DbMode.class);
        for (AdminStep op : this.getOperations()) {
            if (!op.hasIncomingModes()) continue;
            result.addAll(Arrays.asList(op.getIncomingModes()));
        }
        return result;
    }

    public EnumSet<DbMode> getAvailableIncomingModes() {
        return this.availableIncomingModes;
    }

    public void start(AdminUI ui) {
        File reportFile;
        this.availableIncomingModes.clear();
        this.storageHandler = ui.getContextValue(StorageUIHandler.class);
        this.dataService = ui.getContextValue(DataService.class);
        this.config = ui.getContextValue(ObserveConfig.class);
        this.start();
        ui.blockOperations();
        if (log.isInfoEnabled()) {
            log.info((Object)("enables steps = " + this.steps));
            log.info((Object)("enables operations = " + this.operations));
        }
        DataSource previousSource = ui.getContextValue(DataSource.class);
        this.setPreviousSource(previousSource);
        this.startIncomingSourceModel(ui);
        this.startCentralSourceModel(ui);
        this.startSelectModel();
        if (previousSource != null && previousSource.isOpen()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Close previous source " + previousSource.getShortLabel()));
            }
            this.doCloseSource(previousSource, false);
        }
        if (this.containsOperation(AdminStep.SAVE_LOCAL)) {
            File backupfile = new File(this.config.getBackupDirectory(), this.storageHandler.getDefaultBackupFilename());
            this.getSaveLocalModel().setBackupFile(backupfile);
            this.getSaveLocalModel().setDoBackup(true);
            this.getSaveLocalModel().addPropertyChangeListener(this.listenSaveLocalChanged);
        }
        if (this.containsOperation(AdminStep.IMPORT_GPS)) {
            this.getImportGPSModel().setImportGPSMaxDelay(this.config.getDefaultGpsMaxDelay());
            this.getImportGPSModel().setImportGPSMaxSpeed(Float.valueOf(this.config.getDefaultGpsMaxSpeed()));
            this.getImportGPSModel().addPropertyChangeListener(this.listenGPSModified);
        }
        if (this.containsOperation(AdminStep.ACCESS)) {
            AccessModel accessModel = this.getAccessModel();
            File backupfile = new File(this.config.getBackupDirectory(), accessModel.getDefaultBackupFilename());
            accessModel.setOutputFile(backupfile);
            accessModel.addPropertyChangeListener(this.listenAccessModified);
        }
        if (this.containsOperation(AdminStep.VALIDATE)) {
            boolean b;
            this.getValidateModel().addPropertyChangeListener(this.listenValidationModified);
            this.getValidateModel().addScope(BeanValidatorScope.ERROR);
            this.getValidateModel().setModelMode(ValidationModelMode.DATA);
            this.getValidateModel().setAllContextNames(new String[]{"n1-update", "n1-create"});
            this.getValidateModel().setContextName("n1-update");
            this.getValidateModel().setGenerateReport(true);
            if (!this.config.getValidationReportDirectory().exists() && !(b = this.config.getValidationReportDirectory().mkdirs())) {
                throw new RuntimeException("Could not create directory " + this.config.getValidationReportDirectory());
            }
            reportFile = new File(this.config.getValidationReportDirectory(), this.getValidateModel().getDefaultReportFilename());
            this.getValidateModel().setReportFile(reportFile);
        }
        if (this.containsOperation(AdminStep.REPORT)) {
            reportFile = ObserveResourceManager.Resource.report.getFile(this.config.getReportDirectory());
            log.info((Object)("Will use report file : " + reportFile));
            this.getReportModel().setReportFile(reportFile);
            List<Report> reports = this.getReportModel().getReports();
            this.getReportModel().addPropertyChangeListener(this.listenReportModified);
            this.getSelectionDataModel().addPropertyChangeListener("selectedData", this.listenerSelectedDataForReport);
            log.info((Object)("Detects " + reports.size() + " report(s)."));
        }
        if (this.containsOperation(AdminStep.CONSOLIDATE)) {
            this.getConsolidateModel().addPropertyChangeListener(this.listenConsolidateModified);
        }
        this.addPropertyChangeListener("step", this.listenStepChanged);
        if (log.isInfoEnabled()) {
            log.info((Object)"End of start...");
        }
        this.validate();
    }

    protected void startCentralSourceModel(AdminUI ui) {
        if (!this.isNeedReferentielDataSource()) {
            return;
        }
        this.centralSourceModel.init((JAXXContext)ui, null);
        this.centralSourceModel.setCanCreateLocalService(false);
        this.centralSourceModel.setCanUseLocalService(false);
        this.centralSourceModel.setCanUseRemoteService(true);
        this.centralSourceModel.start(DbMode.USE_REMOTE);
        if (log.isDebugEnabled()) {
            this.centralSourceModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    Object oldValue = evt.getOldValue();
                    Object newValue = evt.getNewValue();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(evt.getSource() + " - Property [" + name + "] has changed from  " + oldValue + " to " + newValue));
                    }
                }
            });
        }
        this.centralSourceModel.testRemote();
    }

    protected void startIncomingSourceModel(AdminUI ui) {
        if (!this.isNeedIncomingDataSource()) {
            return;
        }
        DataSource previousSource = this.getPreviousSource();
        DataSourceConfig previousSourceConfig = null;
        EnumSet<DbMode> authorizedModes = this.getIncomingDataSourceMode();
        EnumSet<DbMode> modes = EnumSet.noneOf(DbMode.class);
        if (authorizedModes.contains(DbMode.USE_LOCAL) && this.getConfig().isLocalStorageExist()) {
            modes.add(DbMode.USE_LOCAL);
        }
        if (authorizedModes.contains(DbMode.USE_REMOTE)) {
            modes.add(DbMode.USE_REMOTE);
        }
        if (authorizedModes.contains(DbMode.CREATE_LOCAL)) {
            modes.add(DbMode.CREATE_LOCAL);
        }
        if (previousSource != null) {
            previousSourceConfig = previousSource.getConfig().clone();
            if (previousSource instanceof PGDataSource && !modes.contains(DbMode.USE_REMOTE)) {
                previousSource = null;
            }
            if (previousSource instanceof H2DataSource && !modes.contains(DbMode.USE_LOCAL)) {
                previousSource = null;
            }
        }
        this.availableIncomingModes.addAll(modes);
        this.localSourceModel.setCanCreateLocalService(modes.contains(DbMode.CREATE_LOCAL));
        this.localSourceModel.setCanUseLocalService(modes.contains(DbMode.USE_LOCAL));
        this.localSourceModel.setCanUseRemoteService(modes.contains(DbMode.USE_REMOTE));
        if (previousSource == null) {
            this.localSourceModel.init((JAXXContext)ui, null);
        } else {
            this.localSourceModel.initFromPreviousConfig((JAXXContext)ui, previousSourceConfig);
        }
        DbMode dbMode = this.localSourceModel.getDbMode();
        this.localSourceModel.start(dbMode);
        if (log.isDebugEnabled()) {
            this.localSourceModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    Object oldValue = evt.getOldValue();
                    Object newValue = evt.getNewValue();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(evt.getSource() + " - Property [" + name + "] has changed from  " + oldValue + " to " + newValue));
                    }
                }
            });
        }
    }

    protected void startSelectModel() {
        if (!this.needSelect()) {
            return;
        }
        DataSelectionModel selectionModel = this.getSelectionDataModel();
        if (this.containsOperation(AdminStep.EXPORT_DATA)) {
            selectionModel.setUseData(true);
            selectionModel.setUseOpenData(false);
            selectionModel.setUseReferentiel(false);
        }
        if (this.containsOperation(AdminStep.REPORT)) {
            selectionModel.setUseData(true);
            selectionModel.setUseOpenData(true);
            selectionModel.setUseReferentiel(false);
        }
        if (this.containsOperation(AdminStep.VALIDATE)) {
            selectionModel.setUseOpenData(true);
        }
        if (this.containsOperation(AdminStep.CONSOLIDATE)) {
            selectionModel.setUseOpenData(true);
            selectionModel.setUseData(true);
            selectionModel.setUseReferentiel(false);
        }
        selectionModel.addPropertyChangeListener(this.listenSelectModified);
    }

    public void destroy() {
        this.localSourceModel.destroy();
        this.centralSourceModel.destroy();
        this.selectionDataModel.destroy();
        super.destroy();
    }

    public DataSource getPreviousSource() {
        return this.previousSource;
    }

    public DataSource getLocalSource() {
        return this.localSource;
    }

    public DataSource getCentralSource() {
        return this.centralSource;
    }

    public DataSource getTmpSource() {
        return this.tmpSource;
    }

    public DataSource getSafeLocalSource(boolean open) {
        if (this.localSource == null || open && this.localSource.wasClosed()) {
            this.localSource = this.createService(this.getLocalSourceModel());
        }
        if (open) {
            this.doOpenSource(this.localSource);
        }
        return this.localSource;
    }

    public DataSource getSafeCentralSource(boolean open) {
        if (this.centralSource == null || open && this.centralSource.wasClosed()) {
            this.centralSource = this.createService(this.getCentralSourceModel());
        }
        if (open) {
            this.doOpenSource(this.centralSource);
        }
        return this.centralSource;
    }

    public DataSource getSafeTmpSource(boolean open) {
        if (this.tmpSource == null) {
            try {
                this.tmpSource = ObserveServiceHelper.newEmptyTempStorage((IObserveConfig)this.config, (String)I18n.n_((String)"observe.storage.label.synchro"), (String)"synchrodb");
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not create temporary database", e);
            }
            if (open) {
                this.doOpenSource(this.tmpSource);
            }
        }
        return this.tmpSource;
    }

    public StorageUIModel getLocalSourceModel() {
        return this.localSourceModel;
    }

    public StorageUIModel getCentralSourceModel() {
        return this.centralSourceModel;
    }

    public ValidateModel getValidateModel() {
        return (ValidateModel)this.getStepModel(AdminStep.VALIDATE);
    }

    public AccessModel getAccessModel() {
        return (AccessModel)this.getStepModel(AdminStep.ACCESS);
    }

    public ImportGPSModel getImportGPSModel() {
        return (ImportGPSModel)this.getStepModel(AdminStep.IMPORT_GPS);
    }

    public SynchronizeModel getSynchronizeReferentielModel() {
        return (SynchronizeModel)this.getStepModel(AdminStep.SYNCHRONIZE);
    }

    public ExportModel getExportModel() {
        return (ExportModel)this.getStepModel(AdminStep.EXPORT_DATA);
    }

    public ReportModel getReportModel() {
        return (ReportModel)this.getStepModel(AdminStep.REPORT);
    }

    public ConsolidateModel getConsolidateModel() {
        return (ConsolidateModel)this.getStepModel(AdminStep.CONSOLIDATE);
    }

    public SaveLocalModel getSaveLocalModel() {
        return (SaveLocalModel)this.getStepModel(AdminStep.SAVE_LOCAL);
    }

    public void cancel() {
        super.cancel();
        AdminStep newStep = (AdminStep)((Object)this.getSteps().get(this.getSteps().size() - 1));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Operation canceled, will go to final step " + (Object)((Object)newStep)));
        }
        this.gotoStep((WizardStep)newStep);
    }

    public AdminUIModel addOperation(AdminStep operation) {
        if (operation == AdminStep.EXPORT_DATA) {
            this.getOperations().add(AdminStep.SYNCHRONIZE);
        }
        return (AdminUIModel)super.addOperation((WizardExtStep)operation);
    }

    public void removeOperation(AdminStep operation) {
        if (operation == AdminStep.SYNCHRONIZE) {
            this.getOperations().remove((Object)AdminStep.EXPORT_DATA);
        }
        super.removeOperation((WizardExtStep)operation);
    }

    public void setPreviousSource(DataSource previousSource) {
        this.previousSource = previousSource;
    }

    public boolean validate(AdminStep s) {
        boolean validate;
        boolean bl = validate = super.validate((WizardStep)s) && !this.getOperations().isEmpty();
        if (!validate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"not valid from generic states...");
            }
            return false;
        }
        DataSelectionModel selectionModel = this.getSelectionDataModel();
        switch (s) {
            case CONFIG: {
                DbMode dbMode;
                File file;
                if (this.isNeedIncomingDataSource() && !this.localSourceModel.isValid()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"incoming service is not valid");
                    }
                    validate = false;
                }
                if (this.isNeedReferentielDataSource() && !this.centralSourceModel.isValid()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"referentiel service is not valid");
                    }
                    validate = false;
                }
                if (this.containsOperation(AdminStep.VALIDATE)) {
                    ValidatorsMap validators;
                    if (StringUtils.isEmpty((String)this.getValidateModel().getContextName())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validation context name");
                        }
                        return false;
                    }
                    if (this.getValidateModel().getScopes().isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validation scopes");
                        }
                        return false;
                    }
                    if (this.getValidateModel().getModelMode() == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validation model mode");
                        }
                        return false;
                    }
                    if (this.getValidateModel().isGenerateReport()) {
                        file = this.getValidateModel().getReportFile();
                        if (file.exists()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"report file already exists");
                            }
                            return false;
                        }
                        File parentFile = file.getParentFile();
                        if (parentFile == null || !parentFile.exists()) {
                            return false;
                        }
                    }
                    if ((validators = this.getValidateModel().getValidators()).isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validators detected");
                        }
                        return false;
                    }
                    DataSource source = this.getSafeLocalSource(true);
                    if (!(!selectionModel.isUseData() || source.canReadData() && source.canWriteData())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"can not read and write data");
                        }
                        return false;
                    }
                    if (!(!selectionModel.isUseReferentiel() || source.canReadReferentiel() && source.canWriteReferentiel())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"can not read and write referentiel");
                        }
                        return false;
                    }
                }
                if (this.containsOperation(AdminStep.SYNCHRONIZE) && (dbMode = this.localSourceModel.getDbMode()) == this.centralSourceModel.getDbMode() && dbMode == DbMode.USE_REMOTE) {
                    validate &= !this.localSourceModel.getPgConfig().getUrl().equals(this.centralSourceModel.getPgConfig().getUrl());
                }
                if (this.containsOperation(AdminStep.EXPORT_DATA)) {
                    validate &= this.centralSourceModel.getPgConfig().isCanWriteData();
                }
                if (this.containsOperation(AdminStep.IMPORT_GPS)) {
                    file = this.getImportGPSModel().getImportGPSFile();
                    validate &= file != null && file.exists();
                }
                if (this.containsOperation(AdminStep.ACCESS) && validate) {
                    file = this.getAccessModel().getImportFile();
                    File file2 = this.getAccessModel().getOutputFile();
                    validate &= file != null && file.exists() && file2 != null && !file2.exists() && file2.getParentFile().exists();
                }
                if (!this.containsOperation(AdminStep.REPORT)) break;
                File reportFile = this.getReportModel().getReportFile();
                validate &= reportFile != null && reportFile.exists();
                break;
            }
            case SELECT_DATA: {
                boolean empty;
                if (this.containsOperation(AdminStep.VALIDATE) && (validate &= this.validate(AdminStep.CONFIG))) {
                    empty = selectionModel.isEmpty();
                    validate &= !empty;
                }
                if (this.containsOperation(AdminStep.EXPORT_DATA) && (validate &= this.validate(AdminStep.CONFIG))) {
                    empty = selectionModel.isDataEmpty();
                    validate &= !empty;
                }
                if (this.containsOperation(AdminStep.CONSOLIDATE) && (validate &= this.validate(AdminStep.CONFIG))) {
                    empty = selectionModel.isDataEmpty();
                    validate &= !empty;
                }
                if (!this.containsOperation(AdminStep.REPORT) || !(validate &= this.validate(AdminStep.CONFIG))) break;
                empty = selectionModel.isDataEmpty();
                validate &= !empty && selectionModel.getSelectedData().size() == 1;
                break;
            }
            case VALIDATE: {
                validate &= this.validate(AdminStep.SELECT_DATA) && this.getStepState(s) == WizardState.SUCCESSED;
                break;
            }
            case EXPORT_DATA: {
                validate &= this.validate(AdminStep.SELECT_DATA) && this.getStepState(s) == WizardState.SUCCESSED;
                break;
            }
            case CONSOLIDATE: {
                validate &= this.validate(AdminStep.SELECT_DATA) && this.getStepState(s) == WizardState.SUCCESSED;
                break;
            }
            case ANALYZE_ACCESS: {
                validate &= this.getStepState(s) == WizardState.SUCCESSED;
                break;
            }
            case ACCESS: {
                validate &= this.validate(AdminStep.ANALYZE_ACCESS) && this.getAccessModel().getSelectedProgramme() != null && this.getStepState(s) == WizardState.SUCCESSED;
                break;
            }
            case REPORT: {
                validate &= this.validate(AdminStep.SELECT_DATA);
                break;
            }
            case SYNCHRONIZE: 
            case IMPORT_GPS: {
                validate &= this.getStepState(s) == WizardState.SUCCESSED;
                break;
            }
            case SAVE_LOCAL: {
                validate &= this.getSaveLocalModel().isCanSaveLocal() && this.getStepState(s) == WizardState.SUCCESSED;
                break;
            }
            case SHOW_RESUME: {
                validate = true;
            }
        }
        return validate;
    }

    protected AdminStep[] updateStepUniverse() {
        ArrayList<AdminStep> universe = new ArrayList<AdminStep>();
        universe.add(AdminStep.CONFIG);
        boolean needResume = true;
        if (!this.operations.isEmpty()) {
            if (this.needSelect()) {
                universe.add(AdminStep.SELECT_DATA);
            }
            if (this.containsOperation(AdminStep.REPORT)) {
                universe.add(AdminStep.REPORT);
                needResume = false;
            }
            if (this.containsOperation(AdminStep.SYNCHRONIZE)) {
                universe.add(AdminStep.SYNCHRONIZE);
            }
            if (this.containsOperation(AdminStep.ACCESS)) {
                universe.add(AdminStep.ANALYZE_ACCESS);
                universe.add(AdminStep.ACCESS);
            }
            if (this.containsOperation(AdminStep.VALIDATE)) {
                universe.add(AdminStep.VALIDATE);
            }
            if (this.containsOperation(AdminStep.CONSOLIDATE)) {
                universe.add(AdminStep.CONSOLIDATE);
            }
            if (this.containsOperation(AdminStep.IMPORT_GPS)) {
                universe.add(AdminStep.IMPORT_GPS);
            }
            this.updateSaveLocalOperation();
            if (this.containsOperation(AdminStep.SAVE_LOCAL)) {
                universe.add(AdminStep.SAVE_LOCAL);
            }
            if (this.containsOperation(AdminStep.EXPORT_DATA)) {
                universe.add(AdminStep.EXPORT_DATA);
            }
            if (needResume) {
                universe.add(AdminStep.SHOW_RESUME);
            }
        }
        return universe.toArray(new AdminStep[universe.size()]);
    }

    public void removeLocalSource() {
        if (this.localSource != null) {
            this.doCloseSource(this.localSource, false);
            this.localSource = null;
        }
    }

    public void removeCentralSource() {
        if (this.centralSource != null) {
            this.doCloseSource(this.centralSource, false);
            this.centralSource = null;
        }
    }

    public void removeTmpSource() {
        if (this.tmpSource != null) {
            this.doCloseSource(this.tmpSource, false);
            this.tmpSource = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateSelectionModel(DataService dataService, DataSource source) {
        try {
            DataSelectionModel.populate((DataSelectionModel)this.getSelectionDataModel(), (DataService)dataService, (DataSource)source);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"could not populate selected model", (Throwable)e);
            }
        }
        finally {
            this.firePropertyChange(SELECTION_MODEL_CHANGED_PROPERTY_NAME, this.getSelectionDataModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeExistingMarees(DataSource source) {
        String txName = "computeExistingMarees";
        try {
            TopiaContext tx = source.beginTransaction(txName);
            try {
                List ids = ObserveDAOHelper.getMareeDAO((TopiaContext)tx).findAllIds();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found " + ids.size() + "existing maree(s)"));
                }
                this.getExportModel().setExistingMareeIds(ids);
            }
            finally {
                source.closeTransaction(tx, txName);
            }
        }
        catch (Exception e) {
            log.error((Object)"Can not have existing maree...", (Throwable)e);
        }
    }

    protected void updateSaveLocalOperation() {
        boolean shouldAdd = false;
        for (AdminStep s : this.operations) {
            if (!s.isNeedSave()) continue;
            shouldAdd = true;
        }
        if (shouldAdd) {
            this.operations.add(AdminStep.SAVE_LOCAL);
        } else {
            this.operations.remove((Object)AdminStep.SAVE_LOCAL);
        }
    }

    protected DataSource createService(StorageUIModel model) {
        try {
            DataSource service = this.storageHandler.newServiceFromModel(model, false, I18n.n_((String)"observe.storage.label.local"), I18n.n_((String)"observe.storage.label.remote"));
            return service;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create service for " + (Object)((Object)model), e);
        }
    }

    protected void doOpenSource(DataSource source) {
        if (source == null || source.isOpen()) {
            return;
        }
        try {
            source.doOpen();
        }
        catch (DataSourceException e) {
            throw new IllegalStateException("Could not open " + source, e);
        }
    }

    protected void doCloseSource(DataSource source, boolean destroy) {
        if (source == null || !source.isOpen() || source.wasClosed()) {
            return;
        }
        try {
            source.doClose(destroy);
        }
        catch (DataSourceException e) {
            throw new IllegalStateException("Could not close " + source, e);
        }
    }
}

