/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report.model;

import fr.ird.observe.ui.admin.report.model.ReportOperation;
import fr.ird.observe.ui.admin.report.model.ReportRequest;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class Report
implements Serializable {
    private static final Log log = LogFactory.getLog(Report.class);
    protected final String id;
    protected final String name;
    protected final String description;
    protected final String[] columnHeaders;
    protected final String[] rowHeaders;
    protected final ReportRequest[] requests;
    protected final ReportOperation[] operations;
    protected final Map<String, Class<?>> requestVariables;
    private static final long serialVersionUID = 1L;

    public Report(String id, String name, String description, String[] rowHeaders, String[] columnHeaders, ReportOperation[] operations, Map<String, Class<?>> requestVariables, ReportRequest ... requests) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.rowHeaders = rowHeaders;
        this.columnHeaders = columnHeaders;
        this.requests = requests;
        this.operations = operations;
        this.requestVariables = requestVariables;
        if (log.isDebugEnabled()) {
            log.debug((Object)("New report [" + id + ":" + name + "], nb requests : " + requests.length + ", nb operations : " + operations.length + ", nb variables : " + requestVariables.size()));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getRows() {
        return this.rowHeaders == null ? -1 : this.rowHeaders.length;
    }

    public int getColumns() {
        return this.columnHeaders == null ? -1 : this.columnHeaders.length;
    }

    public String[] getColumnHeaders() {
        return this.columnHeaders;
    }

    public String[] getRowHeaders() {
        return this.rowHeaders;
    }

    public ReportRequest[] getRequests() {
        return this.requests;
    }

    public ReportOperation[] getOperations() {
        return this.operations;
    }

    public Map<String, Class<?>> getRequestVariables() {
        return this.requestVariables;
    }

    public String toString() {
        return I18n._((String)this.name);
    }
}

