/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report;

import fr.ird.observe.ui.admin.report.model.Report;
import fr.ird.observe.ui.admin.report.model.ReportOperation;
import fr.ird.observe.ui.admin.report.model.ReportRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.SortedProperties;

public class ReportBuilder {
    public static final Pattern REPORT_DEFINITION_PATTERN = Pattern.compile("report.(\\w+).name");
    public static final String REQUEST_PREFIX = "request.";
    public static final String OPERATION_PREFIX = "operation.";
    private static final Log log = LogFactory.getLog(ReportBuilder.class);
    protected Properties properties;
    protected List<String> reportNames;
    protected static Map<String, Class<?>> operations;

    public static Map<String, Class<?>> getOperations() {
        if (operations == null) {
            operations = new TreeMap();
            ServiceLoader<ReportOperation> loader = ServiceLoader.load(ReportOperation.class);
            for (ReportOperation operation : loader) {
                log.info((Object)("Detected operation : " + operation.getOperationName()));
                operations.put(operation.getOperationName(), operation.getClass());
            }
        }
        return operations;
    }

    public static ReportOperation newOperation(String operationName) {
        Class<?> operationType = ReportBuilder.getOperations().get(operationName);
        if (operationType == null) {
            throw new IllegalArgumentException("No such operation [" + operationName + "], available operations : " + ReportBuilder.getOperations().keySet());
        }
        try {
            Object result = operationType.newInstance();
            return (ReportOperation)result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instanciate operation [" + operationType + "]", e);
        }
    }

    public List<String> getReportNames() {
        return this.reportNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Report> load(URL definition) throws IOException {
        this.properties = new SortedProperties();
        InputStream in = definition.openStream();
        try {
            this.properties.load(in);
        }
        finally {
            in.close();
        }
        this.reportNames = this.detectReportNames();
        log.info((Object)("Detected report names : " + this.reportNames));
        ArrayList<Report> reports = new ArrayList<Report>();
        for (String reportName : this.reportNames) {
            Report report = this.build(reportName);
            reports.add(report);
        }
        return reports;
    }

    protected List<String> detectReportNames() {
        ArrayList<String> reportNames = new ArrayList<String>();
        Enumeration<Object> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Matcher matcher = REPORT_DEFINITION_PATTERN.matcher(key);
            if (!matcher.matches()) continue;
            String reportName = matcher.group(1);
            log.info((Object)("Discover a new report : " + reportName));
            reportNames.add(reportName);
        }
        return reportNames;
    }

    protected Report build(String reportName) {
        Map<String, String> dico = this.detectReportProperties(reportName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will build report [" + reportName + "] with " + dico.size() + " properties (" + dico + ")."));
        }
        String name = this.getValue(dico, "name");
        String description = this.getValue(dico, "description");
        String rows = this.getValue(dico, "rows");
        String columns = this.getValue(dico, "columns");
        String[] rowHeaders = rows == null ? null : rows.split(",");
        String[] columnHeaders = columns == null ? null : columns.split(",");
        ReportRequest[] requests = this.getRequests(reportName, dico);
        ReportOperation[] operations = this.getOperations(reportName, dico);
        TreeMap requestVariables = new TreeMap();
        if (!dico.isEmpty()) {
            log.warn((Object)("Il reste des propri\u00e9t\u00e9s non utilis\u00e9es pour le report [" + reportName + "] : " + dico));
        }
        Report report = new Report(reportName, name, description, rowHeaders, columnHeaders, operations, requestVariables, requests);
        return report;
    }

    protected Map<String, String> detectReportProperties(String reportName) {
        TreeMap<String, String> dico = new TreeMap<String, String>();
        String reportKeyPrefix = "report." + reportName + ".";
        int reportKeyPrefixLength = reportKeyPrefix.length();
        Enumeration<Object> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(reportKeyPrefix)) continue;
            String realKey = key.substring(reportKeyPrefixLength);
            dico.put(realKey, (String)this.properties.get(key));
        }
        return dico;
    }

    private ReportRequest[] getRequests(String reportName, Map<String, String> dico) {
        TreeMap<Integer, String> requestDico = new TreeMap<Integer, String>();
        Iterator<Map.Entry<String, String>> itr = dico.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, String> entry = itr.next();
            String key = entry.getKey();
            if (!key.startsWith(REQUEST_PREFIX)) {
                log.warn((Object)("[" + reportName + "] Requete non reconnue avec la clef : " + key));
                continue;
            }
            String request = entry.getValue();
            String requestId = key.substring(REQUEST_PREFIX.length());
            Integer id = Integer.valueOf(requestId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Detects a request [" + reportName + ":" + id + "] = " + request));
            }
            requestDico.put(id, request);
            itr.remove();
        }
        ArrayList ids = new ArrayList(requestDico.keySet());
        Collections.sort(ids);
        ArrayList<ReportRequest> result = new ArrayList<ReportRequest>();
        for (Integer id : ids) {
            String requestDef = (String)requestDico.get(id);
            ReportRequest def = this.getRequest(requestDef);
            if (log.isInfoEnabled()) {
                log.info((Object)("Detects a request : " + def));
            }
            result.add(def);
        }
        return result.toArray(new ReportRequest[result.size()]);
    }

    private ReportRequest getRequest(String requestDef) {
        String[] parts = requestDef.split("\\|");
        if (parts.length != 3) {
            throw new IllegalArgumentException("La d\u00e9finition de la requete doit etre de type 'X,Y|layout|hql' mais est : " + requestDef);
        }
        String[] coords = parts[0].split(",");
        String layout = parts[1];
        String hql = parts[2];
        if (coords.length != 2) {
            throw new IllegalArgumentException("La d\u00e9finition des coordon\u00e9es doit etre de type 'X,Y' mais est : " + parts[0]);
        }
        int x = Integer.valueOf(coords[0]);
        int y = Integer.valueOf(coords[1]);
        ReportRequest.RequestLayout realLayout = ReportRequest.RequestLayout.valueOf(layout);
        ReportRequest def = new ReportRequest(realLayout, x, y, hql);
        return def;
    }

    private ReportOperation[] getOperations(String reportName, Map<String, String> dico) {
        TreeMap<Integer, String> requestDico = new TreeMap<Integer, String>();
        Iterator<Map.Entry<String, String>> itr = dico.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, String> entry = itr.next();
            String key = entry.getKey();
            if (!key.startsWith(OPERATION_PREFIX)) {
                log.warn((Object)("[" + reportName + "] Operation non reconnue avec la clef : " + key));
                continue;
            }
            String operation = entry.getValue();
            String requestId = key.substring(OPERATION_PREFIX.length());
            Integer id = Integer.valueOf(requestId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Detects a operation [" + reportName + ":" + id + "] = " + operation));
            }
            requestDico.put(id, operation);
            itr.remove();
        }
        ArrayList ids = new ArrayList(requestDico.keySet());
        Collections.sort(ids);
        ArrayList<ReportOperation> result = new ArrayList<ReportOperation>();
        for (Integer id : ids) {
            String operationDef = (String)requestDico.get(id);
            ReportOperation def = this.getOperation(operationDef);
            if (log.isInfoEnabled()) {
                log.info((Object)("Detects a operation : " + def));
            }
            result.add(def);
        }
        return result.toArray(new ReportOperation[result.size()]);
    }

    private ReportOperation getOperation(String operationDef) {
        String operationName = operationDef;
        ReportOperation def = ReportBuilder.newOperation(operationName);
        return def;
    }

    protected String getValue(Map<String, String> dico, String key) {
        String value = dico.get(key);
        if (value != null) {
            dico.remove(key);
        }
        return value;
    }

    public void clear() {
        if (this.reportNames != null) {
            this.reportNames.clear();
            this.reportNames = null;
        }
        if (this.properties != null) {
            this.properties.clear();
            this.properties = null;
        }
    }
}

