/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.entities.Route;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.tree.AbstractObserveTreeCellRenderer;
import fr.ird.observe.ui.tree.NavigationTreeSelectionModel;
import fr.ird.observe.ui.tree.ObserveDataProvider;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.loadors.ActiviteNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ActivitesNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ProgrammeNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.RootNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.RoutesNodeChildLoador;
import java.awt.Container;
import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeHelper;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ObserveTreeHelper
extends NavTreeHelper<ObserveNode> {
    private static final Log log = LogFactory.getLog(ObserveTreeHelper.class);
    protected DataService dataService;

    protected DataService getDataService() {
        if (this.dataService == null) {
            this.dataService = ObserveContext.get().getDataService();
        }
        return this.dataService;
    }

    protected ObserveDataProvider getDataProvider() {
        DataSource source;
        ObserveDataProvider provider = (ObserveDataProvider)super.getDataProvider();
        if (provider == null && (source = ObserveContext.get().getDataSource()) != null) {
            provider = new ObserveDataProvider(source);
            this.setDataProvider(provider);
        }
        return provider;
    }

    public NavigationTreeSelectionModel newNavigationSelectionModel() {
        NavigationTreeSelectionModel model = new NavigationTreeSelectionModel();
        model.setSelectionMode(1);
        return model;
    }

    public AbstractObserveTreeCellRenderer getTreeCellRenderer() {
        JTree t = (JTree)this.getUI();
        if (t == null) {
            return null;
        }
        TreeCellRenderer r = t.getCellRenderer();
        return (AbstractObserveTreeCellRenderer)((Object)(r instanceof AbstractObserveTreeCellRenderer ? r : null));
    }

    public TreeModel createEmptyModel() {
        this.setDataSource(null);
        ObserveNode node = new ObserveNode(I18n.n_((String)"observe.message.db.none.loaded"), false);
        DefaultTreeModel model = this.createModel(node, new Object[0]);
        return model;
    }

    public TreeModel createModel(DataSource source) {
        this.setDataSource(source);
        ObserveNode node = new ObserveNode(String.class, "Root node", null, new RootNodeChildLoador(true, true), false);
        DefaultTreeModel model = this.createModel(node, new Object[0]);
        node.populateChilds(this.getBridge(), this.getDataProvider());
        return model;
    }

    public DefaultTreeModel createModel(JAXXContext context, DataSelectionModel dataModel, DataSource source) {
        this.setDataSource(source);
        context.setContextValue((Object)dataModel);
        if (log.isDebugEnabled()) {
            log.debug((Object)("create tree model " + (Object)((Object)this)));
        }
        ObserveDataProvider dataProvider = this.getDataProvider();
        RootNodeChildLoador loador = (RootNodeChildLoador)ObserveTreeHelper.getChildLoador(RootNodeChildLoador.class);
        loador.setAddData(dataModel.isUseData());
        loador.setAddReferentiel(dataModel.isUseReferentiel());
        dataProvider.setSelectionModel(dataModel);
        ObserveNode node = new ObserveNode(String.class, "Root node", loador, false);
        DefaultTreeModel model = this.createModel(node, new Object[0]);
        this.loadAllNodes((NavNode)node, this.getDataProvider());
        return model;
    }

    public void loadNavigationUI(DataSource source, ObserveMainUI mainUI) {
        this.createModel(source);
        this.selectInitialNode(mainUI);
        ((JTree)this.getUI()).setVisible(true);
    }

    public void cleanNavigationUI(ObserveMainUI mainUI) {
        this.setDataSource(null);
        mainUI.getContentLayout().reset((Container)mainUI.getContent());
        mainUI.getContextValue(SwingValidatorMessageTableModel.class).clear();
        JTree tree = (JTree)this.getUI();
        ObserveNode root = (ObserveNode)((NavTreeBridge)this.getBridge()).getRoot();
        root.removeAllChildren();
        this.createEmptyModel();
        tree.setVisible(false);
    }

    public void selectOpenNode(JAXXContext ui, Class<?> type) {
        DataContext context = (DataContext)ui.getContextValue(DataContext.class);
        Object[] ids = context.getOpenIds(type);
        log.info((Object)("using open ids = " + Arrays.toString(ids)));
        if (ids == null) {
            return;
        }
        this.selectNode((String[])ids);
    }

    public void selectInitialNode(ObserveMainUI ui) {
        Object[] path;
        DataContext context = ui.getDataContext();
        JTree tree = (JTree)this.getUI();
        TreeModel treeModel = tree.getModel();
        String id = context.getHigherOpenId();
        if (id != null) {
            path = context.getOpenIds();
        } else {
            ObserveNode node = (ObserveNode)((Object)treeModel.getRoot());
            if (!node.isLeaf()) {
                node = (ObserveNode)node.getFirstChild();
            }
            path = new String[]{node.getId()};
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected path : " + Arrays.toString(path)));
        }
        this.selectNode((String[])path);
        tree.requestFocus();
    }

    public ObserveNode addUnsavedNode(ObserveNode parentNode, Class<?> type) {
        DecoratorService decorator = this.getDataService().getDecoratorService();
        String label = decorator.getEntityLabel(type) + ".unsaved";
        ObserveNode result = new ObserveNode(type, null, label, null, false);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        this.refreshNode((NavNode)parentNode, true);
        ((JTree)this.getUI()).fireTreeExpanded(new TreePath(result.getPath()));
        this.selectNode((NavNode)result);
        return result;
    }

    public ObserveNode addMaree(ObserveNode parentNode, Maree bean) {
        ObserveNode result = ((ProgrammeNodeChildLoador)ObserveTreeHelper.getChildLoador(ProgrammeNodeChildLoador.class)).createNode(bean, this.dataProvider);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addRoute(ObserveNode parentNode, Route bean) {
        ObserveNode result = ((RoutesNodeChildLoador)ObserveTreeHelper.getChildLoador(RoutesNodeChildLoador.class)).createNode(bean, this.dataProvider);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addActivite(ObserveNode parentNode, Activite bean) {
        ObserveNode result = ((ActivitesNodeChildLoador)ObserveTreeHelper.getChildLoador(ActivitesNodeChildLoador.class)).createNode(bean, this.dataProvider);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addObjetFlottant(ObserveNode parentNode, ObjetFlottant bean) {
        ObserveNode result = ((ActiviteNodeChildLoador)ObserveTreeHelper.getChildLoador(ActiviteNodeChildLoador.class)).createNode(bean, this.dataProvider);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    public ObserveNode addCalee(ObserveNode parentNode, Calee bean) {
        ObserveNode result = ((ActiviteNodeChildLoador)ObserveTreeHelper.getChildLoador(ActiviteNodeChildLoador.class)).createCaleeNode(bean);
        this.insertNode((NavNode)parentNode, (NavNode)result);
        return result;
    }

    void setDataSource(DataSource source) {
        ObserveDataProvider provider = null;
        if (source != null) {
            provider = new ObserveDataProvider(source);
        }
        this.setDataProvider(provider);
    }
}

