/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage.tabs;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.ConnexionStatus;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.db.install.PGInstall;
import fr.ird.observe.db.install.SecurityModel;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.storage.tabs.BackupUI;
import fr.ird.observe.ui.storage.tabs.ChooseDbModeUI;
import fr.ird.observe.ui.storage.tabs.ConfigUI;
import fr.ird.observe.ui.storage.tabs.ConfirmUI;
import fr.ird.observe.ui.storage.tabs.RolesTableModel;
import fr.ird.observe.ui.storage.tabs.RolesUI;
import fr.ird.observe.ui.storage.tabs.SelectDataUI;
import fr.ird.observe.ui.tree.DataSelectionTreeCellRenderer;
import fr.ird.observe.ui.tree.DataSelectionTreeSelectionModel;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.editor.MyDefaultCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;

public class StorageTabUIHandler {
    private static final Log log = LogFactory.getLog(StorageTabUIHandler.class);

    public boolean updateCreationModeLayout(ChooseDbModeUI ui, boolean visible, JRadioButton button) {
        JPanel panel = ui.getCreationModeContent();
        if (visible) {
            for (Component c : panel.getComponents()) {
                if (!button.equals(c)) continue;
                return visible;
            }
            panel.add(button);
        } else {
            for (Component c : panel.getComponents()) {
                if (!button.equals(c)) continue;
                panel.remove(c);
                return visible;
            }
        }
        return visible;
    }

    public void initUI(final ChooseDbModeUI ui) {
        UIHelper.getLayer((JComponent)ui.getCreationModeContent()).setUI((LayerUI)ui.getCreationModeBlockLayerUI());
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StorageUIModel model = (StorageUIModel)((Object)evt.getSource());
                DbMode dbMode = model.getDbMode();
                CreationMode creationMode = model.getCreationMode();
                StringBuilder sb = new StringBuilder();
                StorageUIHandler.addTag("h3", sb, I18n._((String)"observe.storage.selected.dbMode"));
                if (dbMode == null) {
                    StorageUIHandler.addTag("pre", sb, I18n._((String)"observe.storage.no.dbMode"));
                } else {
                    StorageUIHandler.addTag("pre", sb, I18n._((String)dbMode.getDescription()));
                }
                StorageUIHandler.addTag("h3", sb, I18n._((String)"observe.storage.selectedCreationMode"));
                if (DbMode.CREATE_LOCAL == dbMode) {
                    if (creationMode == null) {
                        StorageUIHandler.addTag("pre", sb, I18n._((String)"observe.storage.no.creationMode"));
                    } else {
                        StorageUIHandler.addTag("pre", sb, I18n._((String)creationMode.getDescription()));
                    }
                } else {
                    StorageUIHandler.addTag("pre", sb, I18n._((String)"observe.storage.no.creationMode.required"));
                }
                String txt = sb.toString();
                ui.getResume().setText(txt);
            }
        };
        StorageUIModel model = ui.getModel();
        model.addPropertyChangeListener("dbMode", listener);
        model.addPropertyChangeListener("creationMode", listener);
        ui.setDescriptionText(I18n._((String)ui.getStep().getDescription()));
    }

    public void initUI(final ConfigUI ui) {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StorageUIModel model = (StorageUIModel)((Object)evt.getSource());
                String propertyName = evt.getPropertyName();
                if ("creationMode".equals(propertyName) || "dbMode".equals(propertyName)) {
                    String id = null;
                    if (model.getDbMode() == DbMode.USE_REMOTE) {
                        id = DbMode.USE_REMOTE.name();
                    } else if (model.getCreationMode() != null) {
                        id = model.getCreationMode().name();
                    }
                    if (id != null) {
                        StorageTabUIHandler.this.refreshConfig(ui, id);
                    }
                }
            }
        };
        ui.getModel().addPropertyChangeListener(listener);
    }

    public void initUI(final RolesUI ui) {
        if (ui.getStep() != null) {
            ui.setDescriptionText(I18n._((String)ui.getStep().getDescription()));
        }
        ui.getSecurityModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Security model changed [" + evt.getPropertyName() + "] <" + evt.getOldValue() + " : " + evt.getNewValue() + ">"));
                }
                ui.getModel().validate();
            }
        });
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StorageUIModel model = (StorageUIModel)((Object)evt.getSource());
                StorageStep oldStep = (StorageStep)((Object)evt.getOldValue());
                StorageStep newStep = (StorageStep)((Object)evt.getNewValue());
                if (newStep == StorageStep.ROLES && oldStep == StorageStep.CONFIG) {
                    StorageTabUIHandler.this.updateSecurity(model, ui.getRolesModel());
                }
            }
        };
        ui.getModel().addPropertyChangeListener("step", listener);
        JTable table = ui.getRoles();
        table.setRowHeight(24);
        UIHelper.fixTableColumnWidth((JTable)table, (int)1, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)2, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)100);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{RolesTableModel.COLUMN_NAMES[0], RolesTableModel.COLUMN_NAME_TIPS[0], RolesTableModel.COLUMN_NAMES[1], RolesTableModel.COLUMN_NAME_TIPS[1], RolesTableModel.COLUMN_NAMES[2], RolesTableModel.COLUMN_NAME_TIPS[2], RolesTableModel.COLUMN_NAMES[3], RolesTableModel.COLUMN_NAME_TIPS[3], RolesTableModel.COLUMN_NAMES[4], RolesTableModel.COLUMN_NAME_TIPS[4]});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)50, (boolean)true));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((DefaultTableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((DefaultTableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((DefaultTableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((DefaultTableCellRenderer)renderer));
        UIHelper.setTableColumnEditor((JTable)table, (int)1, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor());
        UIHelper.setTableColumnEditor((JTable)table, (int)2, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor());
        UIHelper.setTableColumnEditor((JTable)table, (int)3, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor());
        UIHelper.setTableColumnEditor((JTable)table, (int)4, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor());
    }

    public void initUI(SelectDataUI ui) {
        if (ui.getStep() != null) {
            ui.setDescriptionText(I18n._((String)ui.getStep().getDescription()));
        }
        DataSelectionTreeCellRenderer.initUI(ui.getSelectTree());
    }

    public void initUI(BackupUI ui) {
        if (ui.getStep() != null) {
            ui.setDescriptionText(I18n._((String)ui.getStep().getDescription()));
        }
    }

    public void initUI(ConfirmUI ui) {
        if (ui.getStep() != null) {
            ui.setDescriptionText(I18n._((String)ui.getStep().getDescription()));
        }
    }

    public void updateSecurity(StorageUIModel model, RolesTableModel roleModel) {
        SecurityModel security = model.getSecurityModel();
        PGInstall pgInstall = model.getPgInstall();
        PGDataSourceConfig config = model.getPgConfig();
        pgInstall.init(config, security);
        security.setAdministrateur(config.getLogin());
        try {
            Set roles = pgInstall.getRoles();
            String ownerRole = security.getAdministrateur();
            if (!roles.contains(ownerRole)) {
                log.warn((Object)("Could not find owner role : " + ownerRole));
            } else {
                roles.remove(ownerRole);
            }
            log.info((Object)("Db roles : " + roles));
            security.init((Iterable)roles);
            roleModel.init(security);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not obtain db roles", e);
        }
    }

    public boolean testRemote(JAXXContext context, StorageUIModel model) {
        boolean result = model.getPgConfig().canConnect();
        if (log.isDebugEnabled()) {
            log.debug((Object)("result : " + result));
        }
        model.firePgConfigChanged("connexionStatus", null, null);
        return result;
    }

    public void chooseBackupFile(BackupUI ui) {
        File f = UIHelper.chooseDirectory(ui, I18n._((String)"observe.title.choose.db.dump.directory"), I18n._((String)"observe.action.choose.db.dump.directory"), new File(ui.getDirectoryText().getText()));
        this.changeDirectory(ui, f);
    }

    public void changeDirectory(BackupUI ui, File f) {
        ui.getModel().setBackupFile(new File(f, ui.getFilenameText().getText()));
    }

    public void changeFilename(BackupUI ui, String filename) {
        ui.getModel().setBackupFile(new File(ui.getDirectoryText().getText(), filename));
    }

    public void refreshConfig(ConfigUI ui, String configId) {
        JComponent c = (JComponent)ui.getObjectById(configId);
        if (c != null) {
            log.debug((Object)configId);
            ui.configLayout.show(ui.configContent, configId);
            String text = (String)c.getClientProperty("description");
            ui.setDescriptionText(I18n._((String)text));
            if (c.equals(ui.IMPORT_REMOTE_STORAGE)) {
                ui.IMPORT_REMOTE_STORAGE_content.add((Component)ui.remoteConfig, "Center");
            } else if (c.equals(ui.USE_REMOTE)) {
                ui.USE_REMOTE_content.add((Component)ui.remoteConfig, "Center");
            }
        }
    }

    public Icon updateConnexionStatutIcon(ConfigUI ui, ConnexionStatus status) {
        Icon icon = (Icon)ui.getConnexionStatus().getClientProperty(status.name().toLowerCase() + "Icon");
        return icon;
    }

    public Color updateConnexionStatutColor(ConfigUI ui, ConnexionStatus status) {
        Color color = (Color)ui.getConnexionStatus().getClientProperty(status.name().toLowerCase() + "Color");
        return color;
    }

    public String updateConnexionStatutText(ConfigUI ui, ConnexionStatus status) {
        String text = status.getDescription();
        switch (status) {
            case UNTESTED: {
                text = I18n._((String)text);
                break;
            }
            case SUCCESS: {
                text = I18n._((String)text, (Object[])new Object[]{ui.model.getPgConfig().toString()});
                break;
            }
            case FAILED: {
                text = I18n._((String)text, (Object[])new Object[]{ui.model.getPgConfig().getConnexionError().getMessage()});
            }
        }
        return text;
    }

    public void chooseDumpFile(ConfigUI ui) {
        File f = UIHelper.chooseFile(ui, I18n._((String)"observe.title.choose.db.dump"), I18n._((String)"observe.action.choose.db.dump"), ui.getModel().getDumpFile(), "^.+\\.sql\\.gz$", I18n._((String)"observe.action.choose.db.dump.description"));
        ui.getModel().setDumpFile(f);
    }

    public void chooseSslCertificatFile(ConfigUI ui) {
        File f = UIHelper.chooseFile(ui, I18n._((String)"observe.title.choose.ssl.cert"), I18n._((String)"observe.action.choose.ssl.cert"), ui.getModel().getSslCertificatFile(), "^.+\\.jks$", I18n._((String)"observe.action.choose.ssl.cert.description"));
        ui.getModel().setSslCertificatFile(f);
    }

    public void initTree(SelectDataUI ui) {
        StorageUIModel model = ui.getModel();
        if (model.isUseSelectData()) {
            DataSelectionModel dataModel = model.getSelectDataModel();
            ObserveTreeHelper helper = new ObserveTreeHelper();
            JTree tree = ui.selectTree;
            helper.setUI(tree, false, null);
            DataSource source = ObserveContext.get().getDataSource();
            tree.setModel(helper.createModel((JAXXContext)ui, dataModel, source));
            DataSelectionTreeSelectionModel selectionModel = ui.getSelectionModel();
            selectionModel.initUI(tree);
            selectionModel.setDataModel(dataModel);
        }
    }

    protected String updateInternalDumpModeLabel(ChooseDbModeUI ui, boolean dumpExist) {
        File f = ui.getContextValue(ObserveConfig.class).getInitialDbDump();
        String text = f.exists() ? I18n._((String)"observe.storage.internalDump.last.modified", (Object[])new Object[]{new Date(f.lastModified())}) : I18n._((String)"observe.storage.internalDump.not.exist");
        return I18n._((String)CreationMode.IMPORT_INTERNAL_DUMP.getLabel()) + text;
    }

    protected String updateCanMigrateLabel(ChooseDbModeUI ui, boolean canMigrate) {
        String text = I18n._((String)"observe.storage.action.canMigrate", (Object[])new Object[]{ui.getModel().getDbVersion()});
        return text;
    }
}

