/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.ref;

import fr.ird.observe.BinderService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.EntityMap;
import fr.ird.observe.entities.ReferentielLocaleEnum;
import fr.ird.observe.entities.ReferentielStatusEnum;
import fr.ird.observe.entities.referentiel.I18nReferentielEntity;
import fr.ird.observe.entities.referentiel.NeedCommentReferentielEntity;
import fr.ird.observe.entities.referentiel.ReferentielEntity;
import fr.ird.observe.ui.SpringUtilities;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.ref.ContentReferentielUI;
import fr.ird.observe.ui.content.ref.ContentReferentielUIModel;
import fr.ird.observe.ui.content.ref.UniqueKeyTableModel;
import fr.ird.observe.ui.usage.UsagesUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.Deletor;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderBuilder;

public class ContentReferentielUIHandler<E extends ReferentielEntity>
extends ContentUIHandler<E> {
    private static final Log log = LogFactory.getLog(ContentReferentielUIHandler.class);
    protected String[] properties;
    protected String[] dataBinding;
    protected String[] naturalIds;
    protected static final String[] DEFAULT_DATABINDING = new String[]{"code.text", "uri.text", "status.selectedIndex"};
    protected static final String[] DEFAULT_NEED_COMMENT_DATABINDING = new String[]{"needComment.selected"};
    protected static final String[] DEFAULT_I18N_DATABINDING = new String[]{"libelle1.text", "libelle2.text", "libelle3.text", "libelle4.text", "libelle5.text", "libelle6.text", "libelle7.text", "libelle8.text"};
    protected static final String[] DEFAULT_PROPERTIES = new String[]{"code", "uri", "status"};
    protected static final String[] DEFAULT_NEED_COMMENT_PROPERTIES = new String[]{"needComment"};
    protected static final String[] DEFAULT_I18N_PROPERTIES = new String[]{"libelle1", "libelle2", "libelle3", "libelle4", "libelle5", "libelle6", "libelle7", "libelle8"};
    Runnable revalidate = new Runnable(){

        @Override
        public void run() {
            ContentUI ui = ContentReferentielUIHandler.this.getUi();
            Container parent = ui.getParent();
            if (parent == null) {
                return;
            }
            log.info((Object)("Will revalidate " + parent.getName()));
            ui.revalidate();
        }
    };

    public ContentReferentielUIHandler(ContentReferentielUI<E> ui, String[] extraProperties, String[] naturalIds, String ... extraBindings) {
        super(ui);
        String[] stringArray;
        boolean useDefault;
        boolean bl = useDefault = naturalIds == null;
        if (useDefault) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = DEFAULT_PROPERTIES[0];
        } else {
            stringArray = naturalIds;
        }
        this.naturalIds = stringArray;
        List<String> bindings = this.buildDataBindings(useDefault, extraBindings);
        List<String> properties = this.buildProperties(useDefault, extraProperties);
        if (log.isDebugEnabled()) {
            log.debug((Object)("useDefault = " + useDefault));
            log.debug((Object)("dataBinding = " + bindings));
            log.debug((Object)("properties = " + properties));
        }
        this.dataBinding = bindings.toArray(new String[bindings.size()]);
        this.properties = properties.toArray(new String[properties.size()]);
    }

    @Override
    public ContentReferentielUI<E> getUi() {
        return (ContentReferentielUI)super.getUi();
    }

    @Override
    public ContentReferentielUIModel<E> getModel() {
        return ((ContentReferentielUI)this.getUi()).getModel();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        Class beanType = this.getBeanType();
        if (this.getDataSource().canWriteReferentiel()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Can write on referentiel " + beanType));
            }
            this.addInfoMessage(I18n._((String)"observe.message.referentiel.editable"));
            return ContentMode.UPDATE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can not write on referentiel " + beanType));
        }
        this.addInfoMessage(I18n._((String)"observe.message.referentiel.no.editable"));
        return ContentMode.READ;
    }

    public void showUniqueKeys(JButton button) {
        List entities;
        Class beanType = this.getBeanType();
        try {
            entities = this.getDataService().loadDecoratedEntities(this.getDataSource(), beanType);
        }
        catch (DataSourceException e) {
            ErrorDialogUI.showError((Exception)((Object)e));
            return;
        }
        ArrayList<Object[]> datas = new ArrayList<Object[]>(entities.size());
        int nbColumns = this.naturalIds.length + 1;
        String[] columns = new String[nbColumns];
        System.arraycopy(this.naturalIds, 0, columns, 1, this.naturalIds.length);
        columns[0] = Introspector.decapitalize(beanType.getSimpleName());
        DecoratorService dService = this.getDecoratorService();
        TopiaEntityBinder binder = this.getOpeningBinder();
        Decorator decorator = dService.getDecorator(beanType);
        for (ReferentielEntity e : entities) {
            Map values = binder.obtainProperties((Object)e, this.naturalIds);
            Object[] data = new Object[nbColumns];
            int index = 0;
            data[0] = decorator.toString((Object)e);
            for (String property : this.naturalIds) {
                Object value;
                Object o = values.get(property);
                if (DEFAULT_PROPERTIES[0].equals(property) && o == null) {
                    o = 0;
                }
                if ("identifiant".equals(property) && o == null) {
                    o = 0;
                }
                if ("sexe".equals(property) && o == null) {
                    o = 0;
                }
                if (o instanceof ReferentielEntity) {
                    Decorator d = dService.getDecorator(o.getClass());
                    value = d.toString(o);
                } else {
                    value = o;
                }
                data[++index] = value;
            }
            datas.add(data);
        }
        JTable table = new JTable(new UniqueKeyTableModel(columns, datas));
        table.setAutoCreateRowSorter(true);
        table.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        table.setFillsViewportHeight(true);
        JScrollPane pane = new JScrollPane();
        ((ContentReferentielUI)this.getUi()).decorateUniqueKeyTable(table, new DefaultTableCellRenderer(), pane);
        pane.setViewportView(table);
        pane.setVerticalScrollBarPolicy(20);
        String title = I18n._((String)"observe.title.unique.key", (Object[])new Object[]{I18n._((String)dService.getEntityLabel(beanType))});
        pane.setBorder(new TitledBorder(title));
        JPopupMenu popup = new JPopupMenu();
        popup.setBorder(null);
        popup.add(pane);
        popup.pack();
        Dimension dim = popup.getPreferredSize();
        int x = (int)(button.getPreferredSize().getWidth() - dim.getWidth());
        int y = button.getHeight();
        popup.show(button, x, y);
    }

    public void showUsages() {
        EntityMap usages;
        ReferentielEntity bean = this.getModel().isEditing() ? (ReferentielEntity)this.getModel().getBean() : (ReferentielEntity)((ContentReferentielUIModel)this.getModel()).getSelectedBean();
        try {
            usages = this.getDataService().findAllUsages(this.getDataSource(), (TopiaEntity)bean);
        }
        catch (DataSourceException e) {
            ErrorDialogUI.showError((Exception)((Object)e));
            log.error((Object)e);
            return;
        }
        DecoratorService dService = ObserveContext.get().getDecoratorService();
        Decorator decorator = dService.getDecorator(bean.getClass());
        String type = dService.getEntityLabel(bean.getClass());
        type = I18n._((String)type);
        String message = I18n._((String)"observe.message.show.usages", (Object[])new Object[]{type, decorator.toString((Object)bean)});
        UsagesUI usagesUI = new UsagesUI((JAXXContext)this.ui);
        usagesUI.init(message, null, null, (Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>)usages);
        UIHelper.askUser((Component)((Object)this.ui), I18n._((String)"observe.title.show.usage"), usagesUI, 1, new Object[]{I18n._((String)"observe.choice.quit")}, 0);
    }

    public void showTechnicalInformations(JButton button) {
        ReferentielEntity bean = this.getModel().isEditing() ? (ReferentielEntity)this.getBean() : (ReferentielEntity)((ContentReferentielUIModel)this.getModel()).getSelectedBean();
        JPanel content = new JPanel(new SpringLayout());
        content.add(new JLabel(I18n._((String)"observe.common.topiaId")));
        content.add(new JLabel(bean.getTopiaId()));
        content.add(new JLabel(I18n._((String)"observe.common.topiaCreateDate")));
        content.add(new JLabel(bean.getTopiaCreateDate().toString()));
        content.add(new JLabel(I18n._((String)"observe.common.topiaVersion")));
        content.add(new JLabel(bean.getTopiaVersion() + ""));
        SpringUtilities.makeCompactGrid(content, 3, 2, 5, 5, 5, 5);
        Decorator decorator = this.getDecoratorService().getDecorator(this.getBeanType());
        String title = I18n._((String)"observe.title.technical.informations", (Object[])new Object[]{"\n" + decorator.toString((Object)bean)});
        content.setBorder(new TitledBorder(title));
        JPopupMenu popup = new JPopupMenu();
        popup.setBorderPainted(true);
        popup.add(content);
        popup.pack();
        Dimension dim = popup.getPreferredSize();
        int x = (int)(button.getPreferredSize().getWidth() - dim.getWidth());
        int y = button.getHeight();
        popup.show(button, x, y);
    }

    @Override
    public void initUI() throws Exception {
        super.initUI();
        ContentUI ui = this.getUi();
        JList list = ((ContentReferentielUI)ui).getList();
        UIHelper.prepareEntityList(this.getDataSource(), this.getModel().getBeanType(), list);
        ((ContentReferentielUI)ui).getViewLayout().addPropertyChangeListener("selected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(ContentReferentielUIHandler.this.revalidate);
            }
        });
        UIHelper.getLayer((JComponent)((ContentReferentielUI)ui).getEditKeyTable()).setUI((LayerUI)((ContentReferentielUI)ui).getEditKeyTableLayerUI());
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        ContentUIModel model = this.getModel();
        ContentUI ui = this.getUi();
        if (I18nReferentielEntity.class.isAssignableFrom(model.getBeanType())) {
            ReferentielLocaleEnum localeEnum = ReferentielLocaleEnum.valueOf((Locale)ui.getConfig().getDbLocale());
            String libelleName = localeEnum.getLibelle() + "Label";
            for (int i = 1; i <= 8; ++i) {
                String lib = "libelle" + i + "Label";
                JLabel label = (JLabel)ui.getObjectById(lib);
                if (label == null) continue;
                Font font = label.getFont();
                Font normalFont = font.deriveFont(0);
                Font boldFont = font.deriveFont(1);
                font = libelleName.equals(lib) ? boldFont : normalFont;
                label.setFont(font);
                ((JComponent)ui.getObjectById("libelle" + i)).setFont(font);
            }
        }
        ContentMode mode = this.prepareContentMode();
        model.setMode(mode);
        if (mode != ContentMode.READ) {
            ui.processDataBinding("deleteFromList.enabled");
        }
    }

    @Override
    protected void updateToolbarActions() {
        super.updateToolbarActions();
        ContentUI ui = this.getUi();
        JToolBar toolBar = ui.getTitleRightToolBar();
        toolBar.add((Component)((ContentReferentielUI)ui).getShowUniqueKeys(), 0);
        toolBar.add((Component)((ContentReferentielUI)ui).getShowTechnicalInformations(), 0);
        toolBar.add((Component)((ContentReferentielUI)ui).getShowUsages(), 0);
    }

    @Override
    public void startEditUI(String ... binding) {
        boolean canEdit;
        ContentUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        ReferentielEntity bean = (ReferentielEntity)this.getBean();
        ContentMode mode = model.getMode();
        boolean bl = canEdit = mode != ContentMode.READ;
        if (canEdit) {
            ContentReferentielUIHandler.removeAllMessages(ui);
            String contextName = this.getValidatorContextName(mode);
            if (log.isDebugEnabled()) {
                log.debug((Object)("contextName = " + contextName));
            }
            ((ContentReferentielUI)ui).getValidator().setContextName(contextName);
            if (mode == ContentMode.CREATE) {
                this.addInfoMessage(I18n._((String)"observe.message.creating.referentiel"));
                try {
                    this.getDataService().preCreateEntity(this.getDataSource(), null, (TopiaEntity)bean, this.getOpeningBinder(), this.getPreCreateExecutor());
                }
                catch (DataSourceException e) {
                    ErrorDialogUI.showError((Exception)((Object)e));
                }
            } else {
                this.addInfoMessage(I18n._((String)"observe.message.updating.referentiel"));
            }
            super.startEditUI(this.dataBinding);
        } else {
            BeanValidatorUtil.setValidatorBean((JAXXObject)ui, null, (String[])new String[0]);
            UIHelper.processDataBinding((JAXXObject)ui, (String[])this.dataBinding);
            model.setEditing(true);
            ObserveServiceHelper.get().getValidationContext().cleanCache();
        }
    }

    @Override
    protected void prepareValidationContext() {
        super.prepareValidationContext();
        JList jList = ((ContentReferentielUI)this.getUi()).getList();
        List data = (List)jList.getClientProperty("data");
        ObserveServiceHelper.get().getValidationContext().setEditingReferentielList(data);
    }

    @Override
    public boolean closeUI() throws Exception {
        return super.closeUI();
    }

    public final void createUI() {
        this.ui.getModel().setMode(ContentMode.CREATE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will create new entity [" + this.getModel().getBeanType() + "]"));
        }
        this.getOpeningBinder().load(null, this.getBean(), true, new String[0]);
        this.ui.startEdit(null);
    }

    public void modifyUI() {
        ContentUIModel model = this.getModel();
        if (model.getMode() != ContentMode.READ) {
            model.setMode(ContentMode.UPDATE);
        }
        this.getOpeningBinder().load(((ContentReferentielUIModel)model).getSelectedBean(), this.getBean(), true, new String[0]);
        this.ui.startEdit(null);
    }

    @Override
    public void stopEditUI() {
        super.stopEditUI();
        ContentUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        if (model.getMode() != ContentMode.READ) {
            model.setMode(ContentMode.UPDATE);
            ContentReferentielUIHandler.removeAllMessages(ui);
            this.addInfoMessage(I18n._((String)"observe.message.referentiel.editable"));
        }
    }

    @Override
    public final void resetEditUI() {
        ContentMode mode = this.getModel().getMode();
        super.resetEditUI();
        if (mode == ContentMode.CREATE) {
            this.createUI();
        } else {
            this.modifyUI();
        }
    }

    @Override
    protected boolean doSave(E bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<E> binder) throws Exception {
        ContentUIModel model = this.getModel();
        if (bean.getTopiaId() == null) {
            log.info((Object)("Create referentiel " + bean));
            dataService.create(dataSource, null, bean, binder, this.getCreateExecutor());
            return true;
        }
        log.info((Object)("Will update exisintg entity : " + bean.getTopiaId()));
        ReferentielEntity oldBean = (ReferentielEntity)((ContentReferentielUIModel)model).getSelectedBean();
        if (oldBean != null && oldBean.getStatus() == ReferentielStatusEnum.enabled.ordinal() && bean.getStatus() == ReferentielStatusEnum.disabled.ordinal()) {
            EntityMap usages;
            if (log.isDebugEnabled()) {
                log.debug((Object)"entity status was desactivated, looking for usage");
            }
            if ((usages = dataService.findAllUsages(dataSource, bean)).isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No usage found, no warning to display");
                }
            } else {
                boolean willsave = ContentReferentielUIHandler.showUsagesForDesactivated((JAXXContext)this.ui, bean, (Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>)usages);
                if (!willsave) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"User refuses to continue, skip saving...");
                    }
                    return false;
                }
            }
        }
        dataService.update(dataSource, bean, binder, new String[0]);
        return true;
    }

    @Override
    protected boolean doDelete(E bean, DataService dataService, DataSource dataSource, Deletor<Object, E> deletor) throws Exception {
        EntityMap usages;
        ContentUIModel model = this.getModel();
        if (log.isInfoEnabled()) {
            log.info((Object)"entity to be deleted, looking for usage");
        }
        if ((usages = dataService.findAllUsages(this.getDataSource(), bean)).isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No usage found, no warning to display");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"can not delete referentiel entity (found usages)");
            }
            ContentReferentielUIHandler.showUsagesForDelete((JAXXContext)this.ui, bean, (Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>)usages);
            return false;
        }
        if (!UIHelper.confirmForEntityDelete(this.ui, model.getBeanType(), bean)) {
            return false;
        }
        dataService.delete(dataSource, bean.getTopiaId());
        return true;
    }

    @Override
    protected void afterSave(boolean refresh) {
        this.ui.stopEdit();
    }

    @Override
    protected void afterDelete() {
        this.ui.stopEdit();
    }

    @Override
    protected E onPreCreate(TopiaContext tx, Object parent, E bean) throws TopiaException {
        bean.setTopiaId(null);
        bean.setTopiaCreateDate(null);
        bean.setTopiaVersion(0L);
        bean.setStatus(1);
        return bean;
    }

    @Override
    protected final E onCreate(TopiaContext tx, Object parent, E bean) throws TopiaException {
        Map properties = this.getOpeningBinder().obtainProperties(bean, this.naturalIds);
        TopiaDAO dao = ((TopiaContextImplementor)tx).getDAO(this.getModel().getBeanType());
        ReferentielEntity beanToSave = (ReferentielEntity)dao.create(properties);
        bean.setTopiaId(beanToSave.getTopiaId());
        return (E)beanToSave;
    }

    @Override
    protected TopiaEntityBinder<E> createOpeningBinder(BinderService binderService) {
        String binderName;
        Class mainEntityClass = this.getBeanType();
        TopiaEntityBinder r = binderService.getTopiaBinder(mainEntityClass, binderName = this.getClass().getName() + "-open");
        if (r == null) {
            BinderBuilder builder = new BinderBuilder(mainEntityClass, this.properties);
            r = binderService.registerTopiaBinder(mainEntityClass, builder, binderName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("new binder [" + this.getClass().getName() + "#" + mainEntityClass.getName() + "] : " + Arrays.toString(this.properties)));
            }
        }
        return r;
    }

    protected final List<String> buildProperties(boolean usedefault, String[] properties) {
        ArrayList<String> listProperties = new ArrayList<String>();
        listProperties.addAll(Arrays.asList(DEFAULT_PROPERTIES));
        listProperties.addAll(Arrays.asList(properties));
        Class mainEntityClass = this.getBeanType();
        if (I18nReferentielEntity.class.isAssignableFrom(mainEntityClass)) {
            listProperties.addAll(Arrays.asList(DEFAULT_I18N_PROPERTIES));
        }
        if (NeedCommentReferentielEntity.class.isAssignableFrom(mainEntityClass)) {
            listProperties.addAll(Arrays.asList(DEFAULT_NEED_COMMENT_PROPERTIES));
        }
        if (!usedefault) {
            listProperties.remove(DEFAULT_PROPERTIES[0]);
        }
        return listProperties;
    }

    protected final List<String> buildDataBindings(boolean usedefault, String[] dataBinding) {
        ArrayList<String> bindings = new ArrayList<String>();
        bindings.addAll(Arrays.asList(DEFAULT_DATABINDING));
        bindings.addAll(Arrays.asList(dataBinding));
        Class mainEntityClass = this.getBeanType();
        if (I18nReferentielEntity.class.isAssignableFrom(mainEntityClass)) {
            bindings.addAll(Arrays.asList(DEFAULT_I18N_DATABINDING));
        }
        if (NeedCommentReferentielEntity.class.isAssignableFrom(mainEntityClass)) {
            bindings.addAll(Arrays.asList(DEFAULT_NEED_COMMENT_DATABINDING));
        }
        if (!usedefault) {
            bindings.remove(DEFAULT_DATABINDING[0]);
        }
        return bindings;
    }

    public static <E extends TopiaEntity> void showUsagesForDelete(JAXXContext tx, E entity, Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> usages) {
        DecoratorService service = ObserveContext.get().getDecoratorService();
        Decorator decorator = service.getDecorator(entity.getClass());
        String type = service.getEntityLabel(entity.getClass());
        type = I18n._((String)type);
        String message = I18n._((String)"observe.message.show.usage.for.delete", (Object[])new Object[]{type, decorator.toString(entity)});
        String message2 = I18n._((String)"observe.message.show.usage.for.delete2");
        UsagesUI usagesUI = new UsagesUI(tx);
        usagesUI.init(message, message2, null, usages);
        UIHelper.askUser(null, I18n._((String)"observe.title.can.not.delete.referentiel"), usagesUI, 2, new Object[]{I18n._((String)"observe.choice.cancel")}, 0);
    }

    public static <E extends TopiaEntity> boolean showUsagesForDesactivated(JAXXContext tx, E entity, Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> usages) {
        DecoratorService service = ObserveContext.get().getDecoratorService();
        Decorator decorator = service.getDecorator(entity.getClass());
        String type = service.getEntityLabel(entity.getClass());
        type = I18n._((String)type);
        String message = I18n._((String)"observe.message.show.usage.for.desactivated", (Object[])new Object[]{type, decorator.toString(entity)});
        String message2 = I18n._((String)"observe.message.show.usage.for.desactivated2");
        String message3 = I18n._((String)"observe.message.show.usage.for.desactivated3");
        UsagesUI usagesUI = new UsagesUI(tx);
        usagesUI.init(message, message2, message3, usages);
        int reponse = UIHelper.askUser(null, I18n._((String)"observe.title.need.confirm.to.desactivate.referentiel"), usagesUI, 2, new Object[]{I18n._((String)"observe.choice.save"), I18n._((String)"observe.choice.cancel")}, 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("response : " + reponse));
        }
        switch (reponse) {
            case 0: {
                return true;
            }
        }
        return false;
    }
}

