/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.Route;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.list.ContentListUIModel;
import fr.ird.observe.ui.content.list.impl.ActivitesUI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderBuilder;

public class ActivitesUIHandler
extends ContentUIHandler<Route> {
    private static Log log = LogFactory.getLog(ActivitesUIHandler.class);

    public ActivitesUIHandler(ActivitesUI ui) {
        super(ui);
    }

    public ContentListUIModel<Route, Activite> getModel() {
        return (ContentListUIModel)super.getModel();
    }

    @Override
    protected TopiaEntityBinder<Route> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Route.class, binderName);
        if (r == null) {
            BinderBuilder builder = new BinderBuilder(Route.class, new String[]{"open", "activite"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"activite"});
            BinderBuilder builder2 = new BinderBuilder(Activite.class, new String[]{"activiteBateau", "heureObservation", "open"});
            TopiaEntityBinder binder = binderService.registerTopiaBinder(Activite.class, builder2, binderName);
            builder.addBinder("activite", (Binder)binder);
            r = binderService.registerTopiaBinder(Route.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        boolean currentRouteOpen = dataContext.isSelectedOpen(Route.class);
        if (dataContext.isOpenActivite()) {
            if (currentRouteOpen) {
                this.addInfoMessage(I18n.n_((String)"observe.message.active.activite.found"));
                return ContentMode.UPDATE;
            }
            this.addInfoMessage(I18n.n_((String)"observe.message.active.activite.found.for.other.route"));
            return ContentMode.READ;
        }
        if (currentRouteOpen) {
            this.addInfoMessage(I18n.n_((String)"observe.message.no.active.activite.found"));
            return ContentMode.CREATE;
        }
        this.addInfoMessage(I18n.n_((String)"observe.message.route.not.open"));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        DataContext openableContext = this.getDataContext();
        String routeId = openableContext.getSelectedRouteId();
        log.info((Object)("routeId = " + routeId));
        ContentMode mode = this.prepareContentMode();
        if (log.isInfoEnabled()) {
            log.info((Object)("[" + ((Object)((Object)this.ui)).getClass().getSimpleName() + "] content mode " + (Object)((Object)mode)));
        }
        Route bean = (Route)this.getBean();
        this.getDataService().loadEditEntity(this.getDataSource(), routeId, this.getOpeningExecutor());
        ContentUIModel model = this.getModel();
        List data = bean.getActivite();
        ((ContentListUIModel)model).setData(data);
        model.setMode(mode);
    }

    @Override
    public boolean doCloseData() throws Exception {
        Route bean = (Route)this.getBean();
        Activite activite = bean.getOpenActivite();
        boolean result = this.doCloseData(activite.getTopiaId());
        return result;
    }

    @Override
    public void afterCloseData() {
        super.afterCloseData();
        Route bean = (Route)this.getBean();
        Activite activite = bean.getOpenActivite();
        this.closeOpenable((Openable)activite, I18n._((String)"observe.message.no.active.activite.found"));
        this.getModel().setMode(ContentMode.CREATE);
    }
}

