/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.referentiel.ActiviteBateau;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.ActiviteUI;
import fr.ird.observe.ui.content.impl.RouteUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.Deletor;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderBuilder;

public class RouteUIHandler
extends ContentUIHandler<Route> {
    private static Log log = LogFactory.getLog(RouteUIHandler.class);
    private static final String POSITION_ROUTE = "positionRoute";

    public RouteUIHandler(RouteUI ui) {
        super(ui);
    }

    public RouteUI getUi() {
        return (RouteUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<Route> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Route.class, binderName);
        if (r == null) {
            BinderBuilder builder = new BinderBuilder(Route.class, new String[]{"jourObservation", "lochMatin", "lochSoir", "niveauVerification", "activite", "open", "commentaire"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"activite"});
            BinderBuilder builder2 = new BinderBuilder(Activite.class, new String[]{"quadrant", "latitude", "longitude", "heureObservation", "temperatureSurface", "causeNonCoupSenne", "activiteBateau", "ventBeaufort", "open"});
            TopiaEntityBinder binder = binderService.registerTopiaBinder(Activite.class, builder2, binderName);
            builder.addBinder("activite", (Binder)binder);
            r = binderService.registerTopiaBinder(Route.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String routeId = dataContext.getSelectedRouteId();
        if (routeId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Route.class)) {
            return ContentMode.UPDATE;
        }
        if (!dataContext.isSelectedOpen(Maree.class)) {
            RouteUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(Maree.class), I18n._((String)"observe.message.maree.not.open"));
        } else {
            RouteUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.route.not.open"));
        }
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        boolean canReopen;
        boolean create;
        super.openUI();
        DataContext dataContext = this.getDataContext();
        String mareeId = dataContext.getSelectedMareeId();
        String routeId = dataContext.getSelectedRouteId();
        log.info((Object)("mareeId = " + mareeId));
        log.info((Object)("routeId = " + routeId));
        ContentMode mode = this.prepareContentMode();
        DataService dataService = this.getDataService();
        Route editBean = (Route)this.getBean();
        boolean bl = create = routeId == null;
        if (create) {
            dataService.preCreateEntity(this.getDataSource(), mareeId, (TopiaEntity)editBean, this.getOpeningBinder(), this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(this.getDataSource(), routeId, this.getOpeningExecutor());
            if (!editBean.isActiviteEmpty()) {
                DBHelper.sortActivites((List)editBean.getActivite());
            }
        }
        this.getModel().setMode(mode);
        boolean bl2 = canReopen = !create && !dataContext.isOpenRoute() && mareeId.equals(dataContext.getOpenMareeId());
        if (log.isInfoEnabled()) {
            log.info((Object)("can reopen ? = " + canReopen));
        }
        this.getUi().setCanReopen(canReopen);
        if (mode != ContentMode.READ) {
            this.ui.startEdit(null);
        }
    }

    @Override
    protected Route onPreCreate(TopiaContext tx, Object parent, Route bean) throws TopiaException {
        Maree parentBean = (Maree)parent;
        Route lastRoute = parentBean.getLastRoute();
        if (lastRoute == null) {
            bean.setJourObservation(parentBean.getDateDebut());
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(lastRoute.getJourObservation());
            calendar.add(6, 1);
            Date date = DBHelper.getDay((Date)calendar.getTime());
            bean.setJourObservation(date);
            bean.setLochMatin(lastRoute.getLochSoir());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use jourObservation : " + bean.getJourObservation()));
            log.info((Object)("Will loch matin ast last loch soir : " + bean.getLochMatin()));
        }
        return bean;
    }

    @Override
    protected Route onCreate(TopiaContext tx, Object parent, Route bean) throws TopiaException {
        Maree parentBean = (Maree)parent;
        Route beanToSave = (Route)ObserveDAOHelper.getRouteDAO((TopiaContext)tx).create(new Object[0]);
        bean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addRoute(beanToSave);
        return beanToSave;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, Route bean) {
        Maree parentBean = (Maree)parent;
        parentBean.removeRoute(bean);
    }

    @Override
    public void afterOpenData() {
        super.afterOpenData();
        this.getUi().setCanReopen(false);
        this.restartEditUI();
    }

    @Override
    public boolean doCloseData() throws Exception {
        Route route = (Route)this.getBean();
        boolean mustAddFinVeille = !route.isActiviteFindDeVeilleFound();
        DataContext dataContext = this.getDataContext();
        if (mustAddFinVeille) {
            int reponse = UIHelper.askUser((Component)((Object)this.ui), I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.need.fin.veille.activite"), 2, new Object[]{I18n._((String)"observe.choice.create.fin.veille.activite"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 1: {
                    break;
                }
                case 0: {
                    if (dataContext.isOpenActivite()) {
                        this.doCloseData(dataContext.getOpenActiviteId());
                    }
                    this.stopEditUI();
                    ObserveTreeHelper treeHelper = RouteUIHandler.getTreeHelper((JAXXContext)this.ui);
                    ObserveNode parentNode = (ObserveNode)treeHelper.getSelectedNode();
                    parentNode = (ObserveNode)treeHelper.findNode((NavNode)parentNode, new String[]{I18n.n_((String)"observe.common.activites")});
                    log.info((Object)("PARENT NODE = " + (Object)((Object)parentNode)));
                    ObserveNode node = treeHelper.addUnsavedNode(parentNode, Activite.class);
                    ActiviteUI selectedUI = (ActiviteUI)((Object)ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.getContextValue((JAXXContext)this.ui));
                    ActiviteBateau activiteBateau = null;
                    for (ActiviteBateau o : selectedUI.getActiviteBateau().getData()) {
                        ActiviteBateau a = o;
                        if (a.getCode() != 16) continue;
                        activiteBateau = a;
                        break;
                    }
                    selectedUI.getBean().setActiviteBateau(activiteBateau);
                }
            }
            return false;
        }
        if (dataContext.isOpenActivite()) {
            this.doCloseData(dataContext.getOpenActiviteId());
        }
        super.doCloseData();
        return true;
    }

    @Override
    public void afterCloseData() {
        super.afterCloseData();
        this.getUi().setCanReopen(true);
        this.closeOpenable((Openable)this.getBean(), I18n._((String)"observe.message.route.not.open"));
    }

    @Override
    public void startEditUI(String ... binding) {
        boolean create = this.getModel().getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(this.getModel().getMode());
        this.getUi().getValidator().setContextName(contextName);
        if (create) {
            RouteUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.creating.route"));
        } else {
            RouteUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.updating.route"));
        }
        super.startEditUI("jourObservation.date", "lochMatin.model", "lochSoir.model", "commentaire2.text", "close.enabled");
        this.getModel().setModified(create);
    }

    @Override
    protected boolean doSave(Route bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Route> binder) throws Exception {
        String mareeId = this.getDataContext().getSelectedMareeId();
        log.info((Object)("will save route " + bean.getTopiaId()));
        Date date = DBHelper.getDay((Date)bean.getJourObservation());
        bean.setJourObservation(date);
        if (bean.getTopiaId() == null) {
            bean.setOpen(true);
            dataService.create(dataSource, mareeId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, (TopiaEntity)bean, binder, new String[]{"activite"});
        }
        dataService.updateMareeDateFin(dataSource, mareeId);
        int position = dataService.getRoutePosition(dataSource, mareeId, bean.getTopiaId());
        log.info((Object)("Position of route : " + position));
        this.ui.setContextValue(position, POSITION_ROUTE);
        return true;
    }

    @Override
    protected boolean doDelete(Route bean, DataService dataService, DataSource dataSource, Deletor<Object, Route> deletor) throws Exception {
        if (!UIHelper.confirmForEntityDelete(this.ui, Route.class, bean)) {
            return false;
        }
        String mareeId = this.ui.getDataContext().getSelectedMareeId();
        dataService.delete(dataSource, mareeId, (TopiaEntity)bean, this.getDeletator());
        dataService.updateMareeDateFin(dataSource, mareeId);
        return true;
    }

    @Override
    protected void afterSave(boolean refresh) {
        int position = this.ui.getContextValue(Integer.class, POSITION_ROUTE);
        BeanValidatorUtil.setValidatorChanged((JAXXObject)this.ui, (boolean)false, (String[])new String[0]);
        Route bean = (Route)this.getBean();
        ObserveTreeHelper treeHelper = RouteUIHandler.getTreeHelper((JAXXContext)this.ui);
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        ObserveNode parentNode = (ObserveNode)node.getParent();
        boolean create = node.getId() == null;
        int oldPosition = create ? parentNode.getChildCount() : parentNode.getIndex((TreeNode)((Object)node));
        if (create) {
            this.getModel().setMode(ContentMode.UPDATE);
            treeHelper.removeNode((NavNode)node);
            node = treeHelper.addRoute(parentNode, bean);
            this.stopEditUI();
            if (oldPosition != position) {
                treeHelper.moveNode((NavNode)parentNode, (NavNode)node, position);
            }
            treeHelper.selectNode((NavNode)node);
        } else {
            if (oldPosition != position) {
                treeHelper.moveNode((NavNode)parentNode, (NavNode)node, position);
                treeHelper.selectNode((NavNode)node);
            }
            treeHelper.refreshNode((NavNode)node, false);
        }
    }

    @Override
    protected void afterDelete() {
        this.ui.stopEdit();
        ObserveTreeHelper treeHelper = RouteUIHandler.getTreeHelper((JAXXContext)this.ui);
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        ObserveNode parentNode = (ObserveNode)treeHelper.removeNode((NavNode)node);
        treeHelper.selectNode((NavNode)parentNode);
    }
}

