/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.referentiel.ActiviteBateau;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.impl.ActiviteUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.util.Date;
import java.util.List;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.Deletor;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderBuilder;

public class ActiviteUIHandler
extends ContentUIHandler<Activite> {
    private static Log log = LogFactory.getLog(ActiviteUIHandler.class);
    public static final String POSITION_ACTIVITE = "POSITION_ACTIVITE";

    public ActiviteUIHandler(ActiviteUI ui) {
        super(ui);
    }

    public ActiviteUI getUi() {
        return (ActiviteUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<Activite> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Activite.class, binderName);
        if (r == null) {
            BinderBuilder builder = new BinderBuilder(Activite.class, new String[]{"quadrant", "latitude", "longitude", "heureObservation", "temperatureSurface", "causeNonCoupSenne", "commentaire", "vitesseBateau", "systemeObserve", "distanceSystemeObserve", "activiteBateau", "activiteEnvironnante", "ventBeaufort", "modeDetection", "calee", "objetFlottant", "open", "latitudeAsDegre", "latitudeAsMinute", "latitudeAsSeconde", "longitudeAsDegre", "longitudeAsMinute", "longitudeAsSeconde", "useSexagecimalFormat"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"systemeObserve"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"objetFlottant"});
            r = binderService.registerTopiaBinder(Activite.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String activiteId = dataContext.getSelectedActiviteId();
        if (activiteId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Activite.class)) {
            return ContentMode.UPDATE;
        }
        if (!dataContext.isSelectedOpen(Route.class)) {
            ActiviteUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.route.not.open"));
        } else if (!dataContext.isSelectedOpen(Maree.class)) {
            ActiviteUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(Maree.class), I18n._((String)"observe.message.maree.not.open"));
        } else {
            this.addInfoMessage(I18n._((String)"observe.message.activite.not.open"));
        }
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        boolean canReopen;
        super.openUI();
        DataContext dataContext = this.getDataContext();
        String routeId = dataContext.getSelectedRouteId();
        String activiteId = dataContext.getSelectedActiviteId();
        log.info((Object)("routeId    = " + routeId));
        log.info((Object)("activiteId = " + activiteId));
        ContentMode mode = this.prepareContentMode();
        if (log.isInfoEnabled()) {
            log.info((Object)("[" + ((Object)((Object)this.ui)).getClass().getSimpleName() + "] content mode " + (Object)((Object)mode)));
        }
        Activite bean = (Activite)this.getBean();
        bean.setUseSexagecimalFormat(false);
        DataService dataService = this.getDataService();
        boolean create = activiteId == null;
        TopiaEntityBinder binder = this.getOpeningBinder();
        DataSource source = this.getDataSource();
        if (create) {
            dataService.preCreateEntity(source, routeId, (TopiaEntity)bean, binder, this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(source, activiteId, this.getOpeningExecutor());
        }
        this.getModel().setMode(mode);
        if (mode != ContentMode.READ) {
            this.ui.startEdit(null);
        }
        bean.setUseSexagecimalFormat(true);
        this.getModel().setModified(create);
        boolean bl = canReopen = !create && dataContext.isSelectedOpen(Route.class) && !dataContext.isOpenActivite();
        if (log.isDebugEnabled()) {
            log.debug((Object)("can reopen ? = " + canReopen));
        }
        this.getUi().setCanReopen(canReopen);
    }

    @Override
    public void startEditUI(String ... binding) {
        ActiviteUI ui = this.getUi();
        ui.getQuadrantBG().clearSelection();
        ContentUIModel model = this.getModel();
        boolean create = model.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(model.getMode());
        ui.getValidator().setContextName(contextName);
        if (create) {
            ActiviteUIHandler.addMessage(ui, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.creating.activite"));
        } else {
            ActiviteUIHandler.addMessage(ui, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.updating.activite"));
        }
        super.startEditUI("heureObservation.date", "longitudeDecimal.model", "longitudeAsDegre.model", "longitudeAsMinute.model", "latitudeDecimal.model", "latitudeAsMinute.model", "latitudeAsDegre.model", "quadrant1.selected", "quadrant2.selected", "quadrant3.selected", "quadrant4.selected", "vitesseBateau.model", "temperatureSurface.model", "commentaire2.text", "activiteBateau.selectedItem", "activiteEnvironnante.selectedItem", "ventBeaufort.selectedItem");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(Activite bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Activite> binder) throws Exception {
        boolean sexagecimalFormat = bean.isUseSexagecimalFormat();
        if (sexagecimalFormat) {
            bean.setUseSexagecimalFormat(false);
        }
        boolean create = bean.getTopiaId() == null;
        String routeId = this.getDataContext().getSelectedRouteId();
        if (create) {
            bean.setOpen(true);
            bean = (Activite)dataService.create(dataSource, routeId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, (TopiaEntity)bean, this.getUpdator());
        }
        if (sexagecimalFormat) {
            bean.setUseSexagecimalFormat(true);
        }
        int position = dataService.getActivitePosition(dataSource, routeId, bean.getTopiaId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Position of activite : " + position));
        }
        this.ui.setContextValue(position, POSITION_ACTIVITE);
        return true;
    }

    @Override
    protected boolean doDelete(Activite bean, DataService dataService, DataSource dataSource, Deletor<Object, Activite> deletor) throws Exception {
        if (!UIHelper.confirmForEntityDelete(this.ui, Activite.class, bean)) {
            return false;
        }
        String routeId = this.getDataContext().getSelectedRouteId();
        dataService.delete(dataSource, routeId, (TopiaEntity)bean, deletor);
        return true;
    }

    @Override
    protected Activite onPreCreate(TopiaContext tx, Object parent, Activite bean) throws TopiaException {
        Route parentBean = (Route)parent;
        Date d = DBHelper.getCurrentHour((Date)parentBean.getJourObservation());
        bean.setHeureObservation(d);
        bean.setOpen(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("has pre-created :  " + bean));
        }
        return bean;
    }

    @Override
    protected Activite onCreate(TopiaContext tx, Object parent, Activite bean) throws TopiaException {
        Route parentBean = (Route)parent;
        Activite beanToSave = (Activite)ObserveDAOHelper.getActiviteDAO((TopiaContext)tx).create(new Object[0]);
        bean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addActivite(beanToSave);
        return beanToSave;
    }

    @Override
    protected Activite onUpdate(TopiaContext tx, Activite bean) throws TopiaException {
        Activite editBean = (Activite)this.getBean();
        String selectedRouteId = this.getDataContext().getSelectedRouteId();
        Route route = (Route)tx.findByTopiaId(selectedRouteId);
        Date d = DBHelper.getDateAndTime((Date)route.getJourObservation(), (Date)editBean.getHeureObservation());
        editBean.setHeureObservation(d);
        editBean.setOpen(true);
        log.info((Object)("Final time to use : " + d));
        TopiaEntityBinder binder = this.getOpeningBinder();
        binder.copyExcluding((Object)editBean, (Object)bean, new String[]{"objetFlottant", "systemeObserve"});
        log.info((Object)("Is activite open ? : " + bean.isOpen()));
        return bean;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, Activite bean) {
        Route parentBean = (Route)parent;
        parentBean.removeActivite(bean);
    }

    @Override
    public void afterCloseData() {
        super.afterCloseData();
        this.getUi().setCanReopen(true);
        this.closeOpenable((Openable)this.getBean(), I18n._((String)"observe.message.activite.not.open"));
    }

    @Override
    public void afterOpenData() {
        super.afterOpenData();
        this.getUi().setCanReopen(false);
        this.restartEditUI();
    }

    public String getActivite6Label() {
        try {
            List activites = this.getDataService().getList(this.getDataSource(), ActiviteBateau.class);
            for (ActiviteBateau a : activites) {
                if (a.getCode() != 6) continue;
                Decorator d = this.getDecoratorService().getDecorator(ActiviteBateau.class);
                String label = d.toString((Object)a);
                return label;
            }
        }
        catch (DataSourceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        throw new IllegalStateException(I18n._((String)"observe.error.no.activite.6"));
    }

    @Override
    protected void afterSave(boolean refresh) {
        Activite bean = (Activite)this.getBean();
        BeanValidatorUtil.setValidatorChanged((JAXXObject)this.ui, (boolean)false, (String[])new String[0]);
        ObserveTreeHelper treeHelper = ActiviteUIHandler.getTreeHelper((JAXXContext)this.ui);
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        boolean create = node.getId() == null;
        ObserveNode parentNode = (ObserveNode)node.getParent();
        int oldPosition = create ? parentNode.getChildCount() : parentNode.getIndex((TreeNode)((Object)node));
        Integer position = this.ui.getContextValue(Integer.class, POSITION_ACTIVITE);
        if (create) {
            this.getModel().setMode(ContentMode.UPDATE);
            treeHelper.removeNode((NavNode)node);
            node = treeHelper.addActivite(parentNode, bean);
            this.stopEditUI();
            if (oldPosition != position) {
                treeHelper.moveNode((NavNode)parentNode, (NavNode)node, position);
            }
            treeHelper.selectNode((NavNode)node);
        } else {
            if (oldPosition != position) {
                treeHelper.moveNode((NavNode)parentNode, (NavNode)node, position);
                treeHelper.selectNode((NavNode)node);
            }
            treeHelper.refreshNode((NavNode)node, false);
        }
    }

    @Override
    protected void afterDelete() {
        this.ui.stopEdit();
        ObserveTreeHelper treeHelper = ActiviteUIHandler.getTreeHelper((JAXXContext)this.ui);
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        ObserveNode parentNode = (ObserveNode)treeHelper.removeNode((NavNode)node);
        treeHelper.selectNode((NavNode)parentNode);
    }
}

