/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.validate;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.ui.admin.AdminActionModel;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.validation.ValidationModelMode;
import fr.ird.observe.validation.ValidationService;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import jaxx.runtime.validator.BeanValidatorMessage;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.ValidatorsMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.persistence.util.TopiaEntityRef;

public class ValidateModel
extends AdminActionModel {
    private static final Log log = LogFactory.getLog(ValidateModel.class);
    public static final String PROPERTY_ALL_CONTEXT_NAMES = "allContextNames";
    public static final String PROPERTY_CONTEXT_NAME = "contextName";
    public static final String PROPERTY_SCOPES = "scopes";
    public static final String PROPERTY_MODEL_MODE = "modelMode";
    public static final String PROPERTY_GENERATE_REPORT = "generateReport";
    public static final String PROPERTY_REPORT_FILE = "reportFile";
    public static final String PROPERTY_MESSAGES = "messages";
    protected String[] allContextNames;
    protected String contextName;
    protected ValidationModelMode modelMode;
    protected final EnumSet<BeanValidatorScope> scopes;
    protected DataSelectionModel selectValidateDataModel;
    protected boolean generateReport;
    protected File reportFile = new File("");
    protected ValidatorsMap validators;
    protected SortedMap<TopiaEntityRef, List<BeanValidatorMessage<?>>> messages;
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    public ValidateModel() {
        super(AdminStep.VALIDATE);
        this.scopes = EnumSet.noneOf(BeanValidatorScope.class);
        this.messages = new TreeMap();
        this.selectValidateDataModel = new DataSelectionModel();
    }

    public String getDefaultReportFilename() {
        return String.format("report-%1$tF--%1$tk-%1$tM-%1$tS.sql.gz", new Date());
    }

    public String getContextName() {
        return this.contextName;
    }

    public Class<?>[] getBeanTypes() {
        return this.modelMode == null ? EMPTY_CLASS_ARRAY : this.modelMode.getContracts();
    }

    public ValidationModelMode getModelMode() {
        return this.modelMode;
    }

    public EnumSet<BeanValidatorScope> getScopes() {
        return this.scopes;
    }

    public String[] getAllContextNames() {
        return this.allContextNames;
    }

    public boolean isGenerateReport() {
        return this.generateReport;
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public DataSelectionModel getSelectValidateDataModel() {
        return this.selectValidateDataModel;
    }

    public ValidatorsMap getValidators() {
        if (this.validators == null) {
            ValidationService service = new ValidationService();
            this.validators = this.populateValidators(service);
        }
        return this.validators;
    }

    public SortedMap<TopiaEntityRef, List<BeanValidatorMessage<?>>> getMessages() {
        return this.messages;
    }

    public Class<?>[] getMessageTypes() {
        if (this.messages == null || this.messages.isEmpty()) {
            return EMPTY_CLASS_ARRAY;
        }
        HashSet tmp = new HashSet();
        for (TopiaEntityRef ref : this.messages.keySet()) {
            tmp.add(ref.getRef().getClass());
        }
        Set result = TopiaEntityHelper.getContractClasses((TopiaEntityEnum[])ObserveDAOHelper.ObserveEntityEnum.values(), tmp);
        tmp.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)(" = " + result));
        }
        return result.toArray(new Class[result.size()]);
    }

    public List<TopiaEntityRef> getMessagesEntities(Class<?> klass) {
        ArrayList<TopiaEntityRef> tmp = new ArrayList<TopiaEntityRef>();
        if (this.messages != null) {
            for (TopiaEntityRef ref : this.messages.keySet()) {
                if (!klass.isAssignableFrom(ref.getRef().getClass())) continue;
                tmp.add(ref);
            }
        }
        return tmp;
    }

    public List<BeanValidatorMessage<?>> getMessages(TopiaEntityRef ref) {
        List result = null;
        if (this.messages != null) {
            result = (List)this.messages.get(ref);
        }
        return result;
    }

    public void setContextName(String contextName) {
        String oldvalue = this.contextName;
        this.contextName = contextName;
        this.validators = null;
        this.firePropertyChange(PROPERTY_CONTEXT_NAME, oldvalue, contextName);
    }

    public void setModelMode(ValidationModelMode modelMode) {
        ValidationModelMode oldvalue = this.modelMode;
        this.modelMode = modelMode;
        this.validators = null;
        this.firePropertyChange(PROPERTY_MODEL_MODE, oldvalue, modelMode);
    }

    public void setAllContextNames(String[] allContextNames) {
        this.allContextNames = allContextNames;
        this.firePropertyChange(PROPERTY_ALL_CONTEXT_NAMES, null, allContextNames);
        this.setContextName(null);
    }

    public void setReportFile(File reportFile) {
        File oldValue = this.reportFile;
        this.reportFile = reportFile;
        this.firePropertyChange(PROPERTY_REPORT_FILE, oldValue, reportFile);
    }

    public void setGenerateReport(boolean generateReport) {
        Boolean oldValue = this.generateReport;
        this.generateReport = generateReport;
        this.firePropertyChange(PROPERTY_GENERATE_REPORT, oldValue, generateReport);
    }

    public void setMessages(SortedMap<TopiaEntityRef, List<BeanValidatorMessage<?>>> messages) {
        SortedMap<TopiaEntityRef, List<BeanValidatorMessage<?>>> oldValue = this.messages;
        this.messages = messages;
        this.firePropertyChange(PROPERTY_MESSAGES, oldValue, messages);
    }

    public void addScope(BeanValidatorScope scope) {
        this.scopes.add(scope);
        this.validators = null;
        this.firePropertyChange(PROPERTY_SCOPES, null, this.scopes);
    }

    public void removeScope(BeanValidatorScope scope) {
        this.scopes.remove(scope);
        this.validators = null;
        this.firePropertyChange(PROPERTY_SCOPES, null, this.scopes);
    }

    protected ValidatorsMap populateValidators(ValidationService service) {
        Class[] beanclass = this.getBeanTypes();
        BeanValidatorScope[] filterScopes = this.scopes.toArray(new BeanValidatorScope[this.scopes.size()]);
        if (this.scopes.isEmpty()) {
            return new ValidatorsMap();
        }
        ValidatorsMap validators = service.getValidators(this.contextName, filterScopes, beanclass);
        return validators;
    }

    public void destroy() {
        super.destroy();
        this.selectValidateDataModel.destroy();
        if (this.messages != null) {
            this.setMessages(null);
        }
        if (this.validators != null) {
            this.validators.clear();
            this.validators = null;
        }
    }
}

