/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report;

import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.config.ConfigUI;
import fr.ird.observe.ui.admin.report.ReportBuilder;
import fr.ird.observe.ui.admin.report.ReportConfigUI;
import fr.ird.observe.ui.admin.report.ReportModel;
import fr.ird.observe.ui.admin.report.ReportUI;
import fr.ird.observe.ui.admin.report.ResultTableModel;
import fr.ird.observe.ui.admin.report.SelectReportDataUI;
import fr.ird.observe.ui.admin.report.model.DataMatrix;
import fr.ird.observe.ui.admin.report.model.Report;
import fr.ird.observe.ui.admin.report.model.ReportOperation;
import fr.ird.observe.ui.admin.report.model.operations.ExecuteRequests;
import fr.ird.observe.ui.tree.DataSelectionTreeCellRenderer;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.wizard.WizardStep;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ReportUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(ReportUIHandler.class);

    public ReportUIHandler(AdminTabUI ui) {
        super(ui);
    }

    public void initTabUI(AdminUI ui, final ReportUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        UIHelper.getLayer((JComponent)tabUI.getContent()).setUI((LayerUI)ui.getConfigBlockLayerUI());
        tabUI.getStepModel().addPropertyChangeListener("reports", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List newValue = (List)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New reports : " + newValue));
                }
                newValue.add(0, null);
                UIHelper.fillComboBox((JComboBox)tabUI.getReportSelector(), (Collection)newValue, null);
            }
        });
        tabUI.getStepModel().addPropertyChangeListener("selectedReport", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DataMatrix data;
                ReportModel source = (ReportModel)((Object)evt.getSource());
                Report report = (Report)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New selected report [" + report + "] will repopulate resultTableModel"));
                }
                try {
                    data = ReportUIHandler.this.buildResult(source, report);
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)"Could not obtain report data", (Throwable)e);
                    data = null;
                }
                source.getResultModel().populate(report, data);
                if (source.isAutoCopyToClipboard()) {
                    ReportUIHandler.this.copyReportToClipBoard(report, source.getResultModel());
                }
            }
        });
        log.info((Object)("Init extra configuration for " + tabUI.getName()));
        ConfigUI configUI = (ConfigUI)ui.getStepUI(AdminStep.CONFIG);
        JAXXInitialContext tx = new JAXXInitialContext().add((Object)configUI).add((Object)this);
        ReportConfigUI extraConfig = new ReportConfigUI((JAXXContext)tx);
        configUI.getExtraConfig().add((Component)((Object)extraConfig));
    }

    public void initTabUI(AdminUI ui, final SelectReportDataUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        JTree tree = tabUI.getSelectTree();
        tabUI.getTreeHelper().setUI(tree, false, null);
        DataSelectionTreeCellRenderer.initUI(tree);
        tabUI.getModel().getReportModel().addPropertyChangeListener("selectionModelChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!tabUI.getModel().containsStep((WizardStep)tabUI.getStep())) {
                    return;
                }
                DataSelectionModel value = (DataSelectionModel)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("selection model changed to " + value.getDatas()));
                    log.debug((Object)("IS USE DATA ? : " + value.isUseData()));
                }
                ReportUIHandler.this.updateSelectionModel(tabUI);
            }
        });
        UIHelper.getLayer((JComponent)tabUI.getContent()).setUI(null);
        UIHelper.getLayer((JComponent)tabUI.getSelectTreePane()).setUI((LayerUI)ui.getConfigBlockLayerUI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelectedReport(Report report) {
        this.getModel().setBusy(true);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("New selected report : " + report));
            }
            this.getModel().getReportModel().setSelectedReport(report);
        }
        finally {
            this.getModel().setBusy(false);
        }
    }

    public String updateSelectedReportDescrption(Report report) {
        if (report == null) {
            return I18n._((String)"observe.message.no.report.selected");
        }
        return I18n._((String)report.getDescription());
    }

    public void copyReportToClipBoard(Report report, ResultTableModel model) {
        if (report == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will copy result of report " + report.getName()));
            log.debug((Object)("Result dimension : [" + model.getRowCount() + "," + model.getColumnCount() + "]"));
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String content = model.getClipbordContent();
        if (log.isInfoEnabled()) {
            log.info((Object)("Put in clipboard :\n" + content));
        }
        StringSelection selection = new StringSelection(content);
        clipboard.setContents(selection, selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataMatrix buildResult(ReportModel reportModel, Report report) throws Exception {
        if (report == null) {
            return null;
        }
        String mareeId = reportModel.getSelectedMaree();
        if (mareeId == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Build result for report [" + report.getName() + "] on " + mareeId));
        }
        DataSource source = this.model.getSafeLocalSource(false);
        this.openSource(source);
        int rows = report.getRows();
        int columns = report.getColumns();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dimension : [" + rows + "," + columns + "]"));
        }
        Properties params = new Properties();
        params.put("mareeId", mareeId);
        String txName = "buildResult";
        TopiaContext tx = this.beginTransaction(source, txName);
        try {
            DataMatrix result;
            DataMatrix dataMatrix = result = this.execute(report, tx, params);
            return dataMatrix;
        }
        finally {
            this.closeTransaction(source, tx, txName);
        }
    }

    protected DataMatrix execute(Report report, TopiaContext tx, Properties params) throws TopiaException {
        ExecuteRequests firstRequest = (ExecuteRequests)ReportBuilder.newOperation("ExecuteRequests");
        firstRequest.setParams(params);
        DataMatrix result = firstRequest.execute(tx, report, new DataMatrix());
        for (ReportOperation operation : report.getOperations()) {
            DataMatrix tmp = result;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Apply operation " + operation + " to " + tmp));
            }
            result = operation.execute(tx, report, tmp);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Final result : " + result));
        }
        return result;
    }

    public void chooseReportFile() {
        ReportModel model = this.getModel().getReportModel();
        File f = UIHelper.chooseFile(this.ui, I18n._((String)"observe.title.choose.reportFile"), I18n._((String)"observe.action.choose.reportFile"), model.getReportFile(), "^.+\\.properties$", I18n._((String)"observe.action.choose.reportFile.description"));
        model.setReportFile(f);
    }
}

