/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveConfigOption;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceConfig;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.DataSourceFactory;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.impl.H2DataSourceConfig;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.entities.ReferentielLocaleEnum;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUIMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminUILauncher;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIManager;
import fr.ird.observe.ui.storage.StorageBackupUILauncher;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUILauncher;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import jaxx.runtime.swing.editor.config.model.CallBackFinalizer;
import jaxx.runtime.swing.editor.config.model.MainCallBackFinalizer;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUIHandler;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Resource;

@DefaultApplicationContext.AutoLoad
public class ObserveMainUIHandler
implements JAXXHelpUIHandler {
    private static Log log = LogFactory.getLog(ObserveMainUIHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeNavigationNode(ObserveMainUI ui, TreeSelectionEvent event) {
        DataSource source = ui.getDataSource();
        if (source == null || !source.isOpen()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No open Data source.");
            }
            return;
        }
        if (ui.getNavigation().isSelectionEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No selection, do nothing...");
            }
            return;
        }
        TreePath path = event.getPath();
        ObserveNode node = (ObserveNode)((Object)path.getLastPathComponent());
        ContentUIManager manager = ui.getContentManager();
        Class<? extends ContentUI<?>> uiClass = manager.convertNodeToContentUI(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selected path = " + (Object)((Object)node) + ", ui = " + uiClass));
        }
        if (uiClass == null) {
            return;
        }
        ui.setBusy(true);
        try {
            this.doOpencontent(ui, path, manager, uiClass);
            ui.setBusy(false);
        }
        catch (Exception e) {
            try {
                log.error((Object)e);
                ErrorDialogUI.showError((Exception)e);
                ui.setBusy(false);
            }
            catch (Throwable throwable) {
                ui.setBusy(false);
                String params = node.isStringNode() ? I18n._((String)node.getId()) : I18n._((String)ui.getDataService().getDecoratorService().getEntityLabel(node.getInternalClass()));
                ui.getStatus().setStatus(I18n._((String)"observe.action.open.screen", (Object[])new Object[]{params}));
                throw throwable;
            }
            String params = node.isStringNode() ? I18n._((String)node.getId()) : I18n._((String)ui.getDataService().getDecoratorService().getEntityLabel(node.getInternalClass()));
            ui.getStatus().setStatus(I18n._((String)"observe.action.open.screen", (Object[])new Object[]{params}));
        }
        String params = node.isStringNode() ? I18n._((String)node.getId()) : I18n._((String)ui.getDataService().getDecoratorService().getEntityLabel(node.getInternalClass()));
        ui.getStatus().setStatus(I18n._((String)"observe.action.open.screen", (Object[])new Object[]{params}));
    }

    public void doOpencontent(ObserveMainUI ui, TreePath path, ContentUIManager manager, Class<? extends ContentUI<?>> uiClass) {
        Object[] nodes = path.getPath();
        ArrayList<String> ids = new ArrayList<String>();
        for (Object o : nodes) {
            ObserveNode n = (ObserveNode)((Object)o);
            if (n.isStringNode() || n.isReferentielNode() || n.isRoot() || !n.isDataNode()) continue;
            ids.add(n.getId());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selected ids from tree = " + ids));
        }
        String[] selectedIds = ids.toArray(new String[ids.size()]);
        DataContext context = ui.getDataContext();
        context.populateSelectedIds(selectedIds);
        ContentUI<?> content = manager.getContent(uiClass);
        if (content == null) {
            content = manager.createContent(uiClass);
        }
        manager.openContent(content);
    }

    public static ObserveMainUI initUI(ObserveContext context, ObserveConfig config) {
        SwingValidatorMessageTableModel errorModel = new SwingValidatorMessageTableModel();
        DecoratorService decoratorService = context.getDecoratorService();
        boolean reloadDecorators = false;
        if (!config.getLocale().equals(I18n.getStore().getLanguage().getLocale())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("re-init I18n with locale " + config.getLocale()));
            }
            I18n.init((Locale)config.getLocale());
            reloadDecorators = true;
        }
        if (!config.getDbLocale().equals(decoratorService.getReferentielLocale().getLocale())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("re-init db with locale " + config.getDbLocale()));
            }
            decoratorService.setReferentielLocale(ReferentielLocaleEnum.valueOf((Locale)config.getDbLocale()));
            reloadDecorators = true;
        }
        if (reloadDecorators) {
            if (log.isInfoEnabled()) {
                log.info((Object)"reload decorators");
            }
            decoratorService.reload();
        }
        ObserveTreeHelper treeHelper = new ObserveTreeHelper();
        DataSource source = context.getDataSource();
        boolean open = context.getDataContext().getEnabled();
        if (open) {
            treeHelper.createModel(source);
        } else {
            treeHelper.createEmptyModel();
        }
        JAXXInitialContext tx = new JAXXInitialContext();
        tx.add((Object)context).add((Object)treeHelper).add((Object)errorModel);
        ObserveMainUI ui = new ObserveMainUI((JAXXContext)tx);
        ui.setUndecorated(config.isFullScreen());
        String title = ObserveRunner.isAdmin() ? I18n._((String)"observe.title.welcome.admin") : I18n._((String)"observe.title.welcome");
        title = title + " v " + config.getVersion();
        ui.setTitle(title);
        context.setObserveMainUI(ui);
        ErrorDialogUI.init((Frame)ui);
        ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(config.isFullScreen() ? ui : null);
        context.registerShareActions(ui);
        return ui;
    }

    public void reloadI18n(ObserveMainUI ui) {
        log.info((Object)"ObServe reloading i18n...");
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        File directory = config.getI18nDirectory();
        log.info((Object)I18n._((String)"observe.message.delete.directory", (Object[])new Object[]{directory}));
        FileUtil.deleteRecursively((File)directory);
        I18n.close();
        I18n.init((Locale)config.getLocale());
        DecoratorService decoratorService = ui.getContextValue(DecoratorService.class);
        if (log.isInfoEnabled()) {
            log.info((Object)"reload decorators");
        }
        decoratorService.reload();
        Callback.ui.run();
    }

    public void reloadDefaultConfiguration(ObserveMainUI ui) {
        log.info((Object)"ObServe reloading default configuration...");
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        File directory = config.getResourcesDirectory();
        log.info((Object)I18n._((String)"observe.message.delete.directory", (Object[])new Object[]{directory}));
        FileUtil.deleteRecursively((File)directory);
        Callback.application.run();
    }

    public void reloadApplication(ObserveMainUI ui) {
        log.info((Object)"ObServe reloading...");
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        Callback.application.run();
    }

    public void changeLanguage(ObserveMainUI ui, Locale newLocale) {
        log.info((Object)"ObServe changing application language...");
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        config.setOption(ObserveConfigOption.LOCALE, newLocale);
        Callback.ui.run();
    }

    public void changeDbLanguage(ObserveMainUI ui, ReferentielLocaleEnum newLocale) {
        log.info((Object)"ObServe changing db language...");
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        config.setOption(ObserveConfigOption.DB_LOCALE, newLocale.getLocale());
        Callback.ui.run();
    }

    public void changeScreen(ObserveMainUI ui, boolean fullscreen) {
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        config.setOption(ObserveConfigOption.FULL_SCREEN, fullscreen);
        this.reloadUI(ObserveContext.get(), config);
    }

    public void showStorageInfo(ObserveMainUI ui) {
        String text = ui.getConfig().isMainStorageOpened() ? ui.getDataSource().toString() : I18n._((String)"observe.message.db.none.loaded");
        JOptionPane.showMessageDialog(ui, text, I18n._((String)"observe.title.storage.info"), 1);
    }

    public void launchImportFromFile(final JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new StorageUILauncher(rootContext, this.getUI(rootContext), I18n._((String)"observe.title.import.localDB")){

            @Override
            protected void init(StorageUI ui) {
                super.init(ui);
                StorageUIModel model = ui.getModel();
                model.setDbMode(DbMode.CREATE_LOCAL);
                model.setCreationMode(CreationMode.IMPORT_EXTERNAL_DUMP);
                if (model.isLocalStorageExist()) {
                    model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.BACKUP, StorageStep.CONFIRM});
                } else {
                    model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.CONFIRM});
                }
            }

            @Override
            protected void doAction(StorageUI ui) {
                super.doAction(ui);
                StorageUIHandler handler = this.getStorageUIHandler();
                handler.doChangeStorage(rootContext, ui.getModel());
            }
        }.start();
    }

    public void launchChangeStorage(JAXXContext rootContext, DbMode mode, String title) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        StorageUILauncher.changeStorage(rootContext, this.getUI(rootContext), mode, title);
    }

    public void launchExportToFile(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        DataSource service = ObserveMainUIHandler.getStorage();
        boolean local = service.getConfig() instanceof H2DataSourceConfig;
        if (!(local || service.canReadData() && service.canWriteData())) {
            UIHelper.askUser(null, I18n._((String)"observe.title.can.not.export.obstuna"), I18n._((String)"observe.storage.required.rw.on.data", (Object[])new Object[]{service}), 0, new Object[]{I18n._((String)"observe.choice.cancel")}, 0);
            return;
        }
        String title = local ? I18n._((String)"observe.title.save.localDB") : I18n._((String)"observe.title.save.remoteDB");
        ObserveMainUI ui = this.getUI(rootContext);
        StorageBackupUILauncher launcher = new StorageBackupUILauncher(rootContext, ui, title);
        launcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchCloseStorage(JAXXContext context) {
        boolean canContinue = this.ensureModification(context);
        if (!canContinue) {
            return;
        }
        this.setBusy(context, true);
        try {
            DataSource storage = ObserveMainUIHandler.getStorage();
            if (log.isDebugEnabled()) {
                log.debug((Object)(">>> close main storage " + storage));
            }
            storage.doClose(false);
        }
        catch (DataSourceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            log.error((Object)ex);
        }
        finally {
            ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.removeContextValue((JAXXContext)ObserveContext.get());
            this.setBusy(context, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchReloadStorage(JAXXContext context) {
        boolean canContinue = this.ensureModification(context);
        if (!canContinue) {
            return;
        }
        DataSource storage = ObserveMainUIHandler.getStorage();
        if (storage == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No storage to reload");
            }
            return;
        }
        this.setBusy(context, false);
        ObserveMainUI ui = this.getUI(context);
        String[] ids = ui.getTreeHelper().getSelectedIds();
        try {
            DataSourceConfig config = storage.getConfig().clone();
            try {
                log.debug((Object)(">>> close main storage " + storage));
                storage.doClose(false);
            }
            catch (DataSourceException e) {
                ErrorDialogUI.showError((Exception)((Object)e));
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            ObserveConfig appConfig = ObserveContext.get().getConfig();
            if (config instanceof H2DataSourceConfig) {
                H2DataSourceConfig h2Config = (H2DataSourceConfig)config;
                h2Config.setReferentielEditable(Boolean.valueOf(appConfig.isH2ReferentielEditable()));
                h2Config.setCanMigrate(appConfig.isCanMigrateH2());
                h2Config.detectPolicy();
            }
            if (config instanceof PGDataSourceConfig) {
                PGDataSourceConfig pgConfig = (PGDataSourceConfig)config;
                pgConfig.setCanMigrate(appConfig.isCanMigrateObstuna());
            }
            try {
                storage = DataSourceFactory.newService((DataSourceConfig)config, storage.getClass());
                ObserveContext.get().prepareMainStorage(storage);
                storage.doOpen();
            }
            catch (Exception e) {
                ErrorDialogUI.showError((Exception)e);
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (ids != null) {
                    ui.getTreeHelper().selectNode(ids);
                }
            }
        }
        finally {
            this.setBusy(context, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeApplication(ObserveMainUI ui) {
        log.info((Object)"ObServe quitting...");
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        try {
            ui.dispose();
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ask to release runner.");
            }
            ObserveRunner.unlock();
        }
    }

    public void showConfig(JAXXContext context) {
        boolean canContinue;
        ObserveMainUI ui = this.getUI(context);
        log.info((Object)"ObServe opening configuration ui...");
        if (ui != null && !(canContinue = this.ensureModification((JAXXContext)ui))) {
            return;
        }
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        ObserveConfigUIBuilder helper = new ObserveConfigUIBuilder(config);
        for (Callback callback : Callback.values()) {
            helper.registerCallBack(callback);
        }
        helper.setFinalizer((CallBackFinalizer)new MainCallBackFinalizer(Callback.application.name()));
        helper.addCategory(I18n.n_((String)"observe.config.category.directories"), I18n.n_((String)"observe.config.category.directories.description"));
        helper.addOption(ObserveConfigOption.CONFIG_FILE);
        helper.addOption(ObserveConfigOption.DB_DIRECTORY);
        helper.addOption(ObserveConfigOption.BACKUP_DIRECTORY);
        helper.addOption(ObserveConfigOption.TMP_DIRECTORY);
        helper.addOption(ObserveConfigOption.RESOURCES_DIRECTORY, Callback.application);
        helper.addCategory(I18n.n_((String)"observe.config.category.h2"), I18n.n_((String)"observe.config.category.h2.description"));
        helper.addOption(ObserveConfigOption.H2_LOGIN);
        helper.addOption(ObserveConfigOption.H2_PASSWORD);
        helper.addOption(ObserveConfigOption.H2_CAN_MIGRATE);
        if (ObserveRunner.isAdmin()) {
            helper.addOption(ObserveConfigOption.H2_REFERENTIEL_EDITABLE, Callback.db);
        }
        helper.addCategory(I18n.n_((String)"observe.config.category.obstuna"), I18n.n_((String)"observe.config.category.obstuna.description"));
        helper.addOption(ObserveConfigOption.OBSTUNA_URL);
        helper.addOption(ObserveConfigOption.OBSTUNA_LOGIN);
        helper.addOption(ObserveConfigOption.OBSTUNA_USE_SSL_CERT);
        helper.addOption(ObserveConfigOption.OBSTUNA_SSL_CERTIFICAT_FILE);
        if (ObserveRunner.isAdmin()) {
            helper.addOption(ObserveConfigOption.OBSTUNA_CAN_MIGRATE, Callback.db);
        }
        helper.addCategory(I18n.n_((String)"observe.config.category.changeStorage"), I18n.n_((String)"observe.config.category.changeStorage.description"));
        helper.addOption(ObserveConfigOption.DEFAULT_DB_MODE);
        helper.addOption(ObserveConfigOption.DEFAULT_CREATION_MODE);
        if (ObserveRunner.isAdmin()) {
            helper.addOption(ObserveConfigOption.CAN_GENERATE_EMPTY_DB);
            helper.addOption(ObserveConfigOption.STORE_REMOTE_STORAGE);
            helper.addCategory(I18n.n_((String)"observe.config.category.gps"), I18n.n_((String)"observe.config.category.gps.description"));
            helper.addOption(ObserveConfigOption.DEFAULT_GPS_MAX_DELAY);
            helper.addOption(ObserveConfigOption.DEFAULT_GPS_MAX_SPEED);
            helper.addCategory(I18n.n_((String)"observe.config.category.synchro"), I18n.n_((String)"observe.config.category.synchro.description"));
            helper.addOption(ObserveConfigOption.CHANGE_SYNCHRO_SRC);
            helper.addOption(ObserveConfigOption.H2_CAN_MIGRATE);
            helper.addCategory(I18n.n_((String)"observe.config.category.observation"), I18n.n_((String)"observe.config.category.observation.description"));
            helper.addOption(ObserveConfigOption.OBSERVATION_ACTIVITES_DETAILLEES, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_FAUNE_ASSOCIEE, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_GLEURE, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_MAMMIFERES, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_MENSURATIONS, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_OBJET_FLOTTANT, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_OISEAUX, Callback.ui);
            helper.addOption(ObserveConfigOption.OBSERVATION_REJETS_THONS, Callback.ui);
        }
        helper.addCategory(I18n.n_((String)"observe.config.category.other"), I18n.n_((String)"observe.config.category.other.description"));
        helper.addOption(ObserveConfigOption.SHOW_NUMBER_EDITOR_BUTTON);
        helper.addOption(ObserveConfigOption.AUTO_POPUP_NUMBER_EDITOR);
        helper.addOption(ObserveConfigOption.LOAD_LOCAL_STORAGE, Callback.application);
        helper.addOption(ObserveConfigOption.FULL_SCREEN, Callback.ui);
        helper.addOption(ObserveConfigOption.LOCALE, Callback.ui);
        helper.addOption(ObserveConfigOption.DB_LOCALE, Callback.ui);
        helper.buildUI(context, "observe.config.category.directories");
        helper.displayUI(ui, false);
    }

    public void showHelp(JAXXContext context, JAXXHelpBroker broker, String helpId) {
        ObserveMainUI mainUI = this.getUI(context);
        if (helpId == null) {
            helpId = broker.getDefaultID();
        }
        log.debug((Object)("show help " + helpId));
        mainUI.getHelp().setCurrentID(helpId);
        mainUI.setContextValue(mainUI.getMode(), "oldMode");
        mainUI.setMode(ObserveUIMode.HELP);
    }

    public void closeHelp(JAXXContext context) {
        ObserveMainUI mainUI = this.getUI(context);
        ObserveUIMode oldMode = mainUI.getContextValue(ObserveUIMode.class, "oldMode");
        if (oldMode == null) {
            DataSource mainStorage = mainUI.getDataSource();
            oldMode = mainStorage == null ? ObserveUIMode.NO_DB : ObserveUIMode.DB;
        }
        mainUI.setMode(oldMode);
    }

    public void gotoSite(ObserveMainUI ui) {
        ObserveConfig config = ui.getConfig();
        URL siteURL = config.getOptionAsURL("application.site.url");
        UIHelper.displayInfo(I18n._((String)"observe.message.goto.site", (Object[])new Object[]{siteURL}));
        log.info((Object)("goto " + siteURL));
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                ErrorDialogUI.showError((Exception)ex);
            }
        }
    }

    public void showAbout(ObserveMainUI ui) {
        AboutPanel about = new AboutPanel(){
            private static final long serialVersionUID = 1L;

            public void buildTopPanel() {
                this.topPanel.setLayout(new BorderLayout());
                ImageIcon logoIcon = Resource.getIcon((String)"/icons/logo-OT_web.png");
                JLabel labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "West");
                logoIcon = Resource.getIcon((String)"/icons/logo_ird.png");
                labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "East");
            }
        };
        String name = ObserveRunner.getRunner().getRunnerName();
        about.setTitle(I18n._((String)"observe.title.about"));
        about.setAboutText(I18n._((String)"observe.about.message"));
        about.setBottomText(ui.getConfig().getCopyrightText());
        about.setIconPath("/icons/logo-OT_web.png");
        about.setLicenseFile("META-INF/" + name + "-LICENSE.txt");
        about.setThirdpartyFile("META-INF/" + name + "-THIRD-PARTY.txt");
        about.init();
        about.showInDialog((Frame)ui, true);
    }

    protected static DataSource getStorage() {
        DataSource source = ObserveContext.get().getDataSource();
        return source;
    }

    protected static DataService getDataService() {
        return ObserveContext.get().getDataService();
    }

    protected void setBusy(JAXXContext context, boolean busy) {
        ObserveMainUI observeMainUI = this.getUI(context);
        if (observeMainUI != null) {
            observeMainUI.setBusy(busy);
        }
    }

    public static void restartEdit(StorageUI ui) {
        ContentUI selectedUI = (ContentUI)((Object)ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.getContextValue((JAXXContext)ui));
        if (selectedUI != null && selectedUI.isEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will restart edit for " + ui.getName()));
            }
            selectedUI.restartEdit();
        }
    }

    public void launchAdminAction(JAXXContext context, AdminStep action) {
        boolean canContinue = this.ensureModification(context);
        if (!canContinue) {
            return;
        }
        AdminUILauncher launcher = AdminUILauncher.newLauncher(context, action);
        launcher.start();
    }

    protected void reloadUI(ObserveContext rootContext, ObserveConfig config) {
        config.removeJaxxPropertyChangeListener();
        ObserveMainUI ui = this.getUI((JAXXContext)rootContext);
        DataSource mainStorage = rootContext.getDataSource();
        ObserveUIMode oldMode = null;
        Object[] ids = null;
        if (ui != null) {
            oldMode = ui.getMode();
            ids = ui.getTreeHelper().getSelectedIds();
            ErrorDialogUI.init(null);
            rootContext.removeObserveMainUI();
            ui.dispose();
            ui.setVisible(false);
            System.runFinalization();
        }
        ui = ObserveMainUIHandler.initUI(rootContext, config);
        if (oldMode == null) {
            oldMode = mainStorage == null ? ObserveUIMode.NO_DB : ObserveUIMode.DB;
        }
        ui.setMode(oldMode);
        JTree navigation = ui.getNavigation();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will reselect ids : " + Arrays.toString(ids)));
        }
        if (ids != null) {
            ui.getTreeHelper().selectNode((String[])ids);
        }
        navigation.requestFocus();
        ui.setVisible(true);
    }

    protected boolean ensureModification(JAXXContext rootContext) throws IllegalArgumentException {
        JPanel container;
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        ObserveMainUI ui = this.getUI(rootContext);
        if (ui == null) {
            return true;
        }
        Boolean wasClosed = null;
        CardLayout2 layout = ui.getContentLayout();
        Component currentContent = layout.getVisibleComponent((Container)(container = ui.getContent()));
        if (currentContent != null && currentContent instanceof ContentUI) {
            ContentUI ui1 = (ContentUI)((Object)currentContent);
            wasClosed = ContentUIHandler.checkEdit(ui1);
        }
        return wasClosed == null || wasClosed != false;
    }

    protected ObserveMainUI getUI(JAXXContext context) {
        if (context instanceof ObserveMainUI) {
            return (ObserveMainUI)context;
        }
        ObserveMainUI ui = ObserveContext.get().getObserveMainUI();
        return ui;
    }

    protected class ObserveConfigUIBuilder
    extends ConfigUIHelper {
        public ObserveConfigUIBuilder(ObserveConfig config) {
            super((ApplicationConfig)config);
        }

        public ObserveConfigOption addOption(ObserveConfigOption option) {
            String beanProperty = option.getPropertyKey();
            if (StringUtils.isEmpty((String)beanProperty)) {
                super.addOption((ApplicationConfig.OptionDef)option);
            } else {
                this.addOption(option, beanProperty);
            }
            if (!option.isAdmin() || ObserveRunner.isAdmin()) {
                return option;
            }
            return null;
        }

        public void addOption(ObserveConfigOption option, Callback callBack) {
            if ((option = this.addOption(option)) != null) {
                this.setOptionCallBack(callBack.name());
            }
        }

        public void registerCallBack(Callback callback) {
            String name = callback.name();
            String description = callback.getLabel();
            ImageIcon icon = callback.getIcon();
            Callback action = callback;
            this.registerCallBack(name, description, icon, action);
        }
    }

    public static enum Callback implements Runnable
    {
        application(I18n.n_((String)"observe.action.reload.application"), "reload-application"){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"will reload application");
                }
                ObserveContext context = ObserveContext.get();
                ObserveMainUIHandler handler = new ObserveMainUIHandler();
                ObserveMainUI ui = handler.getUI((JAXXContext)context);
                context.askReload();
                handler.closeApplication(ui);
            }
        }
        ,
        ui(I18n.n_((String)"observe.action.reload.ui"), "reload-ui"){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"will reload ui");
                }
                ObserveContext context = ObserveContext.get();
                ObserveMainUIHandler handler = new ObserveMainUIHandler();
                ObserveMainUI ui = handler.getUI((JAXXContext)context);
                ObserveConfig config = ui.getConfig();
                handler.reloadUI(context, config);
            }
        }
        ,
        db(I18n.n_((String)"observe.action.reload.storage"), "reload-db"){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"will reload db");
                }
                ObserveContext context = ObserveContext.get();
                ObserveMainUIHandler handler = new ObserveMainUIHandler();
                handler.launchReloadStorage((JAXXContext)context);
            }
        };

        private final String label;
        private final String iconPath;

        private Callback(String label, String iconPath) {
            this.iconPath = iconPath;
            this.label = label;
            this.getIcon();
        }

        public ImageIcon getIcon() {
            ImageIcon icon = UIHelper.createActionIcon((String)this.iconPath);
            return icon;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

