/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.tree.ObserveTreeCellRenderer;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.nuiton.i18n.I18n;

public enum ObserveContentActions {
    up(I18n.n_((String)"observe.action.goUp"), "go-up"){

        @Override
        public Action createAction(ObserveMainUI mainUI) {
            AbstractAction a = new AbstractAction(I18n._((String)this.getLabel()), this.getActionIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(final ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JComponent c = (JComponent)e.getSource();
                            JPopupMenu p = (JPopupMenu)c.getClientProperty("popup");
                            if (p == null) {
                                throw new IllegalStateException("could not find client property popup on component" + c);
                            }
                            p.show(c, 2, c.getHeight());
                        }
                    });
                }
            };
            a.putValue("ShortDescription", I18n._((String)"observe.action.goUp.tip"));
            return a;
        }

        @Override
        public void initAction(ObserveMainUI mainUI, ObserveContentUI<?> ui, AbstractButton editor, Action action) {
            super.initAction(mainUI, ui, editor, action);
            editor.putClientProperty("popup", mainUI.getScopeUpPopup());
        }

        @Override
        public void updateAction(ObserveMainUI mainUI, ObserveContentUI<?> ui, AbstractButton editor) {
            super.updateAction(mainUI, ui, editor);
            ObserveTreeHelper treeHelper = mainUI.getTreeHelper();
            NavigationModel navigationModel = treeHelper.getModel((JAXXContext)ui);
            ObserveTreeCellRenderer render = treeHelper.getTreeCellRenderer((JAXXContext)ui);
            JPopupMenu scopePopup = mainUI.getScopeUpPopup();
            Action action = mainUI.getRootPane().getActionMap().get("selectNode");
            NavigationTreeNode node = treeHelper.getSelectedNode((JAXXContext)ui);
            TreeNode root = node.getRoot();
            scopePopup.removeAll();
            scopePopup.setLayout(new GridLayout(0, 1));
            while (node.getParent() != root) {
                node = node.getParent();
                Color color = render.getNavigationTextColor(navigationModel, node);
                Icon icon = render.getNavigationIcon(node, "-16");
                String text = node.getRenderer().toString();
                JMenuItem mi = new JMenuItem();
                mi.setAction(action);
                mi.setText(text.trim());
                mi.setIcon(icon);
                mi.setForeground(color);
                mi.setBackground(Color.WHITE);
                mi.putClientProperty("node", node);
                mi.putClientProperty("ui", ui);
                mi.setAction(action);
                scopePopup.add(mi);
            }
            scopePopup.revalidate();
        }
    }
    ,
    down(I18n.n_((String)"observe.action.goDown"), "go-down"){

        @Override
        public Action createAction(ObserveMainUI mainUI) {
            AbstractAction a = new AbstractAction(I18n._((String)this.getLabel()), this.getActionIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(final ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JComponent c = (JComponent)e.getSource();
                            JPopupMenu p = (JPopupMenu)c.getClientProperty("popup");
                            if (p == null) {
                                throw new IllegalStateException("could not find client property popup on component" + c);
                            }
                            p.show(c, 2, c.getHeight());
                        }
                    });
                }
            };
            a.putValue("ShortDescription", I18n._((String)"observe.action.goDown.tip"));
            return a;
        }

        @Override
        public void initAction(ObserveMainUI mainUI, ObserveContentUI<?> ui, AbstractButton editor, Action action) {
            super.initAction(mainUI, ui, editor, action);
            editor.putClientProperty("popup", mainUI.getScopeDownPopup());
        }

        @Override
        public void updateAction(ObserveMainUI mainUI, ObserveContentUI<?> ui, AbstractButton editor) {
            JMenuItem mi;
            String text;
            Icon icon;
            Color color;
            NavigationTreeNode node;
            ObserveTreeHelper treeHelper = mainUI.getTreeHelper();
            ObserveTreeCellRenderer render = treeHelper.getTreeCellRenderer((JAXXContext)ui);
            NavigationModel navigationModel = treeHelper.getModel((JAXXContext)ui);
            super.updateAction(mainUI, ui, editor);
            JPopupMenu scopePopup = mainUI.getScopeDownPopup();
            Action action = mainUI.getRootPane().getActionMap().get("selectNode");
            NavigationTreeNode nodeOriginal = node = treeHelper.getSelectedNode((JAXXContext)ui);
            scopePopup.removeAll();
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                node = (NavigationTreeNode)e.nextElement();
                color = render.getNavigationTextColor(navigationModel, node);
                icon = render.getNavigationIcon(node, "-16");
                text = node.getRenderer().toString();
                mi = new JMenuItem();
                mi.setAction(action);
                mi.setText(text.trim());
                mi.setIcon(icon);
                mi.setForeground(color);
                mi.putClientProperty("node", node);
                mi.putClientProperty("ui", ui);
                mi.setAction(action);
                scopePopup.add(mi);
            }
            if (nodeOriginal.getChildCount() == 1 && !nodeOriginal.getChildAt(0).isLeaf()) {
                e = nodeOriginal.getChildAt(0).children();
                while (e.hasMoreElements()) {
                    node = (NavigationTreeNode)e.nextElement();
                    color = render.getNavigationTextColor(navigationModel, node);
                    icon = render.getNavigationIcon(node, "-16");
                    text = node.getRenderer().toString();
                    mi = new JMenuItem();
                    mi.setAction(action);
                    mi.setText(text.trim());
                    mi.setIcon(icon);
                    mi.setForeground(color);
                    mi.putClientProperty("node", node);
                    mi.putClientProperty("ui", ui);
                    mi.setAction(action);
                    scopePopup.add(mi);
                }
            }
        }
    }
    ,
    reopen(I18n.n_((String)"observe.action.reopen"), "reopen"){

        @Override
        public Action createAction(ObserveMainUI mainUI) {
            AbstractAction a = new AbstractAction(I18n._((String)this.getLabel()), this.getActionIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(final ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JComponent c = (JComponent)e.getSource();
                            ObserveContentUI ui = (ObserveContentUI)c.getClientProperty("ui");
                            if (ui == null) {
                                throw new IllegalStateException("could not find client property ui on component" + c);
                            }
                            ObserveContentHandler handler = ui.getHandler();
                            handler.openOpenable(ui);
                        }
                    });
                }
            };
            return a;
        }
    }
    ,
    close(I18n.n_((String)"observe.action.close.open"), "close"){

        @Override
        public Action createAction(ObserveMainUI mainUI) {
            AbstractAction a = new AbstractAction(I18n._((String)this.getLabel()), this.getActionIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(final ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JComponent c = (JComponent)e.getSource();
                            ObserveContentUI ui = (ObserveContentUI)c.getClientProperty("ui");
                            if (ui == null) {
                                throw new IllegalStateException("could not find client property ui on component" + c);
                            }
                            ObserveContentHandler handler = ui.getHandler();
                            handler.closeOpenable(ui);
                        }
                    });
                }
            };
            return a;
        }
    }
    ,
    cancel(I18n.n_((String)"observe.action.cancel"), "cancel"){

        @Override
        public Action createAction(ObserveMainUI mainUI) {
            AbstractAction a = new AbstractAction(I18n._((String)this.getLabel()), this.getActionIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(final ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JComponent c = (JComponent)e.getSource();
                            ObserveContentUI ui = (ObserveContentUI)c.getClientProperty("ui");
                            if (ui == null) {
                                throw new IllegalStateException("could not find client property ui on component" + c);
                            }
                            ui.stopEdit();
                            ui.getTreeHelper().gotoParentNode((JAXXContext)ui);
                        }
                    });
                }
            };
            a.putValue("ShortDescription", I18n._((String)"observe.action.cancelCreate.tip"));
            return a;
        }
    }
    ,
    reset(I18n.n_((String)"observe.action.reset"), "revert"){

        @Override
        public Action createAction(ObserveMainUI mainUI) {
            AbstractAction a = new AbstractAction(I18n._((String)this.getLabel()), this.getActionIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(final ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JComponent c = (JComponent)e.getSource();
                            ObserveContentUI ui = (ObserveContentUI)c.getClientProperty("ui");
                            if (ui == null) {
                                throw new IllegalStateException("could not find client property ui on component" + c);
                            }
                            ui.resetEdit();
                        }
                    });
                }
            };
            a.putValue("ShortDescription", I18n._((String)"observe.action.reset.tip"));
            return a;
        }
    }
    ,
    save(I18n.n_((String)"observe.action.save"), "save"){

        @Override
        public Action createAction(ObserveMainUI mainUI) {
            AbstractAction a = new AbstractAction(I18n._((String)this.getLabel()), this.getActionIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(final ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JComponent c = (JComponent)e.getSource();
                            ObserveContentUI ui = (ObserveContentUI)c.getClientProperty("ui");
                            if (ui == null) {
                                throw new IllegalStateException("could not find client property ui on component" + c);
                            }
                            ui.save(true);
                        }
                    });
                }
            };
            a.putValue("ShortDescription", I18n._((String)"observe.action.save.tip"));
            return a;
        }
    }
    ,
    delete(I18n.n_((String)"observe.action.delete"), "delete"){

        @Override
        public Action createAction(ObserveMainUI mainUI) {
            AbstractAction a = new AbstractAction(I18n._((String)this.getLabel()), this.getActionIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(final ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JComponent c = (JComponent)e.getSource();
                            ObserveContentUI ui = (ObserveContentUI)c.getClientProperty("ui");
                            if (ui == null) {
                                throw new IllegalStateException("could not find client property ui on component" + c);
                            }
                            ui.delete();
                        }
                    });
                }
            };
            a.putValue("ShortDescription", I18n._((String)"observe.action.delete.tip"));
            return a;
        }
    }
    ,
    deleteReferentiel(I18n.n_((String)"observe.action.delete"), "delete"){

        @Override
        public Action createAction(ObserveMainUI mainUI) {
            AbstractAction a = new AbstractAction(I18n._((String)this.getLabel()), this.getActionIcon()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(final ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JComponent c = (JComponent)e.getSource();
                            ObserveContentUI ui = (ObserveContentUI)c.getClientProperty("ui");
                            if (ui == null) {
                                throw new IllegalStateException("could not find client property ui on component" + c);
                            }
                            ui.delete();
                        }
                    });
                }
            };
            a.putValue("ShortDescription", I18n._((String)"observe.action.delete.tip"));
            return a;
        }
    };

    private final String label;
    private final Icon actionIcon;
    private static Set<String> ids;

    private ObserveContentActions(String label, String actionIcon) {
        this.label = label;
        this.actionIcon = SwingUtil.getUIManagerActionIcon((String)actionIcon);
    }

    public String getLabel() {
        return this.label;
    }

    public Icon getActionIcon() {
        return this.actionIcon;
    }

    public static boolean accept(String id) {
        boolean accept = ObserveContentActions.getIds().contains(id);
        return accept;
    }

    public static Set<String> getIds() {
        if (ids == null) {
            HashSet<String> tmp = new HashSet<String>();
            for (ObserveContentActions a : ObserveContentActions.values()) {
                tmp.add(a.name());
            }
            ids = Collections.unmodifiableSet(tmp);
        }
        return ids;
    }

    public void initAction(ObserveMainUI mainUI, ObserveContentUI<?> ui, AbstractButton editor, Action action) {
        editor.setAction(action);
        editor.putClientProperty("mainUI", mainUI);
    }

    public void updateAction(ObserveMainUI mainUI, ObserveContentUI<?> ui, AbstractButton editor) {
        String text;
        editor.putClientProperty("ui", ui);
        String tip = (String)editor.getClientProperty("toolTipText");
        if (tip != null) {
            editor.setToolTipText(tip);
        }
        if ((text = (String)editor.getClientProperty("text")) != null) {
            editor.setText(text);
        }
    }

    public abstract Action createAction(ObserveMainUI var1);
}

