/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.actions;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.MareeDAO;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.entities.referentiel.ProgrammeDAO;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.ui.admin.MareeToExportTableModel;
import fr.ird.observe.ui.admin.SynchroOperationAction;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.wizard.WizardOperationState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;

public class ExportDataAction
extends SynchroOperationAction {
    private static final Log log = LogFactory.getLog(ExportDataAction.class);
    protected boolean wasInit;
    protected boolean canTreate;
    protected MareeToExportTableModel.DataEntry[] data;
    protected Decorator<?> pDecorator;
    protected Decorator<?> mDecorator;

    public ExportDataAction() {
        super(SynchroStep.EXPORT_DATA);
    }

    public void beforeAction(JAXXContext context, SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        if (this.wasInit) {
            return;
        }
        DecoratorProvider decoratorProvider = (DecoratorProvider)this.getContext().getContextValue(DecoratorProvider.class);
        this.pDecorator = decoratorProvider.getDecorator(Programme.class);
        this.mDecorator = decoratorProvider.getDecorator(Maree.class);
        StorageService<?> referentielService = model.getReferentielService();
        if (referentielService == null) {
            referentielService = this.createReferentielService(model.getReferentielServiceModel());
            model.setReferentielService(referentielService);
        }
        if (!referentielService.canWriteData()) {
            this.sendMessage(I18n._((String)"observe.message.can.not.write.data"));
            return;
        }
        this.openService(referentielService);
        this.openService(model.getSynchroService());
        this.canTreate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardOperationState doAction(SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        if (!this.canTreate) {
            this.sendMessage(I18n._((String)"observe.message.exportData.not.possible"));
            this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
            return WizardOperationState.CANCELED;
        }
        if (!this.wasInit) {
            this.sendMessage(I18n._((String)"observe.message.exportData.prepare.data"));
            StorageService<?> referentielService = model.getReferentielService();
            StorageService<?> tmpService = model.getSynchroService();
            try {
                this.prepareData(referentielService, tmpService);
            }
            finally {
                this.wasInit = true;
            }
            if (this.isCancelled()) {
                return this.onCancel(model, (Exception)null);
            }
            if (this.data == null) {
                this.sendMessage(I18n._((String)"observe.message.exportData.not.possible"));
                this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
                return WizardOperationState.CANCELED;
            }
            this.sendMessage(I18n._((String)"observe.message.exportData.operation.needFix", (Object[])new Object[]{new Date()}));
            return WizardOperationState.NEED_FIX;
        }
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        StorageService<?> referentielService = model.getReferentielService();
        StorageService<?> tmpService = model.getSynchroService();
        ArrayList<MareeToExportTableModel.DataEntry> entries = new ArrayList<MareeToExportTableModel.DataEntry>();
        int[] selectedIndex = model.getExportDataSelectedIndex();
        String[] mareeIds = new String[selectedIndex.length];
        int i = 0;
        for (int index : selectedIndex) {
            entries.add(this.data[index]);
            Maree maree = this.data[index].getMaree();
            mareeIds[i++] = maree.getTopiaId();
            if (log.isInfoEnabled()) {
                log.info((Object)("maree a repliquer : " + maree.getTopiaId() + " : " + maree.getDateDebut()));
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("maree a repliquer : " + maree.getTopiaId() + " : routes " + maree.sizeRoute()));
        }
        this.deleteMarees(referentielService, entries);
        tmpService.replicateData(referentielService, mareeIds);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
        return WizardOperationState.SUCCESSED;
    }

    @Override
    public void copyTo(SynchroOperationAction newAction) {
        ExportDataAction n = (ExportDataAction)newAction;
        n.wasInit = this.wasInit;
        n.canTreate = this.canTreate;
        n.data = this.data;
        n.mDecorator = this.mDecorator;
        n.pDecorator = this.pDecorator;
    }

    public MareeToExportTableModel.DataEntry[] getData() {
        return this.data;
    }

    protected void prepareData(StorageService<?> referentielService, StorageService<?> tmpService) throws Exception {
        List programmes = tmpService.getList(Programme.class);
        List existingMarees = referentielService.getCtxt().find("select maree.topiaId from MareeImpl maree", new Object[0]);
        ArrayList<MareeToExportTableModel.DataEntry> entries = new ArrayList<MareeToExportTableModel.DataEntry>();
        for (Programme p : programmes) {
            if (p.isMareeEmpty()) continue;
            for (Maree m : p.getMaree()) {
                MareeToExportTableModel.DataEntry entry = new MareeToExportTableModel.DataEntry();
                entry.setProgramme(p);
                entry.setMaree(m);
                entry.setExist(existingMarees.contains(m.getTopiaId()));
                entries.add(entry);
            }
        }
        if (entries.isEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.exportData.no.maree.detected"));
            return;
        }
        for (MareeToExportTableModel.DataEntry entry : entries) {
            Maree m = entry.getMaree();
            Programme p = entry.getProgramme();
            if (!m.isOpen()) continue;
            this.sendMessage(I18n._((String)"observe.message.exportData.open.maree.detected", (Object[])new Object[]{this.mDecorator.toString((Object)m), this.pDecorator.toString((Object)p)}));
            return;
        }
        this.data = entries.toArray(new MareeToExportTableModel.DataEntry[entries.size()]);
    }

    protected void deleteMarees(StorageService<?> referentielService, List<MareeToExportTableModel.DataEntry> entries) throws Exception {
        TopiaContext refCtxt = referentielService.getCtxt().beginTransaction();
        try {
            ProgrammeDAO refProgrammeDAO = ObserveDAOHelper.getProgrammeDAO((TopiaContext)refCtxt);
            MareeDAO refMareeDAO = ObserveDAOHelper.getMareeDAO((TopiaContext)refCtxt);
            for (MareeToExportTableModel.DataEntry entry : entries) {
                Programme p = entry.getProgramme();
                Maree m = entry.getMaree();
                Boolean exists = entry.isExist();
                if (!exists.booleanValue()) continue;
                this.sendMessage(I18n._((String)"observe.message.exportData.delete.remote.maree", (Object[])new Object[]{this.mDecorator.toString((Object)m), this.pDecorator.toString((Object)p)}));
                Programme dProgramme = (Programme)refProgrammeDAO.findByTopiaId(p.getTopiaId());
                Maree dMaree = (Maree)refMareeDAO.findByTopiaId(m.getTopiaId());
                dProgramme.removeMaree(dMaree);
                dProgramme.update();
            }
            refCtxt.commitTransaction();
        }
        catch (Exception e) {
            refCtxt.rollbackTransaction();
            throw e;
        }
        finally {
            refCtxt.closeContext();
        }
    }
}

