/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.synchro;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.storage.CreationMode;
import fr.ird.observe.storage.DbMode;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.synchro.SynchroOperationAction;
import fr.ird.observe.ui.synchro.SynchroStep;
import java.io.File;
import java.util.ArrayList;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationModel;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardOperationStep;
import jaxx.runtime.swing.wizard.WizardStep;
import org.nuiton.i18n.I18n;

public class SynchroUIModel
extends WizardOperationModel<SynchroStep> {
    public static final String SHOW_RESUME_PROPERTY_NAME = "showResume";
    public static final String IMPORT_GPSFILE_PROPERTY_NAME = "importGPSFile";
    public static final String IMPORT_GPSMAX_DELAY_PROPERTY_NAME = "importGPSMaxDelay";
    public static final String IMPORT_GPSMAX_SPEED_PROPERTY_NAME = "importGPSMaxSpeed";
    public static final String BACKUP_FILE_PROPERTY_NAME = "backupFile";
    public static final String DO_BACKUP_PROPERTY_NAME = "doBackup";
    public static final String LOCAL_SERVICE_NEED_SAVE_PROPERTY_NAME = "localServiceNeedSave";
    protected StorageService<?> previousService;
    protected StorageService<?> localService;
    protected StorageService<?> referentielService;
    protected StorageService<?> synchroService;
    protected File importGPSFile = new File("");
    protected File backupFile = new File("");
    protected boolean doBackup;
    protected boolean showResume;
    protected boolean localServiceNeedSave;
    protected Integer importGPSMaxDelay = 0;
    protected Float importGPSMaxSpeed = Float.valueOf(0.0f);
    protected StorageUIModel localServiceModel = new StorageUIModel(){

        @Override
        public String getLabel() {
            String txt = I18n.n_((String)"observe.storage.label.synchro.local");
            String params = this.dbMode == DbMode.LOCAL ? this.h2Config.getDataDirectory().getAbsolutePath() : this.getRemoteUrl();
            txt = I18n._((String)txt, (Object[])new Object[]{params});
            return txt;
        }

        public void validate() {
            super.validate();
            this.firePropertyChange("valid", null, this.isValid());
        }
    };
    protected StorageUIModel referentielServiceModel = new StorageUIModel(){

        @Override
        public String getLabel() {
            String txt = I18n.n_((String)"observe.storage.label.synchro.referentiel");
            String params = this.dbMode == DbMode.LOCAL ? this.h2Config.getDataDirectory().getAbsolutePath() : this.getRemoteUrl();
            txt = I18n._((String)txt, (Object[])new Object[]{params});
            return txt;
        }

        public void validate() {
            super.validate();
            boolean valid = this.isValid();
            this.firePropertyChange("valid", null, valid);
            if (valid) {
                // empty if block
            }
        }
    };
    protected int[] importGPSSelectedIndex;
    protected int[] exportDataSelectedIndex;

    public SynchroUIModel() {
        super(SynchroStep.class, (WizardOperationStep[])new SynchroStep[0]);
    }

    public void init(JAXXContext context) {
        ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
        StorageService service = dataContext.getStorage();
        this.setPreviousService(service);
        this.localServiceModel.init(context);
        this.localServiceModel.setDbMode(DbMode.LOCAL);
        this.localServiceModel.setCreationMode(CreationMode.USE_LOCAL_STORAGE);
        this.localServiceModel.start();
        this.referentielServiceModel.init(context);
        this.referentielServiceModel.setDbMode(DbMode.REMOTE);
        this.referentielServiceModel.start();
        ((StorageUIHandler)context.getContextValue(StorageUIHandler.class)).testRemote(context, this.referentielServiceModel);
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        this.setBackupFile(new File(config.getBackupDirectory(), ((StorageUIHandler)context.getContextValue(StorageUIHandler.class)).getDefaultBackupFilename()));
        this.setDoBackup(true);
        this.setShowResume(config.isDisplaySynchroResume());
        this.setImportGPSMaxDelay(config.getDefaultGpsMaxDelay());
        this.setImportGPSMaxSpeed(Float.valueOf(config.getDefaultGpsMaxSpeed()));
    }

    public StorageService<?> getPreviousService() {
        return this.previousService;
    }

    public StorageService<?> getLocalService() {
        return this.localService;
    }

    public StorageService<?> getReferentielService() {
        return this.referentielService;
    }

    public StorageService<?> getSynchroService() {
        return this.synchroService;
    }

    public StorageUIModel getLocalServiceModel() {
        return this.localServiceModel;
    }

    public StorageUIModel getReferentielServiceModel() {
        return this.referentielServiceModel;
    }

    public boolean isShowResume() {
        return this.showResume;
    }

    public boolean isLocalServiceNeedSave() {
        return this.localServiceNeedSave;
    }

    public boolean isDoBackup() {
        return this.doBackup;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public File getImportGPSFile() {
        return this.importGPSFile;
    }

    public Integer getImportGPSMaxDelay() {
        return this.importGPSMaxDelay;
    }

    public Float getImportGPSMaxSpeed() {
        return this.importGPSMaxSpeed;
    }

    public int[] getImportGPSSelectedIndex() {
        return this.importGPSSelectedIndex;
    }

    public int[] getExportDataSelectedIndex() {
        return this.exportDataSelectedIndex;
    }

    public SynchroOperationAction getOperationAction(SynchroStep operation) {
        return (SynchroOperationAction)super.getOperationAction((WizardOperationStep)operation);
    }

    public void cancel() {
        super.cancel();
        if (this.showResume) {
            this.gotoStep((WizardStep)this.getSteps().get(this.getSteps().size() - 1));
        }
    }

    public SynchroUIModel addOperation(SynchroStep operation) {
        if (operation == SynchroStep.EXPORT_DATA) {
            this.getOperations().add(SynchroStep.SYNCHRONIZE_REFERENTIEL);
        }
        return (SynchroUIModel)super.addOperation((WizardOperationStep)operation);
    }

    public void removeOperation(SynchroStep operation) {
        if (operation == SynchroStep.SYNCHRONIZE_REFERENTIEL || operation == SynchroStep.VALIDATE_DATA) {
            this.getOperations().remove((Object)SynchroStep.EXPORT_DATA);
        }
        super.removeOperation((WizardOperationStep)operation);
    }

    public void setShowResume(boolean showResume) {
        boolean oldValue = this.showResume;
        this.showResume = showResume;
        this.firePropertyChange(SHOW_RESUME_PROPERTY_NAME, oldValue, showResume);
        this.updateUniverse();
    }

    public void setDoBackup(boolean doBackup) {
        boolean canSave = this.isCanSaveLocal();
        boolean oldValue = this.doBackup;
        this.doBackup = doBackup;
        this.firePropertyChange(DO_BACKUP_PROPERTY_NAME, oldValue, doBackup);
        this.firePropertyChange("canSaveLocal", canSave, this.isCanSaveLocal());
        this.validate();
    }

    public void setLocalServiceNeedSave(boolean localServiceNeedSave) {
        this.localServiceNeedSave = localServiceNeedSave;
        this.firePropertyChange(LOCAL_SERVICE_NEED_SAVE_PROPERTY_NAME, null, localServiceNeedSave);
        if (localServiceNeedSave) {
            this.setOperationState(SynchroStep.SAVE_LOCAL, WizardOperationState.PENDING);
        }
        this.validate();
    }

    public void setImportGPSFile(File importGPSFile) {
        File oldValue = this.importGPSFile;
        this.importGPSFile = importGPSFile;
        this.firePropertyChange(IMPORT_GPSFILE_PROPERTY_NAME, oldValue, importGPSFile);
        this.validate();
    }

    public void setBackupFile(File backupFile) {
        boolean canSave = this.isCanSaveLocal();
        File oldValue = this.backupFile;
        this.backupFile = backupFile;
        this.firePropertyChange(BACKUP_FILE_PROPERTY_NAME, oldValue, backupFile);
        this.firePropertyChange("canSaveLocal", canSave, this.isCanSaveLocal());
        this.validate();
    }

    public void setImportGPSMaxDelay(Integer importGPSMaxDelay) {
        Integer oldValue = this.importGPSMaxDelay;
        this.importGPSMaxDelay = importGPSMaxDelay;
        this.firePropertyChange(IMPORT_GPSMAX_DELAY_PROPERTY_NAME, oldValue, importGPSMaxDelay);
        this.validate();
    }

    public void setImportGPSMaxSpeed(Float importGPSMaxSpeed) {
        Float oldValue = this.importGPSMaxSpeed;
        this.importGPSMaxSpeed = importGPSMaxSpeed;
        this.firePropertyChange(IMPORT_GPSMAX_SPEED_PROPERTY_NAME, oldValue, importGPSMaxSpeed);
        this.validate();
    }

    public void setImportGPSSelectedIndex(int[] importGPSSelectedIndex) {
        this.importGPSSelectedIndex = importGPSSelectedIndex;
    }

    public void setExportDataSelectedIndex(int[] exportDataSelectedIndex) {
        this.exportDataSelectedIndex = exportDataSelectedIndex;
    }

    public void setPreviousService(StorageService<?> previousService) {
        this.previousService = previousService;
    }

    public void setLocalService(StorageService<?> localService) {
        this.localService = localService;
    }

    public void setReferentielService(StorageService<?> referentielService) {
        this.referentielService = referentielService;
    }

    public void setSynchroService(StorageService<?> synchroService) {
        this.synchroService = synchroService;
    }

    protected SynchroStep[] updateStepUniverse() {
        for (SynchroStep op : this.operations) {
            if (this.operationStates.containsKey((Object)op)) continue;
            this.operationStates.put(op, WizardOperationState.PENDING);
        }
        for (SynchroStep op : this.operationStates.keySet()) {
            if (this.operations.contains((Object)op)) continue;
            this.operationStates.remove((Object)op);
        }
        ArrayList<SynchroStep> universe = new ArrayList<SynchroStep>();
        universe.add(SynchroStep.CONFIG);
        if (!this.operations.isEmpty()) {
            if (this.operations.contains((Object)SynchroStep.SYNCHRONIZE_REFERENTIEL)) {
                universe.add(SynchroStep.SYNCHRONIZE_REFERENTIEL);
            }
            if (this.operations.contains((Object)SynchroStep.VALIDATE_DATA)) {
                universe.add(SynchroStep.VALIDATE_DATA);
            }
            if (this.operations.contains((Object)SynchroStep.IMPORT_GPS)) {
                universe.add(SynchroStep.IMPORT_GPS);
            }
            this.updateSaveLocalOperation();
            if (this.operations.contains((Object)SynchroStep.SAVE_LOCAL)) {
                universe.add(SynchroStep.SAVE_LOCAL);
            }
            if (this.operations.contains((Object)SynchroStep.EXPORT_DATA)) {
                universe.add(SynchroStep.EXPORT_DATA);
            }
            if (this.showResume) {
                universe.add(SynchroStep.SHOW_RESUME);
            }
        }
        return universe.toArray(new SynchroStep[universe.size()]);
    }

    protected void updateSaveLocalOperation() {
        boolean shouldAdd = false;
        for (SynchroStep s : this.operations) {
            if (!s.isNeedSave()) continue;
            shouldAdd = true;
        }
        if (shouldAdd) {
            this.operations.add(SynchroStep.SAVE_LOCAL);
        } else {
            this.operations.remove((Object)SynchroStep.SAVE_LOCAL);
        }
    }

    public boolean validate(SynchroStep s) {
        boolean validate;
        boolean bl = validate = super.validate((WizardStep)s) && !this.getOperations().isEmpty();
        if (validate) {
            switch (s) {
                case CONFIG: {
                    validate &= this.localServiceModel.isValid();
                    if (this.operations.contains((Object)SynchroStep.VALIDATE_DATA)) {
                        // empty if block
                    }
                    if (this.operations.contains((Object)SynchroStep.SYNCHRONIZE_REFERENTIEL)) {
                        validate &= this.referentielServiceModel.isValid();
                    }
                    if (this.operations.contains((Object)SynchroStep.EXPORT_DATA)) {
                        validate &= this.referentielServiceModel.isValid();
                    }
                    if (!this.operations.contains((Object)SynchroStep.IMPORT_GPS)) break;
                    validate &= this.importGPSFile != null && this.importGPSFile.exists();
                    break;
                }
                case SYNCHRONIZE_REFERENTIEL: 
                case VALIDATE_DATA: 
                case EXPORT_DATA: 
                case IMPORT_GPS: {
                    validate &= this.getOperationState(s) == WizardOperationState.SUCCESSED;
                    break;
                }
                case SAVE_LOCAL: {
                    validate &= this.getOperationState(s) == WizardOperationState.SUCCESSED;
                    break;
                }
                case SHOW_RESUME: {
                    validate = true;
                }
            }
        }
        return validate;
    }

    public boolean isCanSaveLocal() {
        boolean validate = !this.doBackup || this.backupFile != null && !this.backupFile.exists() && this.backupFile.getName().endsWith(".sql.gz") && this.backupFile.getParentFile().exists();
        return validate;
    }

    public void updateUniverse() {
        super.updateUniverse();
    }
}

