/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.synchro;

import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Programme;
import java.util.HashSet;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.nuiton.i18n.I18n;

public class MareeToExportTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected static final String[] COLUMN_NAMES = new String[]{I18n.n_((String)"observe.synchro.common.selected"), I18n.n_((String)"observe.synchro.common.programme"), I18n.n_((String)"observe.synchro.common.maree"), I18n.n_((String)"observe.synchro.common.exist")};
    protected static final Class<?>[] COLUMN_CLASSES = new Class[]{Boolean.class, Programme.class, Maree.class, Boolean.class};
    protected DataEntry[] data;
    protected Set<Integer> selected = new HashSet<Integer>();
    protected boolean selectAll;

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public int[] getSelected() {
        int[] result = new int[this.selected.size()];
        int i = 0;
        for (Integer index : this.selected) {
            result[i++] = index;
        }
        return result;
    }

    public boolean hasSelection() {
        return !this.selected.isEmpty();
    }

    public void init(DataEntry[] data) {
        this.data = data;
        this.selected.clear();
        this.setSelectAll(true);
    }

    public void clear() {
        this.data = null;
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_CLASSES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DataEntry p;
        Object value = null;
        DataEntry dataEntry = p = this.data == null ? null : this.data[rowIndex];
        if (p != null) {
            switch (columnIndex) {
                case 0: {
                    value = this.selected.contains(rowIndex);
                    break;
                }
                case 1: {
                    value = p.getProgramme();
                    break;
                }
                case 2: {
                    value = p.getMaree();
                    break;
                }
                case 3: {
                    value = p.isExist();
                    break;
                }
                default: {
                    throw new IllegalStateException("can not get value for row " + rowIndex + ", col " + columnIndex);
                }
            }
        }
        return value;
    }

    public Programme getProgrammeAt(int rowIndex) {
        return this.data[rowIndex].getProgramme();
    }

    public Maree getMareeAt(int rowIndex) {
        return this.data[rowIndex].getMaree();
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
        if (selectAll) {
            int max = this.getRowCount();
            for (int i = 0; i < max; ++i) {
                this.selected.add(i);
            }
        } else {
            this.selected.clear();
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            Boolean value = (Boolean)aValue;
            if (value.booleanValue()) {
                this.selected.add(rowIndex);
                if (this.selected.size() == this.getRowCount()) {
                    this.selectAll = true;
                }
            } else {
                this.selected.remove(rowIndex);
                if (this.selected.isEmpty()) {
                    this.selectAll = false;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
            return;
        }
    }

    public static class DataEntry {
        Programme programme;
        Maree maree;
        Boolean exist;

        public Boolean isExist() {
            return this.exist;
        }

        public void setExist(Boolean exist) {
            this.exist = exist;
        }

        public Maree getMaree() {
            return this.maree;
        }

        public void setMaree(Maree maree) {
            this.maree = maree;
        }

        public Programme getProgramme() {
            return this.programme;
        }

        public void setProgramme(Programme programme) {
            this.programme = programme;
        }
    }
}

