/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.ProgrammeUI;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityLoador;

public class ProgrammeHandler
extends ObserveContentHandler<Void, Programme, ProgrammeUI>
implements JAXXAction {
    private static Log log = LogFactory.getLog(ProgrammeHandler.class);

    public ProgrammeHandler() {
        super(null, null, null, new EntityLoador<Programme>(Programme.class, null, new String[]{"maree"}){
            private static final long serialVersionUID = 1L;

            public void load(Programme from, Programme dst, boolean tech) {
                super.load((TopiaEntity)from, (TopiaEntity)dst, tech);
                List marees = dst.getMaree();
                if (marees != null) {
                    dst.setMaree(new ArrayList(marees));
                }
            }
        });
    }

    public void addMaree(ProgrammeUI context) {
        NavigationTreeNode parentNode = this.getSelectedNode(context);
        NavigationTreeNode node = this.getTreeBuilder((JAXXContext)context).addMaree(parentNode, null);
        this.repaintNode((JAXXContext)context, parentNode, true);
        this.selectNode((JAXXContext)context, node);
    }

    public void gotoMaree(ProgrammeUI context, Maree selectedMaree) {
        if (selectedMaree == null) {
            return;
        }
        NavigationTreeNode parentNode = this.getSelectedNode(context);
        NavigationTreeNode node = parentNode.getChild(selectedMaree.getTopiaId());
        this.selectNode((JAXXContext)context, node);
    }

    @Override
    public void openUI(ProgrammeUI context) throws Exception {
        super.openUI(context);
        Programme programme = this.getData((JAXXContext)context, Programme.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        this.loador.load((Object)programme, (Object)context.getEditBean(), true);
        context.setMode(mode);
        context.setContentTitle(ObserveContext.getDecorator(Programme.class).toString((Object)programme));
    }

    @Override
    protected ObserveContentMode getObserveContentMode(ProgrammeUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        Programme programme = this.getData((JAXXContext)context, Programme.class);
        Maree openMaree = this.getDataContext((JAXXContext)context).getOpenMaree();
        if (mode == null) {
            if (openMaree == null) {
                mode = ObserveContentMode.CREATE;
                this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Programme.class), I18n._((String)"observe.message.no.active.maree.found"));
            } else if (programme.getOpenChild() != null) {
                mode = ObserveContentMode.UPDATE;
                this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Programme.class), I18n._((String)"observe.message.active.maree.found"));
            } else {
                mode = ObserveContentMode.READ;
                this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Programme.class), I18n._((String)"observe.message.active.maree.found.for.other.programme"));
            }
        }
        return mode;
    }
}

