/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaptureThon;
import fr.ird.observe.entities.referentiel.CategoriePoids;
import fr.ird.observe.entities.referentiel.EspeceThon;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.ObserveContentTableHandler;
import fr.ird.observe.ui.content.ObserveContentTableMeta;
import fr.ird.observe.ui.content.ObserveContentTableModel;
import fr.ird.observe.ui.content.ObserveContentTableUI;
import fr.ird.observe.ui.content.data.CaptureThonUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityListUpdator;
import org.nuiton.topia.persistence.util.EntityLoador;

public class CaptureThonHandler
extends ObserveContentTableHandler<Calee, CaptureThon, CaptureThonUI> {
    private static final Log log = LogFactory.getLog(CaptureThonHandler.class);
    JAXXContextEntryDef<List<EspeceThon>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"all-especes");
    JAXXContextEntryDef<List<CategoriePoids>> ALL_CATEGORIES_ENTRY = UIHelper.newListContextEntryDef((String)"all-categories");

    public CaptureThonHandler() {
        super("captureThon", Calee.class, CaptureThon.class, EntityLoador.newEntityLoador(Calee.class, (String[])new String[]{"captureThon"}), EntityLoador.newEntityLoador(CaptureThon.class, (String[])new String[]{"calee", "categoriePoids", "poids", "cuve", "surLePont", "rejete", "commentaire"}), EntityListUpdator.newEntityListUpdator(Calee.class, CaptureThon.class, (String)"captureThon"));
    }

    @Override
    public ObserveContentTableModel<Calee, CaptureThon> newTableModel(ObserveContentTableUI<Calee, CaptureThon> context) {
        ArrayList metas = new ArrayList();
        metas.add(new ObserveContentTableMeta<CaptureThon>(CaptureThon.class, "espece", true));
        metas.add(new ObserveContentTableMeta<CaptureThon>(CaptureThon.class, "categoriePoids", true));
        metas.add(new ObserveContentTableMeta<CaptureThon>(CaptureThon.class, "cuve", false));
        metas.add(new ObserveContentTableMeta<CaptureThon>(CaptureThon.class, "poids", false));
        metas.add(new ObserveContentTableMeta<CaptureThon>(CaptureThon.class, "commentaire", false));
        return new ObserveContentTableModel<Calee, CaptureThon>(context, metas);
    }

    @Override
    public void initUI(final CaptureThonUI context) throws Exception {
        super.initUI(context);
        context.getEspece().addPropertyChangeListener("selectedItem", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ObserveContentTableModel model = CaptureThonHandler.this.getTableModel(context);
                if (((CaptureThon)model.getRowBean()).getTopiaId() == null) {
                    EspeceThon espece = (EspeceThon)evt.getNewValue();
                    CaptureThonHandler.this.onEspeceChanged(context, model, espece);
                }
            }
        });
    }

    @Override
    protected Calee loadEditBean(CaptureThonUI ui, ObserveContentMode mode) {
        ObserveDataContext dataContext = this.getDataContext((JAXXContext)ui);
        HashSet<EspeceThon> availableEspeces = new HashSet<EspeceThon>();
        List categorieList = dataContext.getEntityList(CategoriePoids.class);
        for (CategoriePoids c : categorieList) {
            availableEspeces.add(c.getEspece());
        }
        ArrayList especeList = new ArrayList(availableEspeces);
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)ui, especeList);
        this.ALL_CATEGORIES_ENTRY.setContextValue((JAXXContext)ui, (Object)categorieList);
        ui.getEspece().setData(especeList);
        return (Calee)super.loadEditBean(ui, mode);
    }

    @Override
    protected Collection<CaptureThon> loadChilds(CaptureThonUI ui, Calee bean) {
        Collection childs = this.getChildsUpdator().getChilds((TopiaEntity)bean);
        ArrayList<CaptureThon> data = new ArrayList<CaptureThon>();
        if (childs != null && !childs.isEmpty()) {
            for (CaptureThon c : childs) {
                if (c.getRejete()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("rejetThon " + c.getEspece().getLibelle() + " non retenu."));
                    continue;
                }
                try {
                    CaptureThon c2 = (CaptureThon)this.newTableEditBean();
                    this.getChildLoador().load((TopiaEntity)c, (TopiaEntity)c2, true);
                    data.add(c2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return data;
    }

    @Override
    protected boolean prepareSave(CaptureThonUI context, Calee toSave, Calee editBean, List<CaptureThon> objets) {
        for (CaptureThon captureThon : objets) {
            captureThon.setCalee(toSave);
        }
        if (!toSave.isCaptureThonEmpty()) {
            for (CaptureThon captureThon : toSave.getCaptureThon()) {
                if (!captureThon.getRejete()) continue;
                objets.add(captureThon);
            }
        }
        return true;
    }

    @Override
    protected void onSelectedRowChanged(CaptureThonUI context, ObserveContentTableModel<Calee, CaptureThon> model, int editingRow, CaptureThon bean, boolean create) {
        NumberEditor requestFocus;
        EspeceThon beanEspece;
        CategoriePoids beanCategoriePoids = bean.getCategoriePoids();
        EspeceThon especeThon = beanEspece = beanCategoriePoids == null ? null : beanCategoriePoids.getEspece();
        if (create) {
            context.getEspece().setSelectedItem(null);
            if (!model.isCreate()) {
                context.getEspece().setSelectedItem((Object)beanEspece);
                context.getCategoriePoids().setSelectedItem((Object)beanCategoriePoids);
            }
            requestFocus = context.getEspece();
        } else {
            context.getEspece().setSelectedItem((Object)beanEspece);
            context.getCategoriePoids().setData(Arrays.asList(beanCategoriePoids));
            context.getCategoriePoids().setSelectedItem((Object)beanCategoriePoids);
            requestFocus = context.getPoids();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected categoriePoid " + beanCategoriePoids));
            log.debug((Object)("selected espece " + beanEspece));
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(CaptureThonUI context, DefaultTableCellRenderer renderer) {
        JTable table = context.getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)2, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)50);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)50);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.captureThon.especeThon"), I18n.n_((String)"observe.table.captureThon.especeThon.tip"), I18n.n_((String)"observe.table.captureThon.categoriePoids"), I18n.n_((String)"observe.table.captureThon.categoriePoids.tip"), I18n.n_((String)"observe.table.captureThon.cuve"), I18n.n_((String)"observe.table.captureThon.cuve.tip"), I18n.n_((String)"observe.table.captureThon.poids"), I18n.n_((String)"observe.table.captureThon.poids.tip"), I18n.n_((String)"observe.table.captureThon.commentaire"), I18n.n_((String)"observe.table.captureThon.commentaire.tip")});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceThon.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, CategoriePoids.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)renderer);
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    protected void onEspeceChanged(CaptureThonUI context, ObserveContentTableModel<Calee, CaptureThon> model, EspeceThon espece) {
        List<CategoriePoids> availableCategories;
        if (espece == null) {
            availableCategories = Collections.EMPTY_LIST;
        } else {
            availableCategories = this.getAllCategories((JAXXContext)context);
            Iterator<CategoriePoids> it = availableCategories.iterator();
            while (it.hasNext()) {
                CategoriePoids poidse = it.next();
                if (espece.equals(poidse.getEspece())) continue;
                it.remove();
            }
        }
        context.getCategoriePoids().setData(availableCategories);
        context.getCategoriePoids().setSelectedItem(null);
    }

    protected List<CategoriePoids> getAllCategories(JAXXContext context) {
        ArrayList<CategoriePoids> list = new ArrayList<CategoriePoids>((Collection)this.ALL_CATEGORIES_ENTRY.getContextValue(context));
        return list;
    }
}

