/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveTreeCellRenderer;
import fr.ird.observe.ui.ObserveTreeHelper;
import fr.ird.observe.ui.ObserveTreeModelBuilder;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContent;
import fr.ird.observe.ui.content.ObserveContentActions;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.ObserveContentUI;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JList;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.Util;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.TimeEditor;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.Creator;
import org.nuiton.topia.persistence.util.Deletor;
import org.nuiton.topia.persistence.util.Loador;

public class ObserveContentHandler<P, E extends TopiaEntity, UI extends ObserveContentUI<E>>
implements JAXXAction {
    protected Creator<P, E> preCreator;
    protected Creator<P, E> creator;
    protected Deletor<P, E> deletator;
    protected Loador<E> loador;
    private static final Log log = LogFactory.getLog(ObserveContentHandler.class);

    public ObserveContentHandler() {
        this(null, null, null, null);
    }

    public ObserveContentHandler(Creator<P, E> preCreator, Creator<P, E> creator, Deletor<P, E> deletator, Loador<E> loador) {
        this.preCreator = preCreator;
        this.creator = creator;
        this.deletator = deletator;
        this.loador = loador;
    }

    public JAXXInitialContext init(JAXXContext parentContext, Object ... datas) {
        return new JAXXInitialContext().add((Object)parentContext).add((Object)this);
    }

    public void addMessage(ObserveContent<?> ui, BeanValidatorScope scope, String fieldName, String message) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.addMessages((JComponent)((Object)ui), fieldName, scope, new String[]{message});
    }

    public void removeAllMessages(ObserveContent<?> ui, BeanValidatorScope scope, String fieldName) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.removeMessages((JComponent)((Object)ui), fieldName, scope);
    }

    public void removeAllMessages(ObserveContent<?> ui) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.removeMessages((JComponent)((Object)ui), null);
    }

    protected ObserveDataContext getDataContext(JAXXContext context) {
        return (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
    }

    protected <E extends TopiaEntity> E getData(JAXXContext context, Class<E> entityClass) {
        return (E)((ObserveDataContext)context.getContextValue(ObserveDataContext.class)).getEntity(entityClass);
    }

    public ObserveTreeHelper getTreeHelper(JAXXContext context) {
        return (ObserveTreeHelper)((Object)context.getContextValue(ObserveTreeHelper.class));
    }

    public ObserveTreeModelBuilder getTreeBuilder(JAXXContext context) {
        return this.getTreeHelper(context).getBuilder();
    }

    public void initUI(UI ui) throws Exception {
        if (ObserveContentUI.log.isDebugEnabled()) {
            ObserveContentUI.log.debug((Object)("ui " + this.getClass()));
        }
        ObserveMainUI mainUI = ((ObserveContentUI)ui).getParentContainer(ObserveMainUI.class);
        ActionMap actionMap = mainUI.getRootPane().getActionMap();
        StorageService<?> service = this.getStorageService((JAXXContext)ui);
        for (String name : ((ObserveContentUI)ui).get$objectMap().keySet()) {
            Object o = ((ObserveContentUI)ui).getObjectById(name);
            if (o == null) continue;
            if (o instanceof TopiaEntity) {
                this.init(service, ui, (TopiaEntity)o);
                continue;
            }
            if (o instanceof AbstractButton) {
                this.init(service, ui, mainUI, actionMap, (AbstractButton)o);
                continue;
            }
            if (o instanceof NumberEditor) {
                this.init(service, ui, (NumberEditor)o);
                continue;
            }
            if (o instanceof EntityComboBox) {
                this.init(service, ui, (EntityComboBox)o);
                continue;
            }
            if (o instanceof JList) {
                this.init(service, ui, (JList)o);
                continue;
            }
            if (o instanceof JXDatePicker) {
                this.init(service, ui, (JXDatePicker)o);
                continue;
            }
            if (!(o instanceof TimeEditor)) continue;
            this.init(service, ui, (TimeEditor)o);
        }
    }

    public void openUI(UI ui) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ui " + ui.getClass()));
        }
        ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.setContextValue((JAXXContext)ObserveContext.get(), ui);
        ObserveTreeHelper treeHelper = this.getTreeHelper((JAXXContext)ui);
        ObserveTreeCellRenderer render = treeHelper.getTreeCellRenderer((JAXXContext)ui);
        NavigationTreeNode node = treeHelper.getSelectedNode((JAXXContext)ui);
        ((ObserveContentUI)ui).setContentIcon(render.getIcon(node));
        this.updateActions(ui);
    }

    public void startEditUI(UI ui, E o, E editBean, String ... binding) {
        BeanValidatorUtil.setValidatorBean(ui, null, (String[])new String[0]);
        ((ObserveContentUI)ui).setEditing(true);
        if (o != null) {
            ((ObserveContentUI)ui).setContextValue(o, "edit");
        }
        BeanValidatorUtil.setValidatorBean(ui, editBean, (String[])new String[0]);
        if (binding.length > 0) {
            Util.processDataBinding(ui, (String[])binding);
        }
        Util.processDataBinding(ui, (String[])new String[]{"reset.enabled", "save.enabled"});
    }

    public final void resetEditUI(UI context) {
        this.stopEditUI(context);
        this.removeAllMessages((ObserveContent<?>)context);
        try {
            this.openUI(context);
        }
        catch (Exception ex) {
            ErrorDialogUI.showError((Exception)ex);
            log.error((Object)ex.getMessage(), (Throwable)ex);
            this.stopEditUI(context);
        }
    }

    public void restartEditUI(UI context) {
        if (((ObserveContentUI)context).isEditable().booleanValue()) {
            NavigationTreeNode node = this.getSelectedNode((ObserveContent<?>)context);
            this.removeAllMessages((ObserveContent<?>)context);
            this.repaintNode((JAXXContext)context, node, true);
            ((ObserveContentUI)context).setMode(ObserveContentMode.UPDATE);
            TopiaEntity b = (TopiaEntity)node.getBean(context);
            ((ObserveContentUI)context).startEdit((TopiaEntity)b);
            this.updateActions(context);
        }
    }

    public void stopEditUI(UI ui) {
        ((ObserveContentUI)ui).setEditing(false);
        ((ObserveContentUI)ui).setEditionValid(true);
        ((ObserveContentUI)ui).setModified(false);
        ((ObserveContentUI)ui).removeContextValue(((ObserveContentUI)ui).getInternalClass(), "edit");
        BeanValidatorUtil.setValidatorBean(ui, null, (String[])new String[0]);
    }

    public boolean closeUI(UI ui) throws Exception {
        boolean b = ObserveContentHandler.checkEdit(ui);
        if (b) {
            ObserveTreeHelper treehelper;
            NavigationTreeNode node;
            this.removeAllMessages((ObserveContent<?>)ui);
            ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.removeContextValue((JAXXContext)ObserveContext.get());
            boolean create = ((ObserveContentUI)ui).isCreatingMode();
            if (create && ((ObserveContentUI)ui).isEditable().booleanValue() && (node = (treehelper = ((ObserveContentUI)ui).getContextValue(ObserveTreeHelper.class)).getSelectedNode((JAXXContext)ui)).getParent() != null) {
                treehelper.getBuilder().removeChildNode(node);
            }
        }
        return b;
    }

    protected NavigationTreeNode getSelectedNode(ObserveContent<?> context) {
        ObserveTreeHelper treehelper = this.getTreeHelper((JAXXContext)context);
        return treehelper.getSelectedNode((JAXXContext)context);
    }

    public void selectNode(JAXXContext context, NavigationTreeNode node) {
        ObserveTreeHelper treeBuilder = this.getTreeHelper(context);
        treeBuilder.selectNode(context, node);
    }

    public void repaintNode(JAXXContext context, NavigationTreeNode node, boolean deep) {
        ObserveTreeHelper treeBuilder = this.getTreeHelper(context);
        treeBuilder.repaintNode(context, node, deep);
    }

    public void repaintNode(JAXXContext context, NavigationTreeNode node) {
        ObserveTreeHelper treeBuilder = this.getTreeHelper(context);
        treeBuilder.repaintNode(context, node);
    }

    protected String getEntityLabel(Class<?> klass) {
        String result = null;
        if (TopiaEntity.class.isAssignableFrom(klass)) {
            result = DBHelper.getEntityLabel(klass);
        }
        return result;
    }

    protected void closeOpenable(UI context, Openable bean, String message) {
        ((ObserveContentUI)context).stopEdit();
        ((ObserveContentUI)context).setMode(ObserveContentMode.READ);
        this.removeAllMessages((ObserveContent<?>)context);
        this.addMessage((ObserveContent<?>)context, BeanValidatorScope.INFO, this.getEntityLabel(bean.getClass()), message);
        this.repaintNode((JAXXContext)context, this.getSelectedNode((ObserveContent<?>)context), true);
        this.updateActions(context);
    }

    protected void closeOpenable(Openable o) {
        o.setOpen(false);
        Openable openChild = o.getOpenChild();
        if (openChild != null) {
            this.closeOpenable(openChild);
        }
    }

    public void createUI(UI context) {
    }

    public void modifyUI(UI context) {
    }

    public void saveUI(UI context, boolean refresh) {
    }

    public void deleteUI(UI context) {
    }

    public void openOpenable(UI context) {
    }

    public void closeOpenable(UI context) {
    }

    public static boolean checkEdit(ObserveContent<?> content) {
        if (!(content.isEnabled() && content.isEditing().booleanValue() && content.isModified().booleanValue())) {
            if (content.isEditing().booleanValue()) {
                content.stopEdit();
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"previousUI is in edit mode");
        }
        boolean wasClosed = true;
        if (content.isEditionValid().booleanValue()) {
            int reponse = UIHelper.askUser((Component)((Object)content), I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.quit.valid.edit"), 2, new Object[]{I18n._((String)"observe.choice.save"), I18n._((String)"observe.choice.doNotSave"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 2: {
                    wasClosed = false;
                    break;
                }
                case 0: {
                    content.save(false);
                    break;
                }
                case 1: {
                    content.resetEdit();
                }
            }
        } else {
            int reponse = UIHelper.askUser((Component)((Object)content), I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.quit.invalid.edit"), 0, new Object[]{I18n._((String)"observe.choice.continue"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 1: {
                    wasClosed = false;
                    break;
                }
                case 0: {
                    content.resetEdit();
                }
            }
        }
        if (wasClosed) {
            content.stopEdit();
        }
        return wasClosed;
    }

    public StorageService<?> getStorageService(JAXXContext context) {
        ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
        return dataContext.getStorage();
    }

    protected void attachTopiaContext(StorageService<?> service, TopiaEntityAbstract entity) {
        DBHelper.attachTopiaContext((TopiaContext)service.getCtxt(), (TopiaEntityAbstract)entity);
    }

    protected void updateActions(UI ui) {
        ObserveMainUI mainUI = ((ObserveContentUI)ui).getParentContainer(ObserveMainUI.class);
        for (ObserveContentActions actionDef : ObserveContentActions.values()) {
            AbstractButton upButton = (AbstractButton)((ObserveContentUI)ui).getObjectById(actionDef.name());
            if (upButton == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("update action " + (Object)((Object)actionDef)));
            }
            actionDef.updateAction(mainUI, (ObserveContentUI<?>)ui, upButton);
        }
    }

    protected void init(StorageService<?> service, UI ui, TopiaEntity entity) throws StorageServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init entity " + entity.getClass()));
        }
        this.attachTopiaContext(service, (TopiaEntityAbstract)entity);
    }

    protected void init(StorageService<?> service, UI ui, ObserveMainUI mainUI, ActionMap actionMap, AbstractButton editor) throws StorageServiceException {
        String id = editor.getName();
        if (!ObserveContentActions.accept(id)) {
            return;
        }
        ObserveContentActions actionDef = ObserveContentActions.valueOf(id);
        Action action = actionMap.get((Object)actionDef);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init common action " + (Object)((Object)actionDef)));
        }
        actionDef.initAction(mainUI, (ObserveContentUI<?>)ui, editor, action);
    }

    protected void init(StorageService<?> service, UI ui, NumberEditor editor) throws StorageServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init number editor " + editor.getName()));
        }
        editor.init();
    }

    protected void init(StorageService<?> service, UI ui, EntityComboBox entityComboBox) throws StorageServiceException {
        Class klass = entityComboBox.getHandler().getTargetClass();
        if (log.isDebugEnabled()) {
            log.debug((Object)("init combobox for " + klass));
        }
        entityComboBox.setI18nPrefix("observe.common.");
        UIHelper.prepareEntityComboBox(service, klass, entityComboBox);
    }

    protected void init(StorageService<?> service, UI ui, JList jlist) throws StorageServiceException {
        Class klass;
        Object init = jlist.getClientProperty("doInit");
        if (init != null) {
            klass = (Class)init;
            if (log.isDebugEnabled()) {
                log.debug((Object)("init list for " + klass));
            }
            UIHelper.prepareEntityList(service, klass, jlist);
        }
        if ((init = jlist.getClientProperty("addDecorator")) != null) {
            klass = (Class)init;
            if (log.isDebugEnabled()) {
                log.debug((Object)("addToogleListSelectionModel to list " + jlist.getName()));
            }
            Decorator decorator = ObserveContext.getDecorator(klass);
            jlist.putClientProperty("decorator", decorator);
            jlist.setCellRenderer(new DecoratorListCellRenderer(decorator));
        }
        if ((init = jlist.getClientProperty("addToogleListSelectionModel")) != null && init instanceof Boolean && ((Boolean)init).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addToogleListSelectionModel to list " + jlist.getName()));
            }
            UIHelper.prepareToogleListSelectionModel(jlist);
        }
    }

    protected void init(StorageService<?> service, UI ui, TimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init time editor " + editor.getName() + " for property " + editor.getProperty()));
        }
        editor.init();
    }

    protected void init(StorageService<?> service, UI ui, JXDatePicker picker) {
        log.debug((Object)("disable JXDatePicker editor" + picker.getName()));
        picker.getEditor().setEditable(false);
    }

    protected ObserveContentMode getObserveContentMode(UI context) {
        ObserveContentMode mode = null;
        if (!this.canWriteData(context)) {
            this.addMessage((ObserveContent<?>)context, BeanValidatorScope.INFO, this.getEntityLabel(((ObserveContentUI)context).getInternalClass()), I18n._((String)"observe.message.can.not.write.data"));
            mode = ObserveContentMode.READ;
        }
        return mode;
    }

    protected boolean canWriteData(UI context) {
        return this.getDataContext((JAXXContext)context).getStorage().canWriteData();
    }
}

