/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveTreeCellRenderer;
import fr.ird.observe.ui.ObserveTreeModelBuilder;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContent;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.DataContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeHandler;
import jaxx.runtime.swing.navigation.NavigationTreeHandlerWithCardLayout;
import jaxx.runtime.swing.navigation.NavigationTreeHelper;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public class ObserveTreeHelper
extends NavigationTreeHelper {
    private static final Log log = LogFactory.getLog(ObserveTreeHelper.class);
    protected ObserveTreeModelBuilder builder;

    public ObserveTreeHelper() {
        super("navigation");
    }

    public ObserveTreeModelBuilder getBuilder() {
        return this.builder;
    }

    public NavigationTreeModel createTreeModel(JAXXContext context) {
        if (this.builder == null) {
            this.builder = new ObserveTreeModelBuilder(context);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("create tree model " + (Object)((Object)this)));
        }
        List programmes = null;
        try {
            ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
            programmes = dataContext.getEntityList(Programme.class);
            this.builder.createInitialModel(programmes);
        }
        catch (IllegalArgumentException e) {
            this.builder.createEmptyModel();
        }
        NavigationTreeModel model = this.builder.getModel();
        if (log.isDebugEnabled()) {
            this.builder.printModel(model.getRoot());
        }
        this.setTreeModel(context, model);
        return model;
    }

    public ObserveTreeCellRenderer getTreeCellRenderer(JAXXContext context) {
        JTree t = this.getTree(context);
        TreeCellRenderer r = t.getCellRenderer();
        return (ObserveTreeCellRenderer)(r instanceof ObserveTreeCellRenderer ? r : null);
    }

    public void selectOpenNode(JAXXContext context, Class<? extends TopiaEntity> type) {
        ObserveDataContext.ObserveDataContextEntry entry;
        ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
        Openable openData = (Openable)dataContext.getOpenData(entry = dataContext.getEntry(type));
        if (openData == null) {
            return;
        }
        ArrayList<TopiaEntity> datas = new ArrayList<TopiaEntity>();
        for (ObserveDataContext.ObserveDataContextEntry e : dataContext.iterateToLevel(entry.getLevel())) {
            Openable data = (Openable)dataContext.getOpenData(e);
            if (data == null) continue;
            datas.add((TopiaEntity)data);
        }
        String path = entry.getContextPath(datas.toArray());
        NavigationTreeNode node = this.findNode(context, path, entry.getPattern());
        this.selectNode(context, node);
    }

    public void selectInitialNode(ObserveMainUI ui) {
        String path;
        ObserveDataContext dataContext = ui.getDataContext();
        Programme programme = dataContext.getOpenProgramme();
        Maree maree = dataContext.getOpenMaree();
        if (maree != null && programme != null) {
            path = dataContext.getContextPath(new Object[]{programme});
        } else {
            NavigationTreeNode node = this.findNode((JAXXContext)ui, "$root");
            if (!node.isLeaf()) {
                node = node.getChildAt(0);
            }
            path = node.getFullPath();
        }
        this.selectNode((JAXXContext)ui, path);
        ui.getNavigation().requestFocus();
    }

    public void cleanNavigationUI(ObserveMainUI mainUI) {
        mainUI.getContentLayout().reset((Container)mainUI.getContent());
        mainUI.getContextValue(SwingValidatorMessageTableModel.class).clear();
        NavigationTreeModel treeModel = this.getSafeTreeModel((JAXXContext)mainUI);
        NavigationTreeNode root = treeModel.getRoot();
        root.removeAllChildren();
        treeModel.nodeStructureChanged((TreeNode)root);
        mainUI.getNavigation().setVisible(false);
    }

    public void loadNavigationUI(ObserveMainUI mainUI) {
        NavigationTreeModel model = this.createTreeModel((JAXXContext)mainUI);
        model.nodeStructureChanged((TreeNode)model.getRoot());
        this.selectInitialNode(mainUI);
        mainUI.getNavigation().setVisible(true);
    }

    public NavigationTreeHandler createTreeHandler(JAXXObject context) {
        NavigationTreeHandlerWithCardLayout handler = new NavigationTreeHandlerWithCardLayout(this.getPrefix(), context, NavigationTreeHandler.Strategy.PER_UI_TYPE){
            private static final long serialVersionUID = 1L;

            protected NavigationTreeModel getNavigationTreeModel() {
                return ObserveTreeHelper.this.getSafeTreeModel((JAXXContext)this.getContext());
            }

            protected JPanel getContentContainer() {
                return this.getContext().getContent();
            }

            protected CardLayout2 getContentLayout() {
                return this.getContext().getContentLayout();
            }

            public ObserveMainUI getContext() {
                return (ObserveMainUI)this.context;
            }

            protected JTree getNavigationTree() {
                return this.getContext().getNavigation();
            }

            protected Component createUI(NavigationTreeNode node) throws Exception {
                Component component = super.createUI(node);
                if (component != null && component instanceof ObserveContent) {
                    ((ObserveContent)((Object)component)).init();
                }
                return component;
            }

            protected boolean closeUI(Component component) throws Exception {
                return component == null || !(component instanceof ObserveContent) || ((ObserveContent)((Object)component)).close();
            }

            protected void openUI(final Component newUI, NavigationTreeNode node) throws Exception {
                if (newUI != null && newUI instanceof ObserveContent) {
                    ((ObserveContent)((Object)newUI)).open();
                }
                super.openUI(newUI, node);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.getContentLayout().invalidateLayout((Container)this.getContentContainer());
                        ((JComponent)newUI).revalidate();
                    }
                });
                if (!node.isLeaf()) {
                    TreePath path = new TreePath(this.getNavigationTreeModel().getPathToRoot((TreeNode)node));
                    if (!this.getNavigationTree().isExpanded(path)) {
                        this.getNavigationTree().expandPath(path);
                    }
                }
            }

            protected void addSelectedBeanInContext(NavigationTreeNode node, Object data) {
                Object userObject = node.getUserObject();
                String label = userObject.toString();
                UIHelper.displayInfo(this.context, I18n._((String)"observe.message.loading.node", (Object[])new Object[]{label}));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"---------------------------------------------------------------------------------------------------------");
                    log.debug((Object)("contextPath <" + node.getFullPath() + ">"));
                    log.debug((Object)("data        <" + (data == null ? null : data.getClass()) + ">"));
                }
                ObserveDataContext dataContext = this.getContext().getContextValue(ObserveDataContext.class);
                dataContext.updateSelectedData(node.getFullPath(), data, (DataContext.UpdateDataContext)new DataContext.UpdateDataContext<ObserveDataContext>(){

                    public void onAddingData(ObserveDataContext context, DataContext.DataContextEntry entry, String path) {
                        NavigationTreeNode node = ObserveTreeHelper.this.findNode((JAXXContext)this.getContext(), path, entry.getPattern(), null);
                        if (node != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("node path      <" + node.getFullPath() + ">"));
                                log.debug((Object)("entry          " + entry));
                            }
                            context.setContextValue(entry, (Object)node, "node");
                            Object bean = node.getBean((JAXXContext)context.getDelegate());
                            if (bean != null) {
                                context.getDelegate().setContextValue(bean);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("data           <" + bean.getClass().getName() + ">"));
                                }
                            } else if (log.isDebugEnabled()) {
                                log.debug((Object)"data           <null>");
                            }
                        }
                    }

                    public void onRemovingData(ObserveDataContext context, DataContext.DataContextEntry<ObserveDataContext> entry) {
                        Object oldBean;
                        context.removeContextValue(entry, NavigationTreeNode.class, "node");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("entry          " + entry));
                        }
                        if ((oldBean = context.getContextValue(entry, null)) != null) {
                            context.removeContextValue(entry, oldBean, null);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("data           <" + oldBean.getClass().getName() + ">"));
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)"data           <null>");
                        }
                    }
                });
                if (log.isDebugEnabled()) {
                    log.debug((Object)("new scope   <" + dataContext.getCurrentEntry() + ">"));
                    log.debug((Object)("new data    <" + (data == null ? null : data.getClass().getName()) + ">"));
                }
                if (data != null) {
                    this.context.setContextValue(data);
                }
            }

            protected void treateError(Exception e) {
                ErrorDialogUI.showError((Exception)e);
            }
        };
        handler.setSelectionMode(1);
        this.setTreeHandler((JAXXContext)context, (NavigationTreeHandler)handler);
        return handler;
    }
}

