/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.ui.content.data.ActiviteUI;
import fr.ird.observe.ui.content.data.CaleeUI;
import fr.ird.observe.ui.content.data.CaptureFauneUI;
import fr.ird.observe.ui.content.data.CaptureThonUI;
import fr.ird.observe.ui.content.data.EchantillonFauneUI;
import fr.ird.observe.ui.content.data.EchantillonThonUI;
import fr.ird.observe.ui.content.data.EspeceFauneObserveeUI;
import fr.ird.observe.ui.content.data.EstimationBancObjetUI;
import fr.ird.observe.ui.content.data.EstimationBancUI;
import fr.ird.observe.ui.content.data.MareeUI;
import fr.ird.observe.ui.content.data.ObjetFlottantUI;
import fr.ird.observe.ui.content.data.OperationBaliseUI;
import fr.ird.observe.ui.content.data.RejetThonUI;
import fr.ird.observe.ui.content.data.RouteUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.swing.navigation.NavigationTreeNodeRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public class ObserveTreeCellRenderer
implements TreeCellRenderer {
    private static final Log log = LogFactory.getLog(ObserveTreeCellRenderer.class);
    public static final List<Class<?>> CREATION_UI = Collections.unmodifiableList(Arrays.asList(MareeUI.class, RouteUI.class, ActiviteUI.class, ObjetFlottantUI.class, CaleeUI.class));
    protected DefaultTreeCellRenderer delegate;
    protected Color normalColor;
    protected Color openColor;
    protected Color redColor;

    public ObserveTreeCellRenderer() {
        this(new DefaultTreeCellRenderer());
    }

    public ObserveTreeCellRenderer(DefaultTreeCellRenderer delegate) {
        this.delegate = delegate;
        this.normalColor = Color.LIGHT_GRAY;
        this.redColor = Color.RED;
        this.openColor = delegate.getForeground();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(tree.getModel() instanceof NavigationTreeModel)) {
            return this.delegate.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
        NavigationTreeNode node = this.getNode(value);
        this.setIcon(node);
        if (!sel) {
            NavigationTreeModel model = (NavigationTreeModel)tree.getModel();
            Color color = this.getTextColor(model, node);
            this.delegate.setTextNonSelectionColor(color);
        }
        String text = this.getText(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)(text + " for node " + node.getFullPath()));
        }
        Component comp = this.delegate.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        ((JComponent)comp).setToolTipText(text);
        return comp;
    }

    protected NavigationTreeNode getNode(Object value) {
        return value instanceof NavigationTreeNode ? (NavigationTreeNode)value : null;
    }

    public String getText(NavigationTreeNode node) {
        NavigationTreeNodeRenderer renderer = node.getRenderer();
        String text = renderer.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)(text + " for node " + node.getFullPath()));
        }
        return text;
    }

    public Icon getIcon(NavigationTreeNode node) {
        Icon icon = this.getIcon(node, null);
        return icon;
    }

    public Icon getIcon(NavigationTreeNode node, String suffix) {
        Icon icon = null;
        if (suffix == null) {
            suffix = "";
        }
        if (node != null) {
            String contextPath = node.getFullPath();
            if (contextPath.equals("$root/referentiel")) {
                icon = UIManager.getIcon("navigation.referentiel" + suffix);
            } else if (contextPath.startsWith("$root/referentiel/")) {
                icon = UIManager.getIcon("navigation.sub.referentiel" + suffix);
            }
            if (icon == null) {
                icon = UIManager.getIcon("navigation." + node.getInternalClass().getName() + suffix);
            }
        }
        return icon;
    }

    public void setIcon(NavigationTreeNode node) {
        Icon icon = this.getIcon(node);
        this.setDefaultIcons(icon);
    }

    public void setDefaultIcons(Icon icon) {
        if (icon == null) {
            this.delegate.setOpenIcon(this.delegate.getDefaultOpenIcon());
            this.delegate.setClosedIcon(this.delegate.getDefaultClosedIcon());
            this.delegate.setLeafIcon(this.delegate.getDefaultLeafIcon());
        } else {
            this.delegate.setOpenIcon(icon);
            this.delegate.setClosedIcon(icon);
            this.delegate.setLeafIcon(icon);
        }
    }

    public Color getTextColor(NavigationTreeModel model, NavigationTreeNode node) {
        Object bean;
        String contextPath = node.getFullPath();
        if (node.isRoot() || contextPath.startsWith("$root/referentiel") || contextPath.startsWith("$root/nodb")) {
            return this.openColor;
        }
        boolean nodeIsOpen = false;
        NavigationTreeNode openableNode = this.getFirstOpenableNode(node);
        if (log.isDebugEnabled()) {
            log.debug((Object)("openable node " + openableNode.getPath() + " for " + node.getPath()));
        }
        if (!((bean = model.getBean(openableNode)) instanceof Openable) && (openableNode = openableNode.getParent()) != null) {
            bean = model.getBean(openableNode);
        }
        if (bean instanceof Openable) {
            Openable openBean = (Openable)bean;
            nodeIsOpen = openBean.isOpen();
        }
        if (!nodeIsOpen) {
            return this.normalColor;
        }
        Class contentClass = node.getUIClass();
        if (CREATION_UI.contains(contentClass)) {
            TopiaEntity t = null;
            try {
                t = (TopiaEntity)model.getBean(node);
                if (t.getTopiaId() == null) {
                    return this.redColor;
                }
            }
            catch (Exception e) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (contentClass == OperationBaliseUI.class) {
            ObjetFlottant c = (ObjetFlottant)model.getBean(node);
            if (c.isBaliseLueEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (contentClass == EstimationBancObjetUI.class) {
            ObjetFlottant c = (ObjetFlottant)model.getBean(node);
            if (c.isEstimationBancObjetEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (contentClass == EspeceFauneObserveeUI.class) {
            ObjetFlottant c = (ObjetFlottant)model.getBean(node);
            if (c.isEspeceFauneObserveeEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (contentClass == EstimationBancUI.class) {
            Calee c = (Calee)model.getBean(node);
            if (c.isEstimationBancEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (contentClass == CaptureThonUI.class) {
            Calee c = (Calee)model.getBean(node);
            if (!c.hasCaptureThon()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (contentClass == RejetThonUI.class) {
            Calee c = (Calee)model.getBean(node);
            if (!c.hasRejetThon()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (contentClass == EchantillonThonUI.class) {
            EchantillonThon c = (EchantillonThon)model.getBean(node);
            if (c.isTailleThonEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (contentClass == CaptureFauneUI.class) {
            Calee c = (Calee)model.getBean(node);
            if (c.isCaptureFauneEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        if (contentClass == EchantillonFauneUI.class) {
            EchantillonFaune c = (EchantillonFaune)model.getBean(node);
            if (c.isTailleFauneEmpty()) {
                return this.redColor;
            }
            return this.openColor;
        }
        return this.openColor;
    }

    public NavigationTreeNode getFirstOpenableNode(NavigationTreeNode node) {
        if (Openable.class.isAssignableFrom(node.getInternalClass())) {
            return node;
        }
        return this.getFirstOpenableNode(node.getParent());
    }
}

