/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.ObserveDecoratorProvider;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceAdapter;
import fr.ird.observe.storage.StorageServiceEvent;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.storage.StorageServiceFactory;
import fr.ird.observe.storage.StorageServiceListener;
import fr.ird.observe.storage.impl.H2StorageConfig;
import fr.ird.observe.storage.impl.H2StorageService;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveTreeHelper;
import fr.ird.observe.ui.ObserveUIMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContent;
import java.io.IOException;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.Util;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ObserveContext
extends DefaultApplicationContext {
    private static Log log = LogFactory.getLog(ObserveContext.class);
    public static final JAXXContextEntryDef<ObserveMainUI> MAIN_UI_ENTRY_DEF = Util.newContextEntryDef((String)"mainui", ObserveMainUI.class);
    public static final JAXXContextEntryDef<ObserveContent> SELECTED_CONTENT_UI_ENTRY_DEF = Util.newContextEntryDef((String)"selected-content-ui", ObserveContent.class);
    protected static ObserveContext instance;
    protected final Object lock = new Object();

    public static boolean isInit() {
        return instance != null;
    }

    public static synchronized ObserveContext init() throws IllegalStateException {
        if (ObserveContext.isInit()) {
            throw new IllegalStateException("there is an already application context registred.");
        }
        instance = new ObserveContext();
        return instance;
    }

    public static ObserveContext get() throws IllegalStateException {
        if (!ObserveContext.isInit()) {
            throw new IllegalStateException("no application context registred.");
        }
        return instance;
    }

    public static <O> Decorator<O> getDecorator(Class<O> clazz) {
        ObserveContext c = ObserveContext.get();
        ObserveDecoratorProvider provider = (ObserveDecoratorProvider)c.getContextValue(ObserveDecoratorProvider.class);
        Decorator value = provider.getDecorator(clazz);
        return value;
    }

    public static <O> Decorator<O> getDecorator(Class<O> clazz, String name) {
        ObserveContext c = ObserveContext.get();
        ObserveDecoratorProvider provider = (ObserveDecoratorProvider)c.getContextValue(ObserveDecoratorProvider.class);
        Decorator value = provider.getDecorator(clazz, name);
        return value;
    }

    protected ObserveContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void close() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing context " + (Object)((Object)this)));
        }
        ((ObserveDataContext)this.getContextValue(ObserveDataContext.class)).close();
        StorageServiceFactory.dispose();
        this.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("context closed" + (Object)((Object)this)));
        }
    }

    public H2StorageService newLocalStorageService() throws StorageServiceException, IOException, IllegalStateException {
        ObserveConfig config = (ObserveConfig)((Object)this.getContextValue(ObserveConfig.class));
        H2StorageConfig c = config.toH2StorageConfig(I18n.n_((String)"observe.storage.label.local"));
        c.init();
        if (!c.isStorageExists()) {
            throw new IllegalStateException("local base must exist, when using this method (" + c.getStorageDirectory() + ")");
        }
        H2StorageService service = StorageServiceFactory.newService((H2StorageConfig)c);
        return service;
    }

    public boolean isLocalStorageExists() throws IOException {
        ObserveConfig config = (ObserveConfig)((Object)this.getContextValue(ObserveConfig.class));
        H2StorageConfig c = config.toH2StorageConfig(I18n.n_((String)"observe.storage.label.local"));
        c.init();
        boolean dbExists = c.isStorageExists();
        return dbExists;
    }

    public boolean isInitialDbExists() throws IOException {
        ObserveConfig config = (ObserveConfig)((Object)this.getContextValue(ObserveConfig.class));
        boolean dbExists = config.getInitialDbDump().exists();
        return dbExists;
    }

    public void prepareMainStorage(StorageService<?> service) {
        service.getConfig().setUseCache(true);
        service.addStorageServiceListener((StorageServiceListener)new StorageServiceAdapter(){

            public void onOpening(StorageServiceEvent event) {
                StorageService s = event.getSource();
                UIHelper.displayInfo((JAXXContext)ObserveContext.this, I18n._((String)"observe.message.db.loading", (Object[])new Object[]{s.getLabel()}));
            }

            public void onOpened(StorageServiceEvent event) {
                ObserveMainUI mainUI;
                StorageService s = event.getSource();
                ObserveDataContext dataContext = (ObserveDataContext)ObserveContext.this.getContextValue(ObserveDataContext.class);
                dataContext.installStorage(s);
                ((ObserveConfig)((Object)ObserveContext.this.getContextValue(ObserveConfig.class))).setMainStorageOpened(true);
                ((ObserveConfig)((Object)ObserveContext.this.getContextValue(ObserveConfig.class))).setMainStorageOpenedLocal(s instanceof H2StorageService);
                if (s instanceof H2StorageService) {
                    ((ObserveConfig)((Object)ObserveContext.this.getContextValue(ObserveConfig.class))).setLocalStorageExist(true);
                }
                if ((mainUI = (ObserveMainUI)MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)ObserveContext.this)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("loading ui for storage " + s.getLabel() + ": " + mainUI.getName()));
                    }
                    ObserveTreeHelper treeHelper = mainUI.getTreeHelper();
                    treeHelper.cleanNavigationUI(mainUI);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("tree helper to use : " + (Object)((Object)treeHelper)));
                    }
                    treeHelper.loadNavigationUI(mainUI);
                    if (ObserveUIMode.NO_DB.equals((Object)mainUI.getMode())) {
                        mainUI.setMode(ObserveUIMode.DB);
                    }
                    mainUI.getStatus().setStatus(I18n._((String)"observe.message.db.loaded", (Object[])new Object[]{s.getLabel()}));
                }
            }

            public void onClosed(StorageServiceEvent event) {
                StorageService service = event.getSource();
                ((ObserveConfig)((Object)ObserveContext.this.getContextValue(ObserveConfig.class))).setMainStorageOpened(false);
                ObserveDataContext dataContext = (ObserveDataContext)ObserveContext.this.getContextValue(ObserveDataContext.class);
                dataContext.uninstallStorage(service);
                ObserveMainUI mainUI = (ObserveMainUI)MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)ObserveContext.this);
                if (mainUI != null) {
                    ObserveTreeHelper treeHelper = mainUI.getTreeHelper();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("dispose ui from storage " + service.getLabel() + ": " + mainUI.getName()));
                    }
                    if (ObserveUIMode.DB.equals((Object)mainUI.getMode())) {
                        mainUI.setMode(ObserveUIMode.NO_DB);
                    }
                    treeHelper.cleanNavigationUI(mainUI);
                    UIHelper.displayInfo((JAXXContext)mainUI, I18n._((String)"observe.message.db.closed", (Object[])new Object[]{service.getLabel()}));
                }
            }
        });
    }
}

