/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web.injector;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import fr.ird.observe.services.dto.ObserveDto;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.debux.webmotion.server.call.Call;
import org.debux.webmotion.server.handler.ExecutorParametersInjectorHandler;
import org.debux.webmotion.server.mapping.Mapping;

public class ObserveDtoInjector
extends AbstractConverter
implements ExecutorParametersInjectorHandler.Injector {
    private static final Log log = LogFactory.getLog(ObserveDtoInjector.class);
    protected final Gson gson;

    public ObserveDtoInjector(Gson gson) {
        this.gson = gson;
    }

    public Object getValue(Mapping mapping, Call call, String name, Class<?> type, Type generic) {
        ObserveDto observeDto = null;
        if (ObserveDto.class.isAssignableFrom(type)) {
            Call.ParameterTree parameterTree = (Call.ParameterTree)call.getParameterTree().getObject().get(name);
            String gsonContent = ((String[])parameterTree.getValue())[0];
            if (generic instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)((Object)generic);
                String parameterizedTypeParam = "parameterized_type_" + typeVariable.getName();
                Call.ParameterTree parameterizedTypeParameterTree = (Call.ParameterTree)call.getParameterTree().getObject().get(parameterizedTypeParam);
                String parameterizedTypeClassName = ((String[])parameterizedTypeParameterTree.getValue())[0];
                try {
                    generic = Class.forName(parameterizedTypeClassName);
                }
                catch (ClassNotFoundException cnfe) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"An exception occurred", (Throwable)cnfe);
                    }
                    throw new JsonParseException("Class not found: " + parameterizedTypeClassName, (Throwable)cnfe);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("find parameterized type " + typeVariable.getName() + " as " + parameterizedTypeClassName));
                }
            }
            observeDto = (ObserveDto)this.gson.fromJson(gsonContent, (Type)generic);
            if (log.isInfoEnabled()) {
                log.info((Object)("Inject observeDto: " + observeDto));
            }
        }
        return observeDto;
    }

    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        Object observeDto;
        if (ObserveDto.class.isAssignableFrom(type)) {
            String gsonContent = value.toString();
            observeDto = this.gson.fromJson(gsonContent, type);
            if (log.isInfoEnabled()) {
                log.info((Object)("convert observeDto: " + observeDto));
            }
        } else {
            throw this.conversionException(type, value);
        }
        return (T)observeDto;
    }

    protected Class<?> getDefaultType() {
        return ObserveDto.class;
    }
}

