/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web;

import com.google.gson.Gson;
import fr.ird.observe.application.web.ObserveWebApplicationContext;
import fr.ird.observe.application.web.ObserveWebApplicationContextInitException;
import fr.ird.observe.application.web.converter.ObserveDtoConverter;
import fr.ird.observe.application.web.injector.DateInjector;
import fr.ird.observe.application.web.injector.ImmutableSetInjector;
import fr.ird.observe.application.web.injector.ObserveClassInjector;
import fr.ird.observe.application.web.injector.ObserveDataSourceConfigurationInjector;
import fr.ird.observe.application.web.injector.ObserveDtoInjector;
import fr.ird.observe.application.web.injector.ObserveReferenceSetRequestInjector;
import fr.ird.observe.application.web.injector.SqlScriptProducerRequestInjector;
import fr.ird.observe.services.dto.ObserveDbUserDto;
import java.io.Closeable;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.debux.webmotion.server.WebMotionServerListener;
import org.debux.webmotion.server.call.ServerContext;
import org.debux.webmotion.server.handler.ExecutorParametersInjectorHandler;
import org.debux.webmotion.server.mapping.Mapping;

public class ObserveWebApplicationListener
implements WebMotionServerListener {
    private static final Log log = LogFactory.getLog(ObserveWebApplicationListener.class);
    protected ObserveWebApplicationContext applicationContext;

    public void onStart(Mapping mapping, ServerContext context) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Initializing " + ObserveWebApplicationListener.class.getName()));
        }
        this.applicationContext = new ObserveWebApplicationContext();
        try {
            this.applicationContext.init();
        }
        catch (Exception e) {
            throw new ObserveWebApplicationContextInitException("Impossible d'initialiser le context applicatif", (Throwable)e);
        }
        Gson gson = this.applicationContext.getGsonSupplier().get();
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new ObserveDataSourceConfigurationInjector(gson));
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new ObserveClassInjector());
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new ObserveDtoInjector(gson));
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new ObserveReferenceSetRequestInjector(gson));
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new DateInjector("yyyy-MM-dd'T'HH:mm:ssZ"));
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new SqlScriptProducerRequestInjector(gson));
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new ImmutableSetInjector());
        context.addConverter((Converter)new ObserveDtoConverter(gson), ObserveDbUserDto.class);
        context.getServletContext().setAttribute(ObserveWebApplicationContext.APPLICATION_CONTEXT_PARAMETER, (Object)this.applicationContext);
        if (log.isInfoEnabled()) {
            log.info((Object)("Initializing " + ObserveWebApplicationListener.class.getName() + " done."));
        }
    }

    public void onStop(ServerContext context) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Destroying " + ObserveWebApplicationListener.class.getName()));
        }
        IOUtils.closeQuietly((Closeable)this.applicationContext);
        if (log.isInfoEnabled()) {
            log.info((Object)("Destroying " + ObserveWebApplicationListener.class.getName() + " done."));
        }
    }
}

