/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class UserHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private UserHelper() {// empty
}

    public static String getLastName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(User.EXT_USER, User.FIELD_USER_LASTNAME);
        return value;
}

    public static String setLastName(Wikitty wikitty, String lastName) {
        String oldValue = getLastName(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_LASTNAME, lastName);
        return oldValue;
}

    public static String getFirstName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(User.EXT_USER, User.FIELD_USER_FIRSTNAME);
        return value;
}

    public static String setFirstName(Wikitty wikitty, String firstName) {
        String oldValue = getFirstName(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_FIRSTNAME, firstName);
        return oldValue;
}

    public static String getEmail(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(User.EXT_USER, User.FIELD_USER_EMAIL);
        return value;
}

    public static String setEmail(Wikitty wikitty, String email) {
        String oldValue = getEmail(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_EMAIL, email);
        return oldValue;
}

    public static String getComment(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(User.EXT_USER, User.FIELD_USER_COMMENT);
        return value;
}

    public static String setComment(Wikitty wikitty, String comment) {
        String oldValue = getComment(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_COMMENT, comment);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_LASTNAME);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_LASTNAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_FIRSTNAME);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_FIRSTNAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_EMAIL);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_COMMENT);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_COMMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(User.EXT_USER);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : UserAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(User.EXT_USER);
}

} //UserHelper
