/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class CatiAbstract extends BusinessEntityImpl implements Cati {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionCati;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        String value = CatiHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = getName();
        CatiHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(Cati.FIELD_CATI_NAME, oldValue, getName());
}

    /**
     * getFullName :
     * @return String 
     */

    @Override
    public String getFullName() {
        String value = CatiHelper.getFullName(getWikitty());
        return value;
}

    /**
     * setFullName :
     * @param fullName 
     */

    @Override
    public void setFullName(String fullName) {
        String oldValue = getFullName();
        CatiHelper.setFullName(getWikitty(), fullName);
        getPropertyChangeSupport().firePropertyChange(Cati.FIELD_CATI_FULLNAME, oldValue, getFullName());
}

    /**
     * CatiAbstract :
     */

    public CatiAbstract() {
        super();
}

    /**
     * CatiAbstract :
     * @param wikitty 
     */

    public CatiAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * CatiAbstract :
     * @param businessEntityImpl 
     */

    public CatiAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionCati =
                new WikittyExtension(EXT_CATI,
                                     "2.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String name unique=\"true\"", 
                                             "String fullName unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionCati);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //CatiAbstract
