/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.result;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.logging.SimulationLoggerUtil;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.ui.CommonHandler;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.result.ResultFrameUI;
import fr.ifremer.isisfish.ui.result.ResultUI;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultHandler
extends CommonHandler {
    private static Log log = LogFactory.getLog(ResultHandler.class);
    protected SimulationServiceListener listener = null;
    protected ResultUI resultUI;

    public ResultHandler(ResultUI resultUI) {
        this.resultUI = resultUI;
    }

    public void afterInit() {
        this.initSimulationList();
        this.listener = new SimulationServiceListener(){

            @Override
            public void simulationStart(SimulationService simService, SimulationJob job) {
            }

            @Override
            public void simulationStop(SimulationService simService, SimulationJob job) {
                GenericComboModel model = (GenericComboModel)ResultHandler.this.resultUI.getSimulationComboBox().getModel();
                SwingUtilities.invokeLater(() -> model.addElement(job.getId()));
            }

            @Override
            public void clearJobDone(SimulationService simService) {
            }
        };
        SimulationService.getService().addSimulationServiceListener(this.listener);
    }

    protected void initSimulationList() {
        List<String> value = SimulationStorage.getSimulationNames();
        GenericComboModel<String> model = new GenericComboModel<String>(value);
        this.resultUI.getSimulationComboBox().setModel(model);
        this.resultUI.getSimulationComboBox().setSelectedItem(null);
    }

    public void openNewSimulation() {
        block2: {
            String selected = (String)this.resultUI.getSimulationComboBox().getSelectedItem();
            SimulationStorage simulation = SimulationStorage.getSimulation(selected);
            ResultFrameUI resultFrameUI = new ResultFrameUI((JAXXContext)this.resultUI);
            resultFrameUI.setTitle(simulation.getName());
            resultFrameUI.getHandler().afterInit(simulation);
            resultFrameUI.setSize(800, 600);
            this.resultUI.getSimulationDesktopPane().add(resultFrameUI);
            try {
                resultFrameUI.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't auto selected internal frame", (Throwable)ex);
            }
        }
    }

    public void deleteSimulation() {
        String selected = (String)this.resultUI.getSimulationComboBox().getSelectedItem();
        SimulationStorage simulation = SimulationStorage.getSimulation(selected);
        try {
            simulation.delete(false);
        }
        catch (StorageException ex) {
            throw new IsisFishRuntimeException("Can't delete simulation", ex);
        }
        this.initSimulationList();
    }

    public void showLog() {
        String selected = (String)this.resultUI.getSimulationComboBox().getSelectedItem();
        try {
            SimulationLoggerUtil.showSimulationLogConsole(this.resultUI, selected);
        }
        catch (Exception ex) {
            throw new IsisFishRuntimeException("Can't display simulation log", ex);
        }
    }
}

