/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.check;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CheckResult {
    protected Set<Object> order = new LinkedHashSet<Object>();
    protected Map<Object, List<String>> info = new HashMap<Object, List<String>>();
    protected Map<Object, List<String>> warning = new HashMap<Object, List<String>>();
    protected Map<Object, List<String>> error = new HashMap<Object, List<String>>();

    public StringBuffer getInfo() {
        StringBuffer result = new StringBuffer();
        for (Object o : this.order) {
            StringBuffer tmp = this.getInfo(o);
            if (tmp.length() == 0) continue;
            String title = o.toString();
            tmp.insert(0, "\n");
            for (int e = 0; e < title.length(); ++e) {
                tmp.insert(0, "=");
            }
            tmp.insert(0, title + "\n");
            tmp.append("\n");
            result.append(tmp.toString());
        }
        return result;
    }

    public StringBuffer getWarning() {
        StringBuffer result = new StringBuffer();
        for (Object o : this.order) {
            StringBuffer tmp = this.getWarning(o);
            if (tmp.length() == 0) continue;
            String title = o.toString();
            tmp.insert(0, "\n");
            for (int e = 0; e < title.length(); ++e) {
                tmp.insert(0, "=");
            }
            tmp.insert(0, title + "\n");
            tmp.append("\n");
            result.append(tmp.toString());
        }
        return result;
    }

    public StringBuffer getError() {
        StringBuffer result = new StringBuffer();
        for (Object o : this.order) {
            StringBuffer tmp = this.getError(o);
            if (tmp.length() == 0) continue;
            String title = o.toString();
            tmp.insert(0, "\n");
            for (int e = 0; e < title.length(); ++e) {
                tmp.insert(0, "=");
            }
            tmp.insert(0, title + "\n");
            tmp.append("\n");
            result.append(tmp.toString());
        }
        return result;
    }

    public StringBuffer getInfo(Object o) {
        StringBuffer result = new StringBuffer();
        List<String> list = this.info.get(o);
        if (list != null && list.size() != 0) {
            result.append("Info\n");
            result.append("----\n");
            for (String aList : list) {
                result.append(aList);
                result.append("\n");
            }
        }
        return result;
    }

    public StringBuffer getWarning(Object o) {
        StringBuffer result = new StringBuffer();
        List<String> list = this.warning.get(o);
        if (list != null && list.size() != 0) {
            result.append("Probl\u00e8me\n");
            result.append("--------\n");
            for (String aList : list) {
                result.append(aList);
                result.append("\n");
            }
        }
        return result;
    }

    public StringBuffer getError(Object o) {
        StringBuffer result = new StringBuffer();
        List<String> list = this.error.get(o);
        if (list != null && list.size() != 0) {
            result.append("Erreur\n");
            result.append("------\n");
            for (String aList : list) {
                result.append(aList);
                result.append("\n");
            }
        }
        return result;
    }

    public StringBuffer getAll(Object o) {
        StringBuffer result = new StringBuffer();
        result.append(this.getError(o).toString());
        result.append(this.getWarning(o).toString());
        result.append(this.getInfo(o).toString());
        if (result.length() != 0) {
            String title = o.toString();
            result.insert(0, "\n");
            for (int i = 0; i < title.length(); ++i) {
                result.insert(0, "=");
            }
            result.insert(0, title + "\n");
        }
        result.append("\n");
        return result;
    }

    public StringBuffer getAll() {
        StringBuffer result = new StringBuffer();
        for (Object anOrder : this.order) {
            result.append(this.getAll(anOrder));
        }
        return result;
    }

    public void addInfo(Object o, String message) {
        this.order.add(o);
        List list = this.info.computeIfAbsent(o, k -> new LinkedList());
        list.add(message);
    }

    public void addWarning(Object o, String message) {
        this.order.add(o);
        List list = this.warning.computeIfAbsent(o, k -> new LinkedList());
        list.add(message);
    }

    public void addError(Object o, String message) {
        this.order.add(o);
        List list = this.error.computeIfAbsent(o, k -> new LinkedList());
        list.add(message);
    }
}

