/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.models.common.GenericListModel;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableModel;
import fr.ifremer.isisfish.ui.simulator.PlanUI;
import fr.ifremer.isisfish.ui.simulator.SimulatorTabHandler;
import fr.ifremer.isisfish.ui.widget.editor.ScriptParameterDialog;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import jaxx.runtime.JAXXContext;

public class PlanHandler
extends SimulatorTabHandler {
    protected PlanUI tabUI;
    protected StorageChangeListener simulationPlanStorageListener;

    protected PlanHandler(PlanUI tabUI) {
        super((JAXXContext)tabUI);
        this.tabUI = tabUI;
    }

    protected void afterInit() {
        this.simulationPlanStorageListener = new StorageChangeListener(){

            @Override
            public void versionDataChanged(StorageChangeEvent e) {
                PlanHandler.this.refresh();
            }
        };
        SimulationPlanStorage.addStorageChangeListener(this.simulationPlanStorageListener);
        this.tabUI.fieldSimulParamsSimulationPlansSelect.setModel(this.getSimulationPlansComboModel());
        this.tabUI.listSimulParamsSimulationPlansList.setModel(this.getSimulationSimulationPlansListModel());
    }

    public void refresh() {
        this.tabUI.fieldSimulParamsSimulationPlansSelect.setModel(this.getSimulationPlansComboModel());
        this.tabUI.listSimulParamsSimulationPlansList.setModel(this.getSimulationSimulationPlansListModel());
    }

    public List<String> getSimulationPlanNames() {
        return SimulationPlanStorage.getSimulationPlanNames();
    }

    public List<SimulationPlan> getParamSimulationPlans() {
        return this.getParameters().getSimulationPlans();
    }

    public void addSimulationPlan(PlanUI planUI, String name) {
        try {
            SimulationPlan sp = (SimulationPlan)SimulationPlanStorage.getSimulationPlan(name, new CodeSourceStorage.Location[0]).getNewInstance();
            sp = (SimulationPlan)ScriptParameterDialog.displayConfigurationFrame((JAXXContext)planUI, sp);
            if (sp != null) {
                this.getParameters().addSimulationPlan(sp);
            }
        }
        catch (IsisFishException ex) {
            throw new IsisFishRuntimeException("Can't add simulation plan", ex);
        }
    }

    public void removeSimulationPlan(SimulationPlan sp) {
        this.getParameters().removeSimulationPlan(sp);
    }

    public void clearSimulationPlans() {
        this.getParameters().clearPlans();
    }

    protected GenericComboModel<String> getSimulationPlansComboModel() {
        List<String> simulationPlanNames = this.getSimulationPlanNames();
        GenericComboModel<String> model = new GenericComboModel<String>(simulationPlanNames);
        return model;
    }

    protected GenericListModel<SimulationPlan> getSimulationSimulationPlansListModel() {
        List<SimulationPlan> simulationPlans = this.getParamSimulationPlans();
        GenericListModel<SimulationPlan> model = new GenericListModel<SimulationPlan>(simulationPlans);
        return model;
    }

    protected void addSimulationPlan() {
        String selectedSimulationPlanName = (String)this.tabUI.fieldSimulParamsSimulationPlansSelect.getSelectedItem();
        this.addSimulationPlan(this.tabUI, selectedSimulationPlanName);
        this.tabUI.listSimulParamsSimulationPlansList.setModel(this.getSimulationSimulationPlansListModel());
        this.setSimulationPlanButtons();
    }

    protected void removeSimulationPlan() {
        SimulationPlan selectedSimulationPlan = this.tabUI.listSimulParamsSimulationPlansList.getSelectedValue();
        this.removeSimulationPlan(selectedSimulationPlan);
        this.tabUI.listSimulParamsSimulationPlansList.setModel(this.getSimulationSimulationPlansListModel());
        this.setSimulationPlanButtons();
    }

    protected void clearSimulationPlan() {
        this.clearSimulationPlans();
        this.tabUI.listSimulParamsSimulationPlansList.setModel(this.getSimulationSimulationPlansListModel());
        this.setSimulationPlanButtons();
    }

    protected void setSimulationPlanButtons() {
        if (this.getParamSimulationPlans().isEmpty()) {
            this.tabUI.buttonSimulParamsSimulationPlansClear.setEnabled(false);
            this.tabUI.buttonSimulParamsSimulationPlansRemove.setEnabled(false);
        } else {
            if (this.tabUI.listSimulParamsSimulationPlansList.getSelectedIndex() != -1) {
                this.tabUI.buttonSimulParamsSimulationPlansRemove.setEnabled(true);
            } else {
                this.tabUI.buttonSimulParamsSimulationPlansRemove.setEnabled(false);
            }
            this.tabUI.buttonSimulParamsSimulationPlansClear.setEnabled(true);
        }
        this.setSimulParamsSimulationPlans();
    }

    protected void setSimulParamsSimulationPlans() {
        SimulationPlan selectedSimulationPlan = this.tabUI.listSimulParamsSimulationPlansList.getSelectedValue();
        if (selectedSimulationPlan != null) {
            ScriptParametersTableModel model = new ScriptParametersTableModel(selectedSimulationPlan);
            this.tabUI.simulParamsSimulationPlans.setModel(model);
            ScriptParametersTableCellEditor cellEditor = new ScriptParametersTableCellEditor(selectedSimulationPlan);
            cellEditor.setRegionStorage(this.tabUI.getContextValue(RegionStorage.class));
            this.tabUI.simulParamsSimulationPlans.getColumnModel().getColumn(0).setCellRenderer(new ScriptParametersTableCellRenderer(selectedSimulationPlan));
            this.tabUI.simulParamsSimulationPlans.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        } else {
            this.tabUI.simulParamsSimulationPlans.setModel(new DefaultTableModel());
        }
    }
}

