/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui;

import fr.ifremer.isisfish.ui.StatusBarUI;
import fr.ifremer.isisfish.ui.WelcomeUI;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatusBarHandler {
    private static Log log = LogFactory.getLog(StatusBarHandler.class);
    protected StatusBarUI statusBarUI;
    protected JFileChooser screenshotFileChooser;

    public StatusBarHandler(StatusBarUI statusBarUI) {
        this.statusBarUI = statusBarUI;
    }

    public void afterInit() {
    }

    public void screenshot() {
        block7: {
            File previousFile;
            if (this.screenshotFileChooser == null) {
                this.screenshotFileChooser = new JFileChooser();
                this.screenshotFileChooser.setFileSelectionMode(0);
                this.screenshotFileChooser.setMultiSelectionEnabled(false);
            }
            if ((previousFile = this.screenshotFileChooser.getSelectedFile()) != null) {
                this.screenshotFileChooser.setSelectedFile(new File(""));
                this.screenshotFileChooser.setCurrentDirectory(previousFile.getParentFile());
            }
            Object parent = this.statusBarUI;
            while (!(parent instanceof WelcomeUI)) {
                parent = ((Component)parent).getParent();
            }
            StatusBarUI realParent = parent;
            try {
                Rectangle screenRect = ((Component)((Object)realParent)).getBounds();
                BufferedImage capture = new Robot().createScreenCapture(screenRect);
                int opt = this.screenshotFileChooser.showSaveDialog((Component)((Object)realParent));
                if (opt == 0) {
                    File file = this.screenshotFileChooser.getSelectedFile();
                    if (!file.getName().endsWith(".png")) {
                        file = new File(file.getAbsolutePath() + ".png");
                    }
                    File realFile = file;
                    ImageIO.write((RenderedImage)capture, "png", realFile);
                }
            }
            catch (AWTException | IOException ex) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Can't take screenshot help", (Throwable)ex);
            }
        }
    }
}

