/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.mexico.export;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.mexico.export.RegionEntityVisitor;
import fr.ifremer.isisfish.mexico.export.RegionExport;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;

public class RegionExplorer {
    public void explore(FisheryRegion region, RegionExport regionExport) throws TopiaException {
        regionExport.beginExport();
        RegionEntityVisitor visitor = new RegionEntityVisitor(regionExport);
        for (Cell cell : region.getCell()) {
            cell.accept((EntityVisitor)visitor);
        }
        for (Zone zone : region.getZone()) {
            zone.accept((EntityVisitor)visitor);
        }
        for (Port port : region.getPort()) {
            port.accept((EntityVisitor)visitor);
        }
        for (Species species : region.getSpecies()) {
            species.accept((EntityVisitor)visitor);
        }
        for (Gear gear : region.getGear()) {
            gear.accept((EntityVisitor)visitor);
        }
        for (Metier metier : region.getMetier()) {
            metier.accept((EntityVisitor)visitor);
        }
        for (TripType tripType : region.getTripType()) {
            tripType.accept((EntityVisitor)visitor);
        }
        for (VesselType vesselType : region.getVesselType()) {
            vesselType.accept((EntityVisitor)visitor);
        }
        for (SetOfVessels setOfVessels : region.getSetOfVessels()) {
            setOfVessels.accept((EntityVisitor)visitor);
        }
        for (Strategy strategy : region.getStrategy()) {
            strategy.accept((EntityVisitor)visitor);
        }
        regionExport.endExport();
    }
}

