/*
 * Decompiled with CFR 0.152.
 */
package simulationplans;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationPlanContext;
import fr.ifremer.isisfish.util.Doc;
import fr.ifremer.isisfish.util.ScriptUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;
import scripts.ResultName;

public class CalibrationSimplexePasVariable2Capturabilite
implements SimulationPlan {
    private static Log log = LogFactory.getLog(CalibrationSimplexePasVariable2Capturabilite.class);
    protected File exportHistoric = new File("Historic.csv");
    protected String exportHisto = "";
    @Doc(value="Population which parameters are calibrated")
    public Population param_Population = null;
    @Doc(value="First initial point of the simplex: de la forme(\"xx;yy\")")
    public String param_M1 = "2.42e-5;2.11e-6";
    @Doc(value="Second initial point of the simplex")
    public String param_M2 = "2.34e-5;2.59e-6";
    @Doc(value="Third initial point of the simplex")
    public String param_M3 = "2.59e-5;2.41e-6";
    @Doc(value="file name and path of observed landings")
    public String param_nomfichier_debarquements = "Observedlandings2001-2003.csv";
    protected File debarquementsObserves;
    protected MatrixND matrixDebarquement;
    protected State state = State.STATE_INIT;
    public Experiences experiences = new Experiences();
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_CATCH_WEIGHT_PER_STRATEGY_MET_PER_ZONE_POP};
    double g1;
    double g2;
    double worst1;
    double worst2;

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getDescription() throws Exception {
        return "Calibration using variable step Simplex method (Walters): usergives a file of observations (here catches)(.csv), simulated outputwill try to approach oservations by changing the values of catchability";
    }

    public void init(SimulationPlanContext context) throws Exception {
        this.debarquementsObserves = this.param_nomfichier_debarquements == null || "".equals(this.param_nomfichier_debarquements) ? FileUtil.getFile((String[])new String[]{".*.csv", "fichier csv s\u00e9parateur ';'"}) : new File(this.param_nomfichier_debarquements);
        log.info((Object)("MatrixDebarquement : " + this.matrixDebarquement));
    }

    public boolean beforeSimulation(SimulationPlanContext context, SimulationStorage nextSimulation) throws Exception {
        boolean doNext = true;
        boolean doBoucle = true;
        log.info((Object)"before simulation");
        int number = nextSimulation.getParameter().getSimulationPlanNumber();
        if (number < 3) {
            log.info((Object)"number<3");
            String[] M1 = this.param_M1.split(";");
            String[] M2 = this.param_M2.split(";");
            String[] M3 = this.param_M3.split(";");
            double[] q1 = StringUtil.toArrayDouble((String[])new String[]{M1[0], M2[0], M3[0]});
            double[] q2 = StringUtil.toArrayDouble((String[])new String[]{M1[1], M2[1], M3[1]});
            this.experiences.getExperience((int)number).q1 = q1[number];
            this.experiences.getExperience((int)number).q2 = q2[number];
            this.changeDB(this.experiences.getExperience(number), nextSimulation);
        } else {
            double q1 = 1000.0;
            double q2 = 1000.0;
            double lastCritere = this.experiences.getExperience((int)(number - 1)).criteria;
            while (doBoucle) {
                doBoucle = false;
                if (this.state == State.STATE_INIT) {
                    doBoucle = false;
                    log.info((Object)"state init");
                    Collections.sort(this.experiences.current);
                    log.info((Object)("SIMPLEXE : current 0 = " + this.experiences.current.get((int)0).criteria + "current 1 = " + this.experiences.current.get((int)1).criteria + "current 2 = " + this.experiences.current.get((int)2).criteria));
                    log.info((Object)("SIMPLEXE : Best q1 = " + this.experiences.current.get((int)0).q1 + " q2 = " + this.experiences.current.get((int)0).q2));
                    log.info((Object)("SIMPLEXE : NextBest q1 = " + this.experiences.current.get((int)1).q1 + " q2 = " + this.experiences.current.get((int)1).q2));
                    log.info((Object)("SIMPLEXE : Worst q1 = " + this.experiences.current.get((int)2).q1 + " q2 = " + this.experiences.current.get((int)2).q2));
                    double g1 = (this.experiences.current.get((int)0).q1 + this.experiences.current.get((int)1).q1) / 2.0;
                    double g2 = (this.experiences.current.get((int)0).q2 + this.experiences.current.get((int)1).q2) / 2.0;
                    double worst1 = this.experiences.current.get((int)2).q1;
                    double worst2 = this.experiences.current.get((int)2).q2;
                    this.state = State.STATE_0;
                    q1 = 2.0 * g1 - worst1;
                    q2 = 2.0 * g2 - worst2;
                    log.info((Object)("R : q1 = " + q1 + " q2 = " + q2));
                    continue;
                }
                if (this.state == State.STATE_0) {
                    doBoucle = false;
                    log.info((Object)"state 0");
                    if (lastCritere > this.experiences.current.get((int)2).criteria) {
                        log.info((Object)"State 0 : R : lastCtritere > current2 : R pire de W");
                        this.state = State.STATE_1;
                        q1 = (this.experiences.current.get((int)0).q1 + this.experiences.current.get((int)1).q1) / 2.0 - ((this.experiences.current.get((int)0).q1 + this.experiences.current.get((int)1).q1) / 2.0 - this.experiences.current.get((int)2).q1) / 2.0;
                        q2 = (this.experiences.current.get((int)0).q2 + this.experiences.current.get((int)1).q2) / 2.0 - ((this.experiences.current.get((int)0).q2 + this.experiences.current.get((int)1).q2) / 2.0 - this.experiences.current.get((int)2).q2) / 2.0;
                        log.info((Object)("Cw : q1 = " + q1 + " q2 = " + q2));
                        continue;
                    }
                    if (lastCritere > this.experiences.current.get((int)1).criteria) {
                        log.info((Object)"State 0 :R : lastCritere > current 1 : R meilleur que W et moins bon que N");
                        this.state = State.STATE_2;
                        q1 = (this.experiences.current.get((int)0).q1 + this.experiences.current.get((int)1).q1) / 2.0 + ((this.experiences.current.get((int)0).q1 + this.experiences.current.get((int)1).q1) / 2.0 - this.experiences.current.get((int)2).q1) / 2.0;
                        q2 = (this.experiences.current.get((int)0).q2 + this.experiences.current.get((int)1).q2) / 2.0 + ((this.experiences.current.get((int)0).q2 + this.experiences.current.get((int)1).q2) / 2.0 - this.experiences.current.get((int)2).q2) / 2.0;
                        log.info((Object)("Cr : q1 = " + q1 + " q2 = " + q2));
                        continue;
                    }
                    if (lastCritere > this.experiences.current.get((int)0).criteria) {
                        log.info((Object)"State 0 :R : lastCritere > current0 : R meilleur que N et moins bon que B");
                        this.state = State.STATE_INIT;
                        this.experiences.current.remove(2);
                        doBoucle = true;
                        log.info((Object)"remove W, simplex BNR");
                        continue;
                    }
                    log.info((Object)"State 0 :R : lastCritere < current 0 : R meilleur que B, calcul de E");
                    this.state = State.STATE_4;
                    q1 = this.experiences.getExperience((int)(number - 1)).q1 + (this.experiences.current.get((int)0).q1 + this.experiences.current.get((int)1).q1) / 2.0 - this.experiences.current.get((int)2).q1;
                    q2 = this.experiences.getExperience((int)(number - 1)).q2 + (this.experiences.current.get((int)0).q2 + this.experiences.current.get((int)1).q2) / 2.0 - this.experiences.current.get((int)2).q2;
                    log.info((Object)("E : q1 = " + q1 + " q2 = " + q2));
                    continue;
                }
                if (this.state == State.STATE_1) {
                    log.info((Object)"state 1, simplex BNCw");
                    this.experiences.current.remove(3);
                    this.experiences.current.remove(2);
                    this.state = State.STATE_INIT;
                    doBoucle = true;
                    continue;
                }
                if (this.state == State.STATE_2) {
                    log.info((Object)"state 2, simplex BNCr");
                    this.experiences.current.remove(3);
                    this.experiences.current.remove(2);
                    this.state = State.STATE_INIT;
                    doBoucle = true;
                    continue;
                }
                if (this.state != State.STATE_4) continue;
                log.info((Object)"state 4 :comparaison de E a B");
                doBoucle = true;
                if (lastCritere < this.experiences.current.get((int)0).criteria) {
                    log.info((Object)"E meilleur que B, remove 2 et 3 : simplex BNE");
                    this.experiences.current.remove(3);
                    this.experiences.current.remove(2);
                } else {
                    log.info((Object)"E moins bon que B, remove 2 et 4, simplex BNR");
                    this.experiences.current.remove(4);
                    this.experiences.current.remove(2);
                }
                this.state = State.STATE_INIT;
            }
            this.experiences.getExperience((int)number).q1 = q1;
            this.experiences.getExperience((int)number).q2 = q2;
            log.info((Object)("on change Q dans la DB avec : q1 = " + q1 + " " + "q2 = " + q2));
            this.changeDB(this.experiences.getExperience(number), nextSimulation);
        }
        return doNext;
    }

    public boolean afterSimulation(SimulationPlanContext context, SimulationStorage lastSimulation) throws Exception {
        boolean doNext = true;
        log.info((Object)"after simulation");
        int number = lastSimulation.getParameter().getSimulationPlanNumber();
        ResultStorage result = lastSimulation.getResultStorage();
        MatrixND L = result.getMatrix(this.param_Population, ResultName.MATRIX_CATCH_WEIGHT_PER_STRATEGY_MET_PER_ZONE_POP);
        log.info((Object)"calcul de la fonction objectif");
        log.info((Object)("dim de L " + Arrays.toString(L.getDim())));
        log.info((Object)("dim de obs " + Arrays.toString(this.matrixDebarquement.getDim())));
        double obj = 0.0;
        MatrixIterator g = L.iterator();
        while (g.hasNext()) {
            g.next();
            int[] dim = g.getCoordinates();
            double obs = this.matrixDebarquement.getValue(dim);
            double simules = g.getValue();
            obj += Math.pow(obs - simules, 2.0);
        }
        this.experiences.getExperience((int)number).criteria = obj;
        this.exportHisto = String.valueOf(this.exportHisto) + this.experiences.getExperience((int)number).q1 + ";" + this.experiences.getExperience((int)number).q2 + ";" + this.experiences.getExperience((int)number).criteria + "\n";
        ScriptUtil.writeString((File)this.exportHistoric, (String)this.exportHisto);
        return doNext;
    }

    protected void changeDB(Experience exp, SimulationStorage nextSimulation) throws Exception {
        TopiaContext db = nextSimulation.getStorage().beginTransaction();
        Population pop = (Population)db.findByTopiaId(this.param_Population.getTopiaId());
        MatrixND c = pop.getCapturability();
        MatrixIterator i = c.iterator();
        while (i.hasNext()) {
            i.next();
            Object[] sem = i.getSemanticsCoordinates();
            PopulationGroup group = (PopulationGroup)sem[0];
            if (group.getId() < 12) {
                i.setValue(exp.q2);
                continue;
            }
            i.setValue(exp.q1);
        }
        db.commitTransaction();
        db.closeContext();
    }

    public static class Experience
    implements Comparable<Experience> {
        public int simNumber;
        public double criteria;
        public double q1;
        public double q2;

        @Override
        public int compareTo(Experience other) {
            int result = Double.compare(this.criteria, other.criteria);
            return result;
        }
    }

    public static class Experiences {
        public List<Experience> current = new ArrayList<Experience>();
        public List<Experience> history = new ArrayList<Experience>();

        public Experience getExperience(int i) {
            Experience result;
            if (i < this.history.size()) {
                result = this.history.get(i);
            } else {
                result = new Experience();
                result.simNumber = i;
                this.history.add(i, result);
                this.current.add(result);
            }
            return result;
        }

        public List<Experience> getHistory() {
            return this.history;
        }
    }

    static enum State {
        STATE_INIT,
        STATE_0,
        STATE_1,
        STATE_2,
        STATE_3,
        STATE_4;

    }
}

