/*
 * Decompiled with CFR 0.152.
 */
package sensitivityexports;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;

public class SensitivityBiomassRelativeY6
implements SensitivityExport {
    private static Log log = LogFactory.getLog(SensitivityBiomassRelativeY6.class);
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_BIOMASS};
    @Doc(value="Population")
    public Population param_pop;

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        ResultStorage resultStorage = simulation.getResultStorage();
        TimeStep lastStep = resultStorage.getLastStep();
        TimeStep firstStep = new TimeStep(11);
        double biomass = 0.0;
        double firstbiomass = 0.0;
        for (Population pop : simulation.getParameter().getPopulations()) {
            if (!pop.getName().equals(this.param_pop.getName())) continue;
            MatrixND matfirstdate = resultStorage.getMatrix(firstStep, pop, ResultName.MATRIX_BIOMASS);
            firstbiomass = matfirstdate.sumAll();
            MatrixND matlastdate = resultStorage.getMatrix(lastStep, pop, ResultName.MATRIX_BIOMASS);
            biomass = matlastdate.sumAll();
        }
        out.write(Double.toString(biomass / firstbiomass));
    }

    public String getDescription() {
        return "Biomass for the last time step. Biomass is the sum on the groups and zones";
    }

    public String getExportFilename() {
        return "SensitivityBiomassRelativeY6_" + this.param_pop.getName();
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }
}

