/*
 * Decompiled with CFR 0.152.
 */
package sensitivityanalysis;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.AbstractSensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Distribution;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityScenarios;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.util.Doc;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.RDataFrame;

public class Morris
extends AbstractSensitivityAnalysis {
    @Doc(value="Integer giving the number of repetitions of the design, i.e. the number of elementary effect computed per factor. (Default value : 4)")
    public int param_r = 4;
    @Doc(value="True to be able to modify the code sent to R")
    public boolean param_modifR = false;

    public boolean canManageCardinality() {
        return false;
    }

    public SensitivityScenarios compute(DesignPlan plan, File outputDirectory) throws SensitivityException {
        this.setIsisFactorsR(plan, outputDirectory);
        int factorNumber = plan.getFactors().size();
        SensitivityScenarios thisExperiment = new SensitivityScenarios();
        List factors = plan.getFactors();
        if (this.param_r == 0) {
            this.param_r = 4;
        }
        this.checkAllUniformDistribution(factors);
        String factorNames = "";
        String levels = "";
        String gridJump = "";
        String binf = "";
        String bsup = "";
        int i = 0;
        while (i < factorNumber) {
            Factor factor = (Factor)factors.get(i);
            if (i != 0) {
                factorNames = String.valueOf(factorNames) + ",";
                levels = String.valueOf(levels) + ",";
                gridJump = String.valueOf(gridJump) + ",";
                binf = String.valueOf(binf) + ",";
                bsup = String.valueOf(bsup) + ",";
            }
            factorNames = String.valueOf(factorNames) + "\"" + factor.getName() + "\"";
            levels = String.valueOf(levels) + factor.getCardinality();
            gridJump = String.valueOf(gridJump) + factor.getCardinality() / 2;
            binf = String.valueOf(binf) + 0;
            bsup = String.valueOf(bsup) + 1;
            ++i;
        }
        String rInstruction = "isis.methodAnalyse<-morris(model=NULL,factors=c(%s),r=%s,design=list(type=\"oat\",levels=c(%s),grid.jump=c(%s)),binf=c(%s),bsup=c(%s))";
        String rCall = String.format(rInstruction, factorNames, this.param_r, levels, gridJump, binf, bsup);
        if (this.param_modifR) {
            rCall = this.editRInstruction(rCall);
        }
        try {
            REngine engine = this.openEngine(outputDirectory);
            engine.voidEval("library(sensitivity)");
            engine.voidEval(rCall);
            rInstruction = "factornames<-c(%s)";
            rCall = String.format(rInstruction, factorNames);
            engine.voidEval(rCall);
            engine.setwd(outputDirectory);
            engine.eval("expPlan<-as.data.frame(isis.methodAnalyse$X)");
            RDataFrame dataFrame = (RDataFrame)engine.eval("expPlan");
            dataFrame.setVariable("expPlan");
            int nbExperiments = (Integer)engine.eval("dim(expPlan)[1]");
            String factorDistribution = "isis.factor.distribution<-data.frame(NomFacteur=c(%s),NomDistribution=c(%s),ParametreDistribution=c(%s))";
            String distribution = "";
            String parameters = "";
            int i2 = 0;
            while (i2 < factorNumber) {
                Factor factor = (Factor)factors.get(i2);
                ContinuousDomain domain = (ContinuousDomain)factor.getDomain();
                if (i2 != 0) {
                    distribution = String.valueOf(distribution) + ",";
                    parameters = String.valueOf(parameters) + ",";
                }
                Distribution r_distribution = domain.getDistribution();
                distribution = String.valueOf(distribution) + "\"" + r_distribution.getInstruction() + "\"";
                parameters = String.valueOf(parameters) + "\"[";
                for (Map.Entry param : domain.getDistributionParameters().entrySet()) {
                    parameters = String.valueOf(parameters) + (String)param.getKey() + "=" + param.getValue() + ";";
                }
                parameters = StringUtils.removeEnd((String)parameters, (String)";");
                parameters = String.valueOf(parameters) + "]\"";
                ++i2;
            }
            engine.voidEval(String.format(factorDistribution, factorNames, distribution, parameters));
            engine.voidEval("call<-isis.methodAnalyse$call");
            engine.voidEval("isis.methodExp<-list(\"isis.factors\"=isis.factors,\"isis.factor.distribution\"=isis.factor.distribution,\"call\"=call)");
            engine.voidEval("attr(isis.methodExp,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("isis.simule<-data.frame(expPlan)");
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("names(isis.simule)<-isis.factors[[1]]");
            List thisExperimentScenarios = thisExperiment.getScenarios();
            int j = 0;
            while (j < nbExperiments) {
                Scenario experimentScenario = new Scenario();
                int i3 = 0;
                while (i3 < factorNumber) {
                    Factor factor = (Factor)factors.get(i3);
                    factor.setValueForIdentifier(dataFrame.get(i3, j));
                    experimentScenario.addFactor(factor);
                    ++i3;
                }
                thisExperimentScenarios.add(experimentScenario);
                thisExperiment.setScenarios(thisExperimentScenarios);
                ++j;
            }
            this.closeEngine(engine, outputDirectory);
        }
        catch (RException eee) {
            throw new SensitivityException("Can't generate scenarios", (Throwable)eee);
        }
        return thisExperiment;
    }

    public void analyzeResult(List<SimulationStorage> simulationStorages, File outputDirectory) throws SensitivityException {
        String simulationName = outputDirectory.getName().replaceAll("-", "");
        try {
            REngine engine = this.openEngine(outputDirectory);
            engine.voidEval("library(sensitivity)");
            engine.setwd(outputDirectory);
            SimulationParameter param = simulationStorages.get(0).getParameter();
            int sensitivityNumber = param.getSensitivityExport().size();
            int k = 0;
            while (k < sensitivityNumber) {
                SensitivityExport sensitivityExport = (SensitivityExport)param.getSensitivityExport().get(k);
                String rInstruction = this.createImportInstruction(sensitivityExport, simulationStorages);
                engine.voidEval(rInstruction);
                engine.voidEval("isis.simule<-data.frame(isis.simule," + sensitivityExport.getExportFilename() + ")");
                ++k;
            }
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("attr(isis.simule,\"call\")<-isis.methodExp$call");
            k = 0;
            while (k < sensitivityNumber) {
                String name = ((SensitivityExport)param.getSensitivityExport().get(k)).getExportFilename();
                engine.voidEval("tell(isis.methodAnalyse,y=" + name + ")");
                String exportMethodAnalyse = String.format("%s.isis.methodAnalyse", String.valueOf(simulationName) + "." + name);
                engine.voidEval(String.valueOf(exportMethodAnalyse) + "<-list(" + "\"isis.simule\"=isis.simule," + "\"call_method\"=\"tell(isis.methodAnalyse,y=" + name + ")" + "\"," + "\"analysis_result\"=isis.methodAnalyse)");
                engine.voidEval("attr(" + exportMethodAnalyse + ",\"nomModel\")<-" + "\"isis-fish-externe-R\"");
                engine.voidEval("mu<-apply(isis.methodAnalyse$ee, 2, mean)");
                engine.voidEval("mu.star <- apply(isis.methodAnalyse$ee, 2, function(a) mean(abs(a)))");
                engine.voidEval("sigma <- apply(isis.methodAnalyse$ee, 2, sd)");
                engine.voidEval("df<-data.frame(mu,mu.star,sigma)");
                engine.voidEval("row.names(df)<-isis.factor.distribution$NomFacteur");
                engine.voidEval("dfresults<-data.frame(isis.methodAnalyse$X," + name + ")");
                engine.voidEval("resultsnames<-c(isis.factor.distribution$NomFacteur,\"Result\")");
                engine.voidEval("names(dfresults)<-resultsnames");
                engine.voidEval("write.csv(df,\"" + name + "_SensitivityIndices.csv\")");
                engine.voidEval("write.csv(dfresults,\"" + name + "_Results.csv\")");
                ++k;
            }
            this.closeEngine(engine, outputDirectory);
        }
        catch (Exception e) {
            throw new SensitivityException("Can't evaluate results", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Implementation of Morris method using R (needs the sensitivity package to work)";
    }
}

