/*
 * Decompiled with CFR 0.152.
 */
package sensitivityanalysis;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.AbstractSensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityScenarios;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.util.Doc;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import org.apache.commons.lang.StringUtils;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.RDataFrame;

public class DOptimal
extends AbstractSensitivityAnalysis {
    @Doc(value="True to be able to modify the code sent to R")
    public boolean param_modifR = false;
    @Doc(value="Order")
    public int param_order = 1;

    public boolean canManageCardinality() {
        return false;
    }

    public SensitivityScenarios compute(DesignPlan plan, File outputDirectory) throws SensitivityException {
        SensitivityScenarios thisExperiment = new SensitivityScenarios();
        this.setIsisFactorsR(plan, outputDirectory);
        List factors = plan.getFactors();
        int factorsNb = factors.size();
        try {
            REngine engine = this.openEngine(outputDirectory);
            engine.voidEval("library(AlgDesign)");
            String factorsNames = "";
            String factorNames = "";
            String factorPlus = "";
            for (Factor factor : factors) {
                String factorName = factor.getName().replaceAll(" ", "");
                factorsNames = String.valueOf(factorsNames) + factorName + "=" + factorName + ",";
                factorNames = String.valueOf(factorNames) + factorName + ",";
                factorPlus = String.valueOf(factorPlus) + factorName + "+";
                String vector = String.valueOf(factorName) + "<-c(";
                Domain domain = factor.getDomain();
                if (domain instanceof ContinuousDomain) {
                    int card = factor.getCardinality();
                    Double min = 0.0;
                    Double max = 1.0;
                    int i = 0;
                    while (i < card) {
                        vector = String.valueOf(vector) + (min + (double)i * (max - min) / (double)(card - 1)) + ",";
                        ++i;
                    }
                } else {
                    int nbValues = ((DiscreteDomain)domain).getValuesCount();
                    int i = 0;
                    while (i < nbValues) {
                        vector = String.valueOf(vector) + "as.integer(" + i + "),";
                        ++i;
                    }
                }
                vector = vector.substring(0, vector.length() - 1);
                vector = String.valueOf(vector) + ")";
                engine.voidEval(vector);
            }
            factorsNames = factorsNames.substring(0, factorsNames.length() - 1);
            factorNames = factorNames.substring(0, factorNames.length() - 1);
            factorPlus = factorPlus.substring(0, factorPlus.length() - 1);
            String expandGrid = "expandgrid<-expand.grid(%s)";
            String rCall = String.format(expandGrid, factorsNames);
            engine.voidEval(rCall);
            rCall = this.param_order == 1 ? "isis.methodAnalyse<-optFederov(~(%s),data=expandgrid, approximate =FALSE, center=F, criterion = \"D\",nRepeats=10)" : "isis.methodAnalyse<-optFederov(~(%s)^" + this.param_order + ",data=expandgrid, " + "approximate =FALSE, center=F, criterion = \"D\"," + "nRepeats=10)";
            rCall = String.format(rCall, factorPlus);
            if (this.param_modifR) {
                rCall = this.editRInstruction(rCall);
            }
            engine.voidEval("runif(1)");
            engine.voidEval(rCall);
            engine.eval("expPlan<-as.data.frame(isis.methodAnalyse$design)");
            RDataFrame dataFrame = (RDataFrame)engine.eval("expPlan");
            dataFrame.setVariable("expPlan");
            int nbExperiments = (Integer)engine.eval("dim(isis.methodAnalyse$design)[1]");
            List thisExperimentScenarios = thisExperiment.getScenarios();
            int j = 0;
            while (j < nbExperiments) {
                Scenario experimentScenario = new Scenario();
                int i = 0;
                while (i < factorsNb) {
                    Factor factor = (Factor)factors.get(i);
                    factor.setValueForIdentifier(dataFrame.get(i, j));
                    experimentScenario.addFactor(factor);
                    ++i;
                }
                thisExperimentScenarios.add(experimentScenario);
                thisExperiment.setScenarios(thisExperimentScenarios);
                ++j;
            }
            String factorDistribution = "isis.factor.distribution<-data.frame(NomFacteur=c(%s),NomDistribution=c(%s),ParametreDistribution=c(%s))";
            String distribution = "";
            String parameters = "";
            int i = 0;
            while (i < factorsNb) {
                Domain domain = ((Factor)factors.get(i)).getDomain();
                if (i != 0) {
                    distribution = String.valueOf(distribution) + ",";
                    parameters = String.valueOf(parameters) + ",";
                }
                if (domain instanceof ContinuousDomain) {
                    distribution = String.valueOf(distribution) + "\"qunif\"";
                    parameters = String.valueOf(parameters) + "\"[0.0;1.0]\"";
                } else {
                    DiscreteDomain discDomain = (DiscreteDomain)domain;
                    distribution = String.valueOf(distribution) + "\"discrete\"";
                    parameters = String.valueOf(parameters) + "\"[";
                    SortedMap values = discDomain.getValues();
                    int count = 0;
                    Collection collecValues = values.values();
                    for (Object value : collecValues) {
                        if (count != 0) {
                            parameters = String.valueOf(parameters) + ",";
                        }
                        parameters = String.valueOf(parameters) + StringUtils.replace((String)value.toString(), (String)"\"", (String)"\\\"");
                        ++count;
                    }
                    parameters = String.valueOf(parameters) + "]\"";
                }
                ++i;
            }
            engine.voidEval(String.format(factorDistribution, factorNames, distribution, parameters));
            engine.voidEval("call<-\"" + rCall + "\"");
            engine.voidEval("isis.methodExp<-list(\"isis.factors\"=isis.factors,\"isis.factor.distribution\"=isis.factor.distribution,\"call\"=call)");
            engine.voidEval("attr(isis.methodExp,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("isis.simule<-isis.methodAnalyse$design");
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("names(isis.simule)<-isis.factors[[1]]");
            this.closeEngine(engine, outputDirectory);
        }
        catch (RException eee) {
            throw new SensitivityException("Can't generate scenarios", (Throwable)eee);
        }
        return thisExperiment;
    }

    public void analyzeResult(List<SimulationStorage> simulationStorages, File outputDirectory) throws SensitivityException {
        try {
            REngine engine = this.openEngine(outputDirectory);
            int factorNumber = (Integer)engine.eval("dim(isis.methodAnalyse$design)[2]");
            SimulationParameter param = simulationStorages.get(0).getParameter();
            int sensitivityNumber = param.getSensitivityExport().size();
            String firstStorageName = outputDirectory.getName().replaceAll("-", "");
            int k = 0;
            while (k < sensitivityNumber) {
                SensitivityExport sensitivityExport = (SensitivityExport)param.getSensitivityExport().get(k);
                String name = sensitivityExport.getExportFilename();
                String rInstruction = this.createImportInstruction(sensitivityExport, simulationStorages);
                engine.voidEval(rInstruction);
                engine.voidEval("isis.simule<-data.frame(isis.simule," + name + ")");
                String dataFrame = "dataforaov<-data.frame(isis.methodAnalyse$design," + name + "=" + name + ")";
                engine.voidEval(dataFrame);
                String aovCall = "aovresult<-aov(" + name + "~(";
                int j = 0;
                while (j < factorNumber) {
                    if (j < factorNumber - 1) {
                        aovCall = String.valueOf(aovCall) + engine.eval("names(isis.methodAnalyse$design)[" + (j + 1) + "]") + "+";
                    } else {
                        aovCall = String.valueOf(aovCall) + engine.eval("names(isis.methodAnalyse$design)[" + (j + 1) + "]") + ")";
                        aovCall = this.param_order > 1 ? String.valueOf(aovCall) + "^" + this.param_order + ",data=dataforaov)" : String.valueOf(aovCall) + ",data=dataforaov)";
                    }
                    ++j;
                }
                engine.voidEval(aovCall);
                engine.voidEval("SoS<-summary(aovresult)[[1]][1:dim(summary(aovresult)[[1]])[1],2]");
                engine.voidEval("names(SoS)<-dimnames(summary(aovresult)[[1]])[[1]][1:dim(summary(aovresult)[[1]])[1]]");
                engine.voidEval("IndSensibilite<-SoS/sum(SoS)");
                engine.voidEval("exportsensitivity<-data.frame(SoS[1:dim(summary(aovresult)[[1]])[1]],IndSensibilite[1:dim(summary(aovresult)[[1]])[1]])");
                engine.voidEval("names(exportsensitivity)<-c(\"Sum Of Squares\",\"Sensitivity indices\")");
                engine.voidEval("row.names(exportsensitivity)<-dimnames(summary(aovresult)[[1]])[1][[1]][1:dim(summary(aovresult)[[1]])[1]]");
                engine.voidEval("resultsnames<-c(names(x$design),\"Result\")");
                engine.voidEval("names(dataforaov)<-resultsnames");
                engine.setwd(outputDirectory);
                engine.voidEval("write.csv(dataforaov,\"" + ((SensitivityExport)param.getSensitivityExport().get(k)).getExportFilename() + "_Results.csv\")");
                engine.voidEval("write.csv(exportsensitivity,\"" + ((SensitivityExport)param.getSensitivityExport().get(k)).getExportFilename() + "_SensitivityIndices.csv\")");
                String exportMethodAnalyse = String.format("%s.isis.methodAnalyse", String.valueOf(firstStorageName) + "." + name);
                engine.voidEval(String.valueOf(exportMethodAnalyse) + "<-list(" + "\"isis.factors\"=isis.factors," + "\"isis.factor.distribution\"=isis.factor.distribution," + "\"isis.simule\"=isis.simule," + "\"call_method\"=\"" + aovCall + "\"," + "\"analysis_result\"=list(aovresult,IndSensibilite))");
                engine.voidEval("attr(" + exportMethodAnalyse + "," + "\"nomModel\")<-\"isis-fish-externe-R\"");
                ++k;
            }
            this.closeEngine(engine, outputDirectory);
        }
        catch (Exception e) {
            throw new SensitivityException("Can't evaluate results", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Implementation of D optimal method method using R, needsAlgDesign package to work";
    }
}

