/*
 * Decompiled with CFR 0.152.
 */
package exports;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.types.TimeStep;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;

public class VesselMargin
implements Export {
    private static Log log = LogFactory.getLog(VesselMargin.class);
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_VESSEL_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY_PER_VESSEL};

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getExportFilename() {
        return "BateauProfit";
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String getDescription() {
        return "cvs out strategy;date;value";
    }

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        MatrixND mat = simulation.getResultStorage().getMatrix(ResultName.MATRIX_VESSEL_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY_PER_VESSEL);
        MatrixIterator i = mat.iterator();
        while (i.hasNext()) {
            i.next();
            Object[] sems = i.getSemanticsCoordinates();
            TimeStep step = (TimeStep)sems[0];
            Strategy str = (Strategy)sems[1];
            double val = i.getValue();
            out.write(String.valueOf(str.getName()) + ";" + step.getStep() + ";" + val + "\n");
        }
    }
}

