/*
 * Decompiled with CFR 0.152.
 */
package exports;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.types.TimeStep;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;

public class MetierZone
implements Export {
    private static Log log = LogFactory.getLog(MetierZone.class);
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_METIER_ZONE};

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getExportFilename() {
        return "MetierZone";
    }

    public String getExtensionFilename() {
        return ".csv";
    }

    public String getDescription() {
        return "Export zone used by metier during simulation";
    }

    public void export(SimulationStorage simulation, Writer out) throws Exception {
        TimeStep lastStep = simulation.getResultStorage().getLastStep();
        TimeStep step = new TimeStep(0);
        while (!step.after(lastStep)) {
            MatrixND mat = simulation.getResultStorage().getMatrix(step, ResultName.MATRIX_METIER_ZONE);
            if (mat != null) {
                MatrixIterator i = mat.iterator();
                while (i.hasNext()) {
                    i.next();
                    if (i.getValue() != 1.0) continue;
                    Object metier = i.getSemanticsCoordinates()[0];
                    Object zone = i.getSemanticsCoordinates()[1];
                    out.write(metier + ";" + zone + ";" + step.getStep() + "\n");
                }
            }
            step = step.next();
        }
    }
}

