/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.base.Preconditions;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.entities.references.MissionImpl;
import fr.ifremer.echobase.services.service.importdata.CommonImportService;
import fr.ifremer.echobase.services.service.importdata.MissionNameAlreadyExistException;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateMission
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CreateMission.class);
    protected Mission mission;
    protected transient CommonImportService commonImportService;

    public Mission getMission() {
        if (this.mission == null) {
            this.mission = new MissionImpl();
        }
        return this.mission;
    }

    public String execute() throws Exception {
        Preconditions.checkNotNull((Object)this.mission);
        String result = "input";
        try {
            Mission missionSaved = this.commonImportService.createMission(this.mission);
            if (log.isInfoEnabled()) {
                log.info((Object)("Created mission : " + missionSaved.getTopiaId()));
            }
            this.addFlashMessage(this._("echobase.information.mission.created", new Object[]{missionSaved.getName()}));
            result = "success";
        }
        catch (MissionNameAlreadyExistException e) {
            this.addFieldError("mission.name", this._("echobase.error.mission.name.already.exist", new Object[0]));
        }
        return result;
    }

    public void setCommonImportService(CommonImportService commonImportService) {
        this.commonImportService = commonImportService;
    }
}

