/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportCoser;

import fr.ifremer.echobase.services.service.exportCoser.ExportCoserConfiguration;
import fr.ifremer.echobase.services.service.exportCoser.ExportCoserService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Export
extends AbstractWaitAndExecAction<ExportCoserConfiguration, ExportCoserService> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Export.class);

    public Export() {
        super(ExportCoserConfiguration.class, ExportCoserService.class);
    }

    protected void startAction(ExportCoserService service, ExportCoserConfiguration model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start Coser export for mission" + model.getMissionId()));
        }
        service.doExport(model);
    }

    protected String getSuccesMessage() {
        return this.t("echobase.info.exportCoser.succeded", new Object[0]);
    }

    protected String getErrorMessage() {
        return this.t("echobase.info.exportCoser.failed", new Object[0]);
    }

    public String getActionResumeTitle() {
        return this.t("echobase.legend.exportCoser.resume", new Object[0]);
    }

    protected String getResultMessage(ExportCoserConfiguration model) {
        String result = this.t("echobase.message.exportCoser.result", new Object[]{model.getExportFile().getName(), model.getActionTime()});
        if (log.isInfoEnabled()) {
            log.info((Object)("Result: " + result));
        }
        return result;
    }
}

