/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import fr.ifremer.echobase.EchoBaseFunctions;
import fr.ifremer.echobase.entities.EchoBaseUserEntityEnum;
import fr.ifremer.echobase.entities.ImportLog;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.service.DbEditorService;
import fr.ifremer.echobase.services.service.DecoratorService;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.pager.FilterRule;
import org.nuiton.topia.persistence.pager.FilterRuleGroupOperator;
import org.nuiton.topia.persistence.pager.FilterRuleOperator;

public class GetEntities
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GetEntities.class);
    protected String voyageId;
    protected EchoBaseUserEntityEnum entityType;
    protected Map<?, ?>[] datas;
    @Inject
    protected transient UserDbPersistenceService userDbPersistenceService;
    @Inject
    protected transient DbEditorService dbEditorService;
    @Inject
    protected transient DecoratorService decoratorService;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    public void setEntityType(EchoBaseUserEntityEnum entityType) {
        this.entityType = entityType;
    }

    public Map<?, ?>[] getDatas() {
        return this.datas;
    }

    public String execute() throws Exception {
        Boolean ascendantOrder = this.isSortAscendant();
        String sortColumn = this.getSortColumn();
        this.initFilter();
        if (log.isDebugEnabled()) {
            log.debug((Object)("filters      = " + this.getFilters()));
            log.debug((Object)("sidx         = " + sortColumn));
            log.debug((Object)("sord         = " + ascendantOrder));
        }
        this.datas = this.dbEditorService.getData(this.entityType, this.pager);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total page = " + this.getTotal()));
        }
        return "success";
    }

    public String entityModificationLogs() throws Exception {
        this.entityType = EchoBaseUserEntityEnum.EntityModificationLog;
        this.execute();
        return "success";
    }

    public String entityImportLogs() throws Exception {
        this.entityType = EchoBaseUserEntityEnum.ImportLog;
        if (StringUtils.isNotBlank((CharSequence)this.voyageId)) {
            this.pager.setRules(Arrays.asList(new FilterRule(FilterRuleOperator.eq, "voyageId", this.voyageId)));
            this.pager.setGroupOp(FilterRuleGroupOperator.AND);
        }
        this.execute();
        Map importTypes = this.decoratorService.decorateEnums((Enum[])ImportType.values());
        for (Map row : this.datas) {
            String importType = (String)row.get("importType");
            String importTypeToString = (String)importTypes.get(importType);
            row.put("importType", importTypeToString);
            Voyage voyage = this.userDbPersistenceService.getVoyage((String)row.get("voyageId"));
            this.decoratorService.decorateForeignKey(row, "voyageId", (TopiaEntity)voyage, null);
        }
        return "success";
    }

    public String dashboardImportLogs() throws Exception {
        this.entityType = EchoBaseUserEntityEnum.Voyage;
        this.execute();
        Decorator importLogDecorator = this.decoratorService.getDecorator(this.getLocale(), ImportLog.class, "dateOnly");
        ImmutableListMultimap importLogsByVoyage = Multimaps.index((Iterable)this.userDbPersistenceService.getImportLogs(), (Function)EchoBaseFunctions.IMPORT_LOG_VOYAGE_ID);
        for (Map row : this.datas) {
            String id = (String)row.get("id");
            Collection importLogs = importLogsByVoyage.get((Object)id);
            Voyage voyage = this.userDbPersistenceService.getVoyage(id);
            this.decoratorService.decorateForeignKey(row, "id", (TopiaEntity)voyage, null);
            HashMap imports = Maps.newHashMap();
            ArrayListMultimap result = ArrayListMultimap.create();
            for (ImportLog importLog : importLogs) {
                String importLogToString = importLogDecorator.toString((Object)importLog);
                String importId = importLog.getTopiaId();
                imports.put(importId, importLogToString);
                result.put((Object)importLog.getImportType(), (Object)importId);
            }
            row.put("importLogs", imports);
            for (ImportType importType : result.keySet()) {
                row.put("importType." + importType.name(), result.get((Object)importType));
            }
        }
        return "success";
    }
}

