package fr.ifremer.echobase.ui.actions.spatial;

/*
 * #%L
 * EchoBase :: UI
 * %%
 * Copyright (C) 2011 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * To display only the spatial data map.
 * <p/>
 * This action will be reused to raster spatial data maps.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public class ShowMap extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(ShowMap.class);

    protected final ShowSpatialModel model = new ShowSpatialModel();

    public ShowSpatialModel getModel() {
        return model;
    }

    @Override
    public String execute() throws Exception {

        if (log.isInfoEnabled()) {
            log.info("Loading spatial view for voyage: " + model.getVoyageId());
        }
        return SUCCESS;
    }
}
