package fr.ifremer.echobase.ui.actions.spatial;

/*
 * #%L
 * EchoBase :: UI
 * $Id: GetVoyageDataMetadata.java 929 2014-01-22 21:32:46Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.5.2/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/spatial/GetVoyageDataMetadata.java $
 * %%
 * Copyright (C) 2011 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.DataMetadata;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.services.service.spatial.SpatialService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;

import javax.inject.Inject;
import java.util.Map;

/**
 * Obtain all dataMetadata used for a given voyage.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public class GetVoyageDataMetadata extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Selected voyage id. */
    protected String voyageId;

    /** Universe of result. */
    protected Map<String, String> data;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    public Map<String, String> getData() {
        return data;
    }

    @Override
    public String execute() throws Exception {

        if (StringUtils.isEmpty(voyageId)) {
            data = Maps.newLinkedHashMap();

        } else {

            Voyage voyage = userDbPersistenceService.getVoyage(voyageId);

            Preconditions.checkNotNull(
                    voyage,
                    "Could not find voyage with id " + voyageId);

            data = userDbPersistenceService.loadSortAndDecorate(DataMetadata.class);
        }

        return SUCCESS;
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    @Inject
    protected transient UserDbPersistenceService userDbPersistenceService;

    @Inject
    protected transient SpatialService spatialService;
}