<%--
  #%L
  EchoBase :: UI
  $Id: showData.jsp 844 2013-09-11 15:58:38Z tchemit $
  $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.3/echobase-ui/src/main/webapp/WEB-INF/jsp/spatial/showData.jsp $
  %%
  Copyright (C) 2011 - 2013 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<title>
  <s:text name="echobase.title.show.spatial"/>
</title>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<s:if test="model.withSpatial">

  <script type="text/javascript">

    jQuery(document).ready(function () {

      var getVoyage = $('[name="model.voyageId"]');

      $.autoSelectVoyageAndDataMetadata(
        getVoyage,
        $('[name="model.dataMetadataId"]'),
        '<s:url action="getVoyageDataMetadata" namespace="/spatial"/>',
        '<s:property value="model.voyageId"/>',
        '<s:property value="model.dataMetadataId"/>'
      );

      $.autoSelectVoyageAndSpecies(
        getVoyage,
        $('[name="model.speciesId"]'),
        '<s:url action="getVoyageSpecies" namespace="/spatial"/>',
        '<s:property value="model.voyageId"/>',
        '<s:property value="model.speciesId"/>'
      );

      $.autoSelectVoyageAndEchotype(
        getVoyage,
        $('[name="model.echotypeId"]'),
        '<s:url action="getVoyageEchotype" namespace="/spatial"/>',
        '<s:property value="model.voyageId"/>',
        '<s:property value="model.echotypeId"/>'
      );

      <s:if test="model.withData">
      jQuery.get(
        '<s:url action="displaySpatial" namespace="/spatial"/>',
        {
          "model.voyageId": '<s:property value="model.voyageId"/>',
          "model.dataMetadataId": '<s:property value="model.dataMetadataId"/>',
          "model.cellTypeId": '<s:property value="model.cellTypeId"/>',
          "model.speciesId": '<s:property value="model.speciesId"/>',
          "model.echotypeId": '<s:property value="model.echotypeId"/>'
        },
        function (result) {

          // inject result
          $('#dataPanel').html(result);
        });
      </s:if>
    });
  </script>

  <s:form namespace="/spatial" method="POST" enctype="multipart/form-data">

    <fieldset>
      <legend>
        <s:text name="echobase.legend.showData.configure"/>
      </legend>

      <div class="cleanBoth help">
        <s:a href="%{getDocumentation('showData.html', null)}" target="doc">
          <s:text name="echobase.action.show.showData.documentation"/>
        </s:a>
      </div>
      <br/>

      <s:select key="model.voyageId" requiredLabel="true"
                label='%{getText("echobase.common.voyage")}'
                list="voyages" headerKey="" headerValue=""/>

      <sj:select key="model.dataMetadataId" requiredLabel="true"
                 label='%{getText("echobase.common.dataMetadata")}'
                 headerKey="" headerValue=""/>

      <s:select key="model.cellTypeId" requiredLabel="true"
                label='%{getText("echobase.common.cellType")}'
                list="cellTypes" headerKey="" headerValue=""/>

      <sj:select key="model.speciesId" requiredLabel="false"
                 label='%{getText("echobase.common.species")}'
                 headerKey="" headerValue=""/>

      <sj:select key="model.echotypeId" requiredLabel="false"
                 label='%{getText("echobase.common.echotype")}'
                 headerKey="" headerValue=""/>

      <s:hidden key="model.withData" label=' '/>
      <s:hidden key="model.withSpatial" label=' '/>

    </fieldset>
    <br/>

    <div class="toolbar">
      <ul class="toolbar floatRight">
        <li>
          <s:submit action='reconfigure' key="echobase.action.reset"/>
        </li>
        <li>
          <s:submit action='save' key="echobase.action.save"/>
        </li>
        <li>
          <s:submit action="showSpatial" key='echobase.action.display'/>
        </li>
      </ul>
    </div>

    <s:if test="model.withData">

      <fieldset>
        <legend>
          <s:text name="echobase.legend.showData.result"/>
        </legend>

        <div id="dataPanel">
          <center>Loading...</center>
        </div>
      </fieldset>
    </s:if>

  </s:form>
</s:if>
<s:else>

  <p>
    <s:text name="echobase.message.no.spatial.database.support"/>
  </p>
</s:else>


