/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.opensymphony.xwork2.ActionContext;
import fr.ifremer.echobase.config.EchoBaseConfiguration;
import fr.ifremer.echobase.entities.DriverType;
import fr.ifremer.echobase.entities.TopiaEchoBaseInternalPersistenceContext;
import fr.ifremer.echobase.entities.TopiaEchoBasePersistenceContext;
import fr.ifremer.echobase.entities.spatial.SpatialDataCache;
import fr.ifremer.echobase.persistence.EchoBaseDbMeta;
import fr.ifremer.echobase.persistence.EchoBaseEntityHelper;
import fr.ifremer.echobase.persistence.EchobaseTopiaContexts;
import fr.ifremer.echobase.services.DefaultEchoBaseServiceContext;
import fr.ifremer.echobase.services.EchoBaseServiceContext;
import fr.ifremer.echobase.services.service.UserService;
import fr.ifremer.echobase.services.service.embeddedapplication.EmbeddedApplicationService;
import fr.ifremer.echobase.services.service.workingDb.WorkingDbConfigurationService;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ird.converter.FloatConverter;
import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.RecursiveProperties;
import org.nuiton.util.SortedProperties;
import org.nuiton.util.converter.ConverterUtil;

public class EchoBaseApplicationContext {
    private static Log log = LogFactory.getLog(EchoBaseApplicationContext.class);
    private static final String APPLICATION_CONTEXT_PARAMETER = "echobaseApplicationContext";
    protected Set<EchoBaseSession> sessions;
    protected EchoBaseConfiguration configuration;
    protected EchoBaseDbMeta dbMeta;
    protected TopiaContext internalRootContext;
    protected boolean defaultUsersCreated;
    protected final SpatialDataCache spatialDataCache = new SpatialDataCache();

    public static EchoBaseApplicationContext getApplicationContext(ActionContext actionContext) {
        Map application = actionContext.getApplication();
        EchoBaseApplicationContext result = (EchoBaseApplicationContext)application.get(APPLICATION_CONTEXT_PARAMETER);
        return result;
    }

    public static EchoBaseApplicationContext getApplicationContext(ServletContext servletContext) {
        EchoBaseApplicationContext result = (EchoBaseApplicationContext)servletContext.getAttribute(APPLICATION_CONTEXT_PARAMETER);
        return result;
    }

    public static void setApplicationContext(ServletContext servletContext, EchoBaseApplicationContext applicationContext) {
        servletContext.setAttribute(APPLICATION_CONTEXT_PARAMETER, (Object)applicationContext);
    }

    public static void removeApplicationContext(ServletContext servletContext) {
        servletContext.removeAttribute(APPLICATION_CONTEXT_PARAMETER);
    }

    public Set<EchoBaseSession> getEchoBaseSessions() {
        return this.sessions;
    }

    public synchronized void registerEchoBaseSession(EchoBaseSession session) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)session.getUser());
        if (this.sessions == null) {
            this.sessions = Sets.newHashSet();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Register user session for [" + session.getUser().getEmail() + "]"));
        }
        this.sessions.add(session);
    }

    public synchronized void destroyEchoBaseSession(EchoBaseSession session) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)session.getUser());
        Preconditions.checkNotNull((Object)this.sessions);
        if (log.isInfoEnabled()) {
            log.info((Object)("Destroy user session for [" + session.getUser().getEmail() + "]"));
        }
        this.sessions.remove(session);
        session.close();
    }

    public void init() {
        DefaultI18nInitializer i18nInitializer = new DefaultI18nInitializer("echobase-i18n");
        i18nInitializer.setMissingKeyReturnNull(true);
        I18n.init((I18nInitializer)i18nInitializer, (Locale)Locale.getDefault());
        Converter converter = ConverterUtil.getConverter(Float.class);
        if (converter != null) {
            ConvertUtils.deregister(Float.class);
        }
        ConvertUtils.register((Converter)new FloatConverter(), Float.class);
        EchoBaseConfiguration configuration = new EchoBaseConfiguration();
        try {
            this.initLog(configuration);
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.ALL, "Could not init logger.", e);
        }
        TopiaContext internalRootContext = EchobaseTopiaContexts.newInternalDb((File)configuration.getInternalDbDirectory());
        this.setConfiguration(configuration);
        this.setDbMeta(EchoBaseDbMeta.newDbMeta());
        this.setInternalRootContext(internalRootContext);
        EchoBaseServiceContext serviceContext = DefaultEchoBaseServiceContext.newContext((Locale)Locale.getDefault(), (EchoBaseConfiguration)this.getConfiguration(), (EchoBaseDbMeta)this.getDbMeta(), (SpatialDataCache)this.getSpatialDataCache());
        this.initInternalDatabase(serviceContext);
        try {
            this.extractFiles(serviceContext);
        }
        catch (IOException e) {
            throw new TopiaException("Could not extract files (drivers + embedded war)", (Throwable)e);
        }
    }

    public EchoBaseConfiguration getConfiguration() {
        return this.configuration;
    }

    public EchoBaseDbMeta getDbMeta() {
        return this.dbMeta;
    }

    public TopiaContext getInternalRootContext() {
        return this.internalRootContext;
    }

    public boolean isDefaultUsersCreated() {
        return this.defaultUsersCreated;
    }

    public SpatialDataCache getSpatialDataCache() {
        return this.spatialDataCache;
    }

    public EchoBaseServiceContext newServiceContext(Locale locale, TopiaContext topiaInternalContext, TopiaContext topiaContext) {
        EchoBaseServiceContext newServiceContext = DefaultEchoBaseServiceContext.newContext((Locale)locale, (EchoBaseConfiguration)this.configuration, (EchoBaseDbMeta)this.dbMeta, (SpatialDataCache)this.spatialDataCache);
        TopiaEchoBaseInternalPersistenceContext internalPersistenceContext = new TopiaEchoBaseInternalPersistenceContext(topiaInternalContext);
        newServiceContext.setEchoBaseInternalPersistenceContext(internalPersistenceContext);
        TopiaEchoBasePersistenceContext persistenceContext = new TopiaEchoBasePersistenceContext(topiaContext);
        newServiceContext.setEchoBasePersistenceContext(persistenceContext);
        return newServiceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.spatialDataCache.clear();
            if (this.internalRootContext != null) {
                try {
                    EchoBaseEntityHelper.releaseH2RootContext((TopiaContext)this.internalRootContext);
                }
                catch (SQLException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Could not close internal db", (Throwable)e);
                    }
                }
            }
        }
        finally {
            try {
                if (CollectionUtils.isNotEmpty((Collection)this.sessions)) {
                    for (EchoBaseSession session : this.sessions) {
                        this.destroyEchoBaseSession(session);
                    }
                }
            }
            finally {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                LogFactory.release((ClassLoader)contextClassLoader);
                Introspector.flushCaches();
            }
        }
    }

    public void setDbMeta(EchoBaseDbMeta dbMeta) {
        this.dbMeta = dbMeta;
    }

    public void setInternalRootContext(TopiaContext internalRootContext) {
        this.internalRootContext = internalRootContext;
    }

    public void setDefaultUsersCreated(boolean defaultUsersCreated) {
        this.defaultUsersCreated = defaultUsersCreated;
    }

    public void setConfiguration(EchoBaseConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInternalDatabase(EchoBaseServiceContext serviceContext) throws TopiaException {
        EchoBaseConfiguration configuration = this.getConfiguration();
        Preconditions.checkNotNull((Object)configuration);
        EchoBaseDbMeta dbMeta = this.getDbMeta();
        Preconditions.checkNotNull((Object)dbMeta);
        TopiaContext rootContext = this.getInternalRootContext();
        Preconditions.checkNotNull((Object)rootContext);
        if (configuration.isUpdateSchema()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Will update schema...");
            }
            rootContext.updateSchema();
        }
        TopiaContext tx = rootContext.beginTransaction();
        try {
            serviceContext.setEchoBaseInternalPersistenceContext(new TopiaEchoBaseInternalPersistenceContext(tx));
            UserService service = (UserService)serviceContext.newService(UserService.class);
            List users = service.getUsers();
            if (CollectionUtils.isEmpty((Collection)users)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No user in database, will create default users.");
                }
                service.createDefaultUsers();
            }
            if (configuration.isEmbedded()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Will try to create default working db configuration for internal db.");
                }
                ((WorkingDbConfigurationService)serviceContext.newService(WorkingDbConfigurationService.class)).createEmbeddedWorkingDbConfiguration();
            }
        }
        finally {
            serviceContext.setEchoBaseInternalPersistenceContext(null);
            EchoBaseEntityHelper.closeConnection((TopiaContext)tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initLog(EchoBaseConfiguration configuration) throws IOException {
        File logFile = configuration.getLogConfigFile();
        if (!logFile.exists()) {
            EmbeddedApplicationService.copyEmbeddedBinaryFile((String)logFile.getName(), (File)logFile.getParentFile());
            RecursiveProperties properties = new RecursiveProperties();
            BufferedReader reader = Files.newReader((File)logFile, (Charset)Charsets.UTF_8);
            try {
                properties.load((Reader)reader);
                reader.close();
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            properties.setProperty("echobase.log.dir", configuration.getDefaultLogDirectory().getAbsolutePath());
            SortedProperties p2 = new SortedProperties();
            for (Map.Entry entry : properties.entrySet()) {
                String key = String.valueOf(entry.getKey());
                p2.setProperty(key, properties.getProperty(key));
            }
            p2.remove("echobase.log.dir");
            BufferedWriter writer = Files.newWriter((File)logFile, (Charset)Charsets.UTF_8);
            try {
                p2.store(writer, "Generated by " + this.getClass().getName());
                writer.close();
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((String)logFile.getAbsolutePath());
        log = LogFactory.getLog(EchoBaseApplicationContext.class);
        if (log.isInfoEnabled()) {
            log.info((Object)("Use now logFile: " + logFile));
        }
    }

    protected void extractFiles(EchoBaseServiceContext serviceContext) throws IOException {
        EmbeddedApplicationService service = (EmbeddedApplicationService)serviceContext.newService(EmbeddedApplicationService.class);
        EchoBaseConfiguration configuration = serviceContext.getConfiguration();
        File libDirectory = configuration.getLibDirectory();
        for (DriverType driverType : DriverType.values()) {
            String pilotFileName = driverType.getPilotFileName(configuration);
            if (log.isInfoEnabled()) {
                log.info((Object)("Copy embedded resource " + pilotFileName + " to directory " + libDirectory));
            }
            EmbeddedApplicationService.copyEmbeddedBinaryFile((String)pilotFileName, (File)libDirectory);
        }
        File warLocation = configuration.getWarLocation();
        File embeddedWarDirectory = warLocation.getParentFile();
        String embeddedWarFileName = warLocation.getName();
        if (log.isInfoEnabled()) {
            log.info((Object)("Copy embedded war " + embeddedWarFileName + " to directory " + embeddedWarDirectory));
        }
        EmbeddedApplicationService.copyEmbeddedBinaryFile((String)embeddedWarFileName, (File)embeddedWarDirectory);
    }
}

