package fr.ifremer.echobase.ui.actions.workingDb;

/*
 * #%L
 * EchoBase :: UI
 * $Id: GetImportLogDetail.java 686 2012-09-22 13:46:36Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-2.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/workingDb/GetImportLogDetail.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.entities.ImportLog;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.nuiton.topia.persistence.metadata.TableMeta;

import java.util.Map;

/**
 * Obtain details of a given {@link ImportLog}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetImportLogDetail extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    protected String importLogId;

    protected Map data;

    public void setImportLogId(String importLogId) {
        this.importLogId = importLogId;
    }

    public Map<?, ?> getData() {
        return data;
    }

    @Override
    public String execute() throws Exception {

        DbEditorService service = getService(DbEditorService.class);
        TableMeta<EchoBaseEntityEnum> tableMeta = service.getTableMeta(EchoBaseEntityEnum.ImportLog);
        data = service.getData(tableMeta, importLogId);


        // decorate import type
        Map<String, String> importTypes = decorateEnums(ImportType.values());
        String importType = (String) data.get(ImportLog.PROPERTY_IMPORT_TYPE);
        data.put(ImportLog.PROPERTY_IMPORT_TYPE, importTypes.get(importType));

        // decorate foreign keys
        service.decorateForeignKey(data, Voyage.class, ImportLog.PROPERTY_VOYAGE_ID, null);

        return SUCCESS;
    }

}