/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import fr.ifremer.echobase.EchoBaseFunctions;
import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.entities.ImportLog;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.services.DecoratorService;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.pager.FilterRule;
import org.nuiton.topia.persistence.pager.FilterRuleOperator;
import org.nuiton.util.decorator.Decorator;

public class GetEntities
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GetEntities.class);
    protected EchoBaseEntityEnum entityType;
    protected Map<?, ?>[] datas;
    protected String voyageId;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    public Map<?, ?>[] getDatas() {
        return this.datas;
    }

    public String execute() throws Exception {
        Boolean ascendantOrder = this.isSortAscendant();
        String sortColumn = this.getSortColumn();
        this.initFilter();
        if (log.isDebugEnabled()) {
            log.debug((Object)("filters      = " + this.getFilters()));
            log.debug((Object)("sidx         = " + sortColumn));
            log.debug((Object)("sord         = " + ascendantOrder));
        }
        this.datas = ((DbEditorService)this.getService(DbEditorService.class)).getData(this.entityType, this.pager);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total page = " + this.getTotal()));
        }
        return "success";
    }

    public String entityModificationLogs() throws Exception {
        this.entityType = EchoBaseEntityEnum.EntityModificationLog;
        this.execute();
        return "success";
    }

    public String entityImportLogs() throws Exception {
        this.entityType = EchoBaseEntityEnum.ImportLog;
        if (StringUtils.isNotBlank((CharSequence)this.voyageId)) {
            this.pager.setRules(Arrays.asList(new FilterRule(FilterRuleOperator.eq, "voyageId", this.voyageId)));
        }
        this.execute();
        Map importTypes = this.decorateEnums((Enum[])ImportType.values());
        DbEditorService service = (DbEditorService)this.getService(DbEditorService.class);
        for (Map row : this.datas) {
            String importType = (String)row.get("importType");
            String importTypeToString = (String)importTypes.get(importType);
            row.put("importType", importTypeToString);
            service.decorateForeignKey(row, Voyage.class, "voyageId", null);
        }
        return "success";
    }

    public String dashboardImportLogs() throws Exception {
        this.entityType = EchoBaseEntityEnum.Voyage;
        this.execute();
        DbEditorService service = (DbEditorService)this.getService(DbEditorService.class);
        DecoratorService decoratorService = (DecoratorService)this.getService(DecoratorService.class);
        Decorator importLogDecorator = decoratorService.getDecorator(this.getLocale(), ImportLog.class, "dateOnly");
        ImmutableListMultimap importLogsByVoyage = Multimaps.index((Iterable)service.getEntities(ImportLog.class), (Function)EchoBaseFunctions.IMPORT_LOG_VOYAGE_ID);
        for (Map row : this.datas) {
            String id = (String)row.get("id");
            Collection importLogs = importLogsByVoyage.get((Object)id);
            service.decorateForeignKey(row, Voyage.class, "id", null);
            HashMap imports = Maps.newHashMap();
            ArrayListMultimap result = ArrayListMultimap.create();
            for (ImportLog importLog : importLogs) {
                String importLogToString = importLogDecorator.toString((Object)importLog);
                String importId = importLog.getTopiaId();
                imports.put(importId, importLogToString);
                result.put((Object)importLog.getImportType(), (Object)importId);
            }
            row.put("importLogs", imports);
            for (ImportType importType : result.keySet()) {
                row.put("importType." + importType.name(), result.get((Object)importType));
            }
        }
        return "success";
    }
}

